<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Retail and E-commerce</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('front/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="icon" href="<?php echo e(getFaviconUrl()); ?>" type="image/png">

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vcard26.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider/css/slick-theme.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/slick-theme.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/custom.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/plugins.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-vcard.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/lightbox.css')); ?>">
</head>

<body>
    <div class="container p-0">
        <div class="main-content mx-auto w-100 overflow-hidden">
            <div class="banner-section position-relative">
                <div class="banner-img">
                    <img src="<?php echo e(asset('assets/img/vcard26/banner-img.png')); ?>" class="banner-img object-fit-cover w-100 h-100" loading="lazy"/>
                </div>
                <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
                    <div class="language pt-3 me-2">
                        <ul class="text-decoration-none">
                            <li class="dropdown1 dropdown lang-list">
                                <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                                    role="button" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa-solid fa-language me-2"></i>Language</a>
                                <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/english.png')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">English</a>
                                    </li>
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/spain.png')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">Spanish</a>
                                    </li>
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/france.png')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">Franch</a>
                                    </li>
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/arabic.svg')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">Arabic</a>
                                    </li>
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/german.png')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">German</a>
                                    </li>
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/russian.jpeg')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">russian</a>
                                    </li>
                                    <li>
                                        <img src="<?php echo e(asset('assets/img/vcard1/turkish.png')); ?>" width="25px"
                                            height="20px" class="me-3" loading="lazy"><a href="#">Turkish</a>
                                    </li>

                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="overlay"></div>
            </div>
            <div class="profile-section px-30">
                <div class="cart-img">
                    <img src="<?php echo e(asset('assets/img/vcard26/cart.png')); ?>" alt="cart-img" loading="lazy"/>
                </div>
                <div class="percentage-img text-end">
                    <img src="<?php echo e(asset('assets/img/vcard26/percentage.png')); ?>" alt="percentage-img" loading="lazy"/>
                </div>
                <div class="card d-flex align-items-center justify-content-center mb-3">
                    <div class="card-img">
                        <img src="<?php echo e(asset('assets/img/vcard26/profile-img.png')); ?>"
                            class="w-100 h-100 object-fit-cover" loading="lazy"/>
                    </div>
                    <div class="card-body text-center">
                        <div class="profile-name">
                            <h4 class="text-primary mb-1 mt-1 fw-5">Brooklyn Simmons</h4>
                            <p class="fs-18 text-gray-100 mb-0">Marketing Manager</p>
                        </div>
                    </div>
                </div>
                <div class="social-media d-flex justify-content-center flex-wrap mb-3 pb-3">
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M14.9704 25.4998C14.9704 22.5882 14.9704 19.6825 14.9704 16.7413C15.9436 16.7413 16.8934 16.7413 17.8667 16.7413C18.0543 15.5188 18.2361 14.3257 18.4237 13.0973C17.2628 13.0973 16.1254 13.0973 15.0114 13.0973C15.0114 12.0992 14.941 11.1365 15.029 10.1857C15.1052 9.35292 15.797 8.83319 16.6706 8.78594C17.1866 8.75641 17.7084 8.76823 18.2243 8.76823C18.3299 8.76823 18.4354 8.76823 18.5527 8.76823C18.5527 7.71696 18.5527 6.70113 18.5527 5.66168C17.2335 5.50222 15.9319 5.28961 14.6127 5.53175C12.6779 5.89202 11.3353 7.28583 11.1359 9.27023C11.0245 10.4042 11.0714 11.5499 11.048 12.6898C11.048 12.8138 11.048 12.9378 11.048 13.0973C9.97505 13.0973 8.93729 13.0973 7.88781 13.0973C7.88781 14.3257 7.88781 15.5188 7.88781 16.7413C8.94315 16.7413 9.97505 16.7413 11.0245 16.7413C11.0245 19.6766 11.0245 22.5823 11.0245 25.4939C6.61553 25.0097 0.969417 20.8873 0.529689 13.9064C0.0723718 6.71885 5.53673 0.877845 12.3203 0.51758C19.6432 0.127786 25.4652 6.00423 25.5062 13.0028C25.5414 19.9423 20.1826 24.8502 14.9704 25.4998Z" />
                        </svg>
                    </a>
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_616_3757)">
                                <path
                                    d="M5.71959 0.166672C9.25045 0.166672 12.7653 0.166672 16.2961 0.166672C16.5208 0.198747 16.7455 0.230822 16.9542 0.278934C19.4097 0.824209 20.9825 2.3157 21.6566 4.73736C21.7369 5.05811 21.769 5.37886 21.8332 5.71565C21.8332 9.2439 21.8332 12.7561 21.8332 16.2844C21.8171 16.3645 21.8171 16.4287 21.785 16.5089C21.6406 17.0702 21.5764 17.6636 21.3356 18.1928C20.2603 20.5343 18.3986 21.7692 15.8307 21.8173C12.6208 21.8654 9.3949 21.8333 6.18502 21.8333C4.93317 21.8333 3.77761 21.4965 2.7665 20.7749C1.03317 19.5239 0.182553 17.84 0.166504 15.723C0.166504 12.5637 0.166504 9.40427 0.166504 6.26092C0.166504 5.85998 0.182553 5.44301 0.27885 5.04207C0.824529 2.58833 2.31712 1.01666 4.74058 0.343084C5.06156 0.262897 5.38255 0.230822 5.71959 0.166672ZM2.09243 10.992C2.09243 12.5637 2.09243 14.1193 2.09243 15.691C2.09243 16.1881 2.14058 16.6693 2.31712 17.1504C2.927 18.8664 4.40354 19.9088 6.26527 19.9088C9.427 19.9088 12.5887 19.9249 15.7344 19.9088C16.1998 19.9088 16.6974 19.8447 17.1467 19.6843C18.8801 19.107 19.9072 17.5994 19.9072 15.723C19.9072 12.5797 19.9233 9.42031 19.8912 6.27696C19.8912 5.81187 19.827 5.31471 19.6826 4.86566C19.1048 3.13361 17.6122 2.09117 15.7505 2.09117C12.5887 2.09117 9.427 2.09117 6.24922 2.09117C4.83687 2.09117 3.68132 2.65248 2.8307 3.80718C2.28502 4.54491 2.07638 5.37886 2.07638 6.293C2.09243 7.84863 2.09243 9.42031 2.09243 10.992Z" />
                                <path
                                    d="M10.9997 16.573C7.9343 16.573 5.41455 14.0551 5.41455 10.992C5.41455 7.92882 7.95035 5.41093 10.9997 5.41093C14.0652 5.42697 16.5689 7.91278 16.5689 10.9759C16.601 14.0391 14.0812 16.557 10.9997 16.573ZM14.659 10.992C14.659 8.9873 13.022 7.33543 10.9997 7.33543C8.99356 7.33543 7.34048 8.97126 7.34048 10.992C7.34048 12.9967 8.97751 14.6485 10.9997 14.6485C13.0059 14.6485 14.659 13.0127 14.659 10.992Z" />
                                <path
                                    d="M16.8096 3.79117C17.58 3.79117 18.238 4.43267 18.2219 5.20247C18.2219 5.97227 17.58 6.59773 16.8096 6.59773C16.0392 6.59773 15.3812 5.95623 15.3973 5.18643C15.4133 4.41663 16.0392 3.79117 16.8096 3.79117Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_616_3757">
                                    <rect width="21.6667" height="21.6667" fill="white"
                                        transform="translate(0.166504 0.166672)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </a>
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_616_3783)">
                                <path
                                    d="M17.3418 21.8237C17.3418 21.7078 17.3418 21.6016 17.3418 21.5002C17.3418 19.1582 17.3515 16.8163 17.3322 14.4743C17.3274 13.8804 17.2744 13.2816 17.1589 12.7022C16.9327 11.5626 16.2684 11.0266 15.1082 10.9783C14.3621 10.9445 13.6641 11.0893 13.125 11.6543C12.6677 12.1324 12.4703 12.736 12.3981 13.383C12.3452 13.8707 12.3211 14.3632 12.3211 14.851C12.3115 17.0818 12.3163 19.3079 12.3163 21.5388C12.3163 21.6305 12.3163 21.7271 12.3163 21.8333C10.8144 21.8333 9.34138 21.8333 7.84912 21.8333C7.84912 17.0142 7.84912 12.2 7.84912 7.37603C9.27399 7.37603 10.6892 7.37603 12.1382 7.37603C12.1382 8.02308 12.1382 8.66048 12.1382 9.29787C12.1574 9.3027 12.1719 9.30753 12.1911 9.31236C12.2296 9.26407 12.2681 9.22061 12.3018 9.17233C13.0768 7.93616 14.2225 7.27945 15.6329 7.07181C16.6486 6.92212 17.6499 7.00904 18.6319 7.31808C20.0423 7.76233 20.904 8.74257 21.3565 10.1188C21.6886 11.1231 21.8042 12.1613 21.8138 13.214C21.833 16.0388 21.8282 18.8637 21.8282 21.6885C21.8282 21.7271 21.8234 21.7657 21.8186 21.8333C20.3408 21.8237 18.863 21.8237 17.3418 21.8237Z" />
                                <path
                                    d="M0.546875 7.37602C2.04395 7.37602 3.51696 7.37602 4.99959 7.37602C4.99959 12.2 4.99959 17.0094 4.99959 21.8333C3.51214 21.8333 2.03914 21.8333 0.546875 21.8333C0.546875 17.0191 0.546875 12.2048 0.546875 7.37602Z" />
                                <path
                                    d="M5.3595 2.76938C5.36432 4.218 4.2042 5.38174 2.76008 5.38174C1.32077 5.38174 0.155846 4.21318 0.160659 2.76938C0.170287 1.3304 1.32077 0.1715 2.75527 0.166672C4.19458 0.161843 5.3595 1.32075 5.3595 2.76938Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_616_3783">
                                    <rect width="21.6667" height="21.6667" fill="white"
                                        transform="translate(0.166504 0.166672)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </a>
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M0.166504 21.8325C0.200373 21.7072 0.219727 21.6253 0.243919 21.5434C0.708412 19.8615 1.17291 18.1844 1.62772 16.5026C1.66159 16.3725 1.64224 16.1942 1.57934 16.0785C-0.525397 12.1606 -0.147997 7.54869 2.70186 4.13195C5.29044 1.01399 8.66769 -0.263067 12.6933 0.291129C15.2964 0.652562 17.4447 1.89589 19.1817 3.85244C22.5735 7.68363 22.7138 13.4232 19.5639 17.4953C16.4673 21.5 10.816 22.806 6.28233 20.5362C5.99202 20.3916 5.74526 20.3675 5.4356 20.4542C3.776 20.9024 2.11641 21.3265 0.451974 21.7602C0.374558 21.7795 0.292304 21.7988 0.166504 21.8325ZM5.52753 8.49323C5.60494 8.85949 5.65817 9.23537 5.75977 9.59681C5.96783 10.3197 6.40329 10.9221 6.83391 11.5244C8.32416 13.6063 10.2063 15.158 12.7127 15.8809C13.7578 16.1797 14.74 16.1411 15.6641 15.4906C16.3076 15.0376 16.5157 14.4063 16.506 13.6738C16.506 13.5533 16.4092 13.3798 16.3076 13.3268C15.5819 12.9605 14.8464 12.6087 14.1061 12.2714C13.8158 12.1365 13.6803 12.1943 13.482 12.4497C13.2255 12.7726 12.9691 13.0907 12.7078 13.4039C12.5627 13.5822 12.3836 13.6448 12.1514 13.5533C10.5402 12.9172 9.30637 11.8473 8.43061 10.363C8.31449 10.1703 8.32416 10.0112 8.47899 9.84258C8.66769 9.63536 8.84672 9.4185 9.0209 9.19682C9.24347 8.90768 9.2967 8.60889 9.13219 8.2571C8.8951 7.75591 8.70156 7.23545 8.48383 6.72463C8.15482 5.93911 8.15482 5.91984 7.29357 5.94875C7.06132 5.95839 6.78553 6.04513 6.61618 6.19452C5.91944 6.79209 5.56624 7.56315 5.52753 8.49323Z" />
                        </svg>
                    </a>
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1344_384)">
                                <path
                                    d="M7.3889 18.6214C5.04233 18.3168 3.48547 17.2112 2.60551 15C3.36137 15 4.02699 15 4.68132 15C2.3009 14.0636 0.958396 12.4278 0.789172 9.83305C1.51119 10.0361 2.17681 10.2279 2.84242 10.4084C2.87627 10.3633 2.91011 10.3182 2.94395 10.273C1.95118 9.47204 1.24044 8.47926 0.99224 7.21572C0.744045 5.95219 0.856861 4.73378 1.54504 3.48152C4.388 6.71934 7.86273 8.60336 12.1384 8.87412C12.1384 8.40029 12.1272 7.99415 12.1384 7.58802C12.2061 5.43323 13.2666 3.86509 15.1958 2.99641C17.0798 2.15029 18.93 2.37592 20.5545 3.70715C21.0058 4.07944 21.4119 4.15841 21.9196 3.95535C22.698 3.65074 23.4764 3.34614 24.3226 3.03026C23.9616 4.15841 23.217 4.92556 22.4385 5.7604C23.2508 5.54605 24.0631 5.32042 24.8754 5.10607C24.9092 5.13991 24.9543 5.17376 24.9882 5.2076C24.3451 5.87322 23.7359 6.59524 23.0365 7.19316C22.6529 7.52033 22.5062 7.84749 22.4949 8.3326C22.4273 11.7284 21.4119 14.8082 19.3135 17.4933C16.4931 21.1146 12.7477 22.9423 8.13348 23.0325C5.49359 23.0889 3.02293 22.5361 0.698919 21.2839C0.473287 21.1598 0.247656 21.0244 0.0107422 20.8326C2.68448 20.9567 5.1213 20.3249 7.3889 18.6214Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1344_384">
                                    <rect width="25" height="20.5325" fill="white"
                                        transform="translate(0 2.5)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </a>
                </div>
                <p class="text-gray-100 profile-desc fs-6 text-center mb-0">
                    Lorem Ipsum is simply dummy text of the printing and typesetting
                    industry. Lorem Ipsum has been the industry's standard dummy text
                    ever since the 1500s, when an unknown printer took a galley of type
                    and scrambled it to make a type specimen book.
                </p>
            </div>
            <div class="contact-section pt-60 px-30">
                <div class="open-box-img text-end">
                    <img src="<?php echo e(asset('assets/img/vcard26/open-box.png')); ?>" alt="open-box-img" loading="lazy"/>
                </div>
                <div class="section-heading text-center">
                    <h2 class="mb-0">Contact</h2>
                </div>
                <div class="row">
                    <div class="col-sm-6 mb-4 pb-sm-2">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-4">
                                <svg width="27" height="20" viewBox="0 0 27 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_671_16376)">
                                        <path
                                            d="M27 2.78896C27 2.60502 27 2.42605 27 2.24211C26.9631 2.07308 26.9367 1.90405 26.884 1.73999C26.6414 0.939597 26.1984 0.298285 25.2861 0.0894855C24.9855 0.0198857 24.6586 0.00497141 24.3475 0.00497141C17.1176 0 9.8877 0 2.65781 0C2.49961 0 2.34141 0 2.1832 0.0149142C1.7086 0.0546856 1.28672 0.223714 0.912306 0.507084C0.400782 0.894855 0.126566 1.40194 -0.00527 1.99354C-0.00527 2.19239 -0.00527 2.39125 -0.00527 2.59011C0.100199 3.09222 0.226759 3.58936 0.495705 4.04176C1.04414 4.9565 1.81406 5.66741 2.7211 6.25901C5.4 8.01889 8.07891 9.78374 10.7631 11.5387C11.2166 11.8369 11.6912 12.1054 12.1711 12.3639C13.0518 12.8362 13.9482 12.8312 14.8289 12.3589C15.2191 12.1501 15.6094 11.9413 15.9785 11.7027C18.7734 9.8782 21.5684 8.05369 24.3369 6.19935C25.6131 5.34427 26.6572 4.30524 27 2.78896Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M27 6.46783C25.36 7.9692 23.3455 8.9784 21.5209 10.2411C21.1201 10.5195 20.6982 10.7781 20.2711 11.0515C20.3186 11.1062 20.3555 11.1509 20.3924 11.1907C22.565 13.2389 24.7324 15.2822 26.8998 17.3254C26.9314 17.3552 26.9684 17.3801 27 17.4049C27 13.7609 27 10.1119 27 6.46783Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M8.53539e-05 17.4049C0.0791869 17.3353 0.158288 17.2707 0.232117 17.2011C2.33095 15.2225 4.43505 13.2439 6.53389 11.2603C6.59717 11.2006 6.65518 11.141 6.729 11.0664C6.64463 11.0067 6.5708 10.952 6.49697 10.9023C4.99931 9.93291 3.48583 8.98337 2.004 7.98908C1.3079 7.52177 0.669813 6.97492 8.53539e-05 6.46286C8.53539e-05 10.1119 8.53539e-05 13.7609 8.53539e-05 17.4049Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M8.4957 12.2347C5.94336 14.6408 3.40684 17.0321 0.854492 19.4383C1.20781 19.7564 1.64551 19.9255 2.13594 19.9801C2.27305 19.9951 2.41543 19.9951 2.55781 19.9951C9.85098 19.9951 17.1441 19.9951 24.4373 20C25.0754 20 25.6502 19.8608 26.1143 19.4731C23.5672 17.0719 21.0254 14.6756 18.4678 12.2645C17.9193 12.6324 17.3445 13.0351 16.7486 13.4129C16.0104 13.8852 15.2141 14.2481 14.3439 14.447C13.4369 14.6558 12.5773 14.4867 11.723 14.1536C10.7105 13.7609 9.85625 13.1395 8.97559 12.5529C8.81211 12.4534 8.65918 12.3441 8.4957 12.2347Z"
                                            fill="#FFD700" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_671_16376">
                                            <rect width="27" height="20" fill="white"
                                                transform="matrix(-1 0 0 1 27 0)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="mailto:jackie@gmail.com" class="text-white fs-6 fw-5">jackie@gmail.com</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-4 pb-sm-2">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-4">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.24875 11.2533C7.38447 15.3496 10.4178 18.4566 14.4261 20.5898C14.5964 20.6825 14.9988 20.5743 15.169 20.4197C16.0821 19.5541 16.9797 18.673 17.8464 17.761C18.3261 17.2509 18.8523 17.1736 19.5178 17.2973C21.0964 17.5755 22.6904 17.8537 24.2845 18.0392C25.5535 18.1938 26.0023 18.6112 26.0023 19.9096C26.0023 21.3008 26.0023 22.6766 26.0023 24.0678C26.0023 25.5672 25.5226 26.0309 23.9904 26C13.0952 25.8145 3.34518 18.0856 0.776133 7.48157C0.327324 5.61118 0.188038 3.64804 0.0177999 1.71581C-0.0905334 0.571938 0.54399 0.0154578 1.68923 0.0154578C3.2059 0 4.72256 0 6.23923 0C7.35351 0 7.8178 0.510107 7.95709 1.62307C8.17375 3.26159 8.4678 4.90012 8.77732 6.52319C8.90113 7.21879 8.77732 7.77527 8.26661 8.26992C7.24518 9.25922 6.2547 10.2485 5.24875 11.2533Z"
                                        fill="#FFD700" />
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="tel:+1 4078461474" class="text-white fs-6 fw-5">+1 4078461474</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-sm-0 mb-4">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-4">
                                <svg width="30" height="26" viewBox="0 0 30 26" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_681_16526)">
                                        <path
                                            d="M0.390531 26C0.264533 25.7615 0.0629374 25.5355 0.0251381 25.2844C-0.0378606 24.8324 0.0251381 24.3679 -6.1387e-05 23.916C-0.0126611 23.5017 0.163735 23.2883 0.592127 23.3008C0.718124 23.3008 0.844122 23.3008 0.970119 23.3008C10.3317 23.3008 19.6807 23.3008 29.0424 23.3134C29.3574 23.3134 29.6723 23.4389 29.9873 23.5017C29.9873 24.3303 29.9873 25.1714 29.9873 26C20.1343 26 10.2561 26 0.390531 26Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M15.0315 10.6461C18.3957 10.6461 21.7598 10.6461 25.1365 10.6461C27.0391 10.6461 27.9715 11.5877 27.9841 13.4959C27.9841 13.521 27.9841 13.5336 27.9841 13.5587C28.2109 14.6635 27.6943 15.2912 26.7115 15.718C25.7161 16.1449 24.7585 16.2328 23.8892 15.492C23.4608 15.128 23.108 14.6886 22.7552 14.2492C22.289 13.6842 21.848 13.6717 21.3692 14.2241C21.0542 14.5881 20.7392 14.9522 20.3864 15.2661C19.391 16.1574 18.2949 16.2579 17.1735 15.5423C16.6695 15.2159 16.2159 14.8016 15.7749 14.3873C15.1701 13.8223 14.9055 13.8223 14.3133 14.4124C13.9731 14.7513 13.6204 15.0778 13.2298 15.354C11.9068 16.3081 10.7098 16.2453 9.47504 15.1907C9.28604 15.0275 9.10965 14.8518 8.94585 14.6635C8.10167 13.6968 7.92527 13.6968 7.08109 14.7011C5.93451 16.057 4.48554 16.3583 2.87277 15.6301C2.24278 15.3414 2.00339 14.902 2.06639 14.2492C2.10419 13.9353 2.14199 13.6215 2.10419 13.3201C1.88999 11.776 3.13737 10.621 4.75013 10.6335C8.16467 10.6712 11.5918 10.6461 15.0315 10.6461Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M27.7321 21.606C19.2525 21.606 10.8107 21.606 2.33105 21.606C2.33105 20.2878 2.33105 18.9696 2.33105 17.6012C4.43521 18.3042 6.27478 17.8522 7.78675 16.2327C10.3067 18.6432 12.625 18.3168 15.0568 16.1574C18.0681 18.7687 20.2353 18.1661 22.2891 16.1198C22.982 16.8605 23.738 17.5384 24.7712 17.802C25.7918 18.0657 26.7494 17.8522 27.7573 17.4254C27.7321 18.8315 27.7321 20.1874 27.7321 21.606Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M13.2297 9.46596C13.2297 8.22308 13.2171 7.00531 13.2423 5.77499C13.2549 5.37325 13.5447 5.13472 13.9605 5.13472C14.6535 5.12217 15.3465 5.12217 16.0269 5.13472C16.5056 5.13472 16.7828 5.41092 16.7828 5.87542C16.808 7.05553 16.7954 8.24819 16.7954 9.46596C15.5985 9.46596 14.4393 9.46596 13.2297 9.46596Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M15.0188 0C15.3212 0.55239 15.674 1.18011 16.0142 1.82038C16.1654 2.10913 16.367 2.39788 16.4552 2.71173C16.6442 3.40222 16.3418 4.15548 15.8 4.45678C15.2582 4.75809 14.4266 4.67021 13.9856 4.26847C13.5194 3.82907 13.3682 2.98793 13.6958 2.37277C14.1242 1.54418 14.5904 0.740705 15.0188 0Z"
                                            fill="#FFD700" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_681_16526">
                                            <rect width="30" height="26" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="mb-0 text-white fs-6 fw-5">12th June, 1990</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-4">
                                <svg width="20" height="26" viewBox="0 0 20 26" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_681_16532)">
                                        <path
                                            d="M9.99348 21.3252C9.65861 20.9328 9.33688 20.5606 9.02171 20.185C7.32112 18.1393 5.71245 16.0232 4.32046 13.7462C3.69341 12.7233 3.14515 11.6603 2.67568 10.5502C1.81225 8.50122 1.95999 6.48574 2.91206 4.53398C4.14318 2.01212 6.16222 0.509733 8.89368 0.0905402C13.0959 -0.55334 17.088 2.45814 17.7742 6.71378C17.9974 8.10886 17.784 9.41674 17.2489 10.6978C16.6514 12.1264 15.8799 13.4544 15.0394 14.7388C13.5391 17.0259 11.8615 19.1688 10.0756 21.2279C10.0559 21.2514 10.0329 21.2782 9.99348 21.3252ZM13.9429 7.37108C13.9462 5.15103 12.1734 3.34347 9.99676 3.34347C7.81685 3.34347 6.04732 5.14768 6.04732 7.36772C6.04732 9.58777 7.81685 11.3953 9.99348 11.3953C12.1701 11.3953 13.9396 9.59447 13.9429 7.37108Z"
                                            fill="#FFD700" />
                                        <path
                                            d="M6.92352 18.592C6.54269 18.649 6.16515 18.7027 5.79088 18.7698C4.66153 18.9676 3.55517 19.246 2.51117 19.7457C2.10408 19.9435 1.71669 20.1716 1.39824 20.5036C0.886091 21.0401 0.886091 21.5901 1.41137 22.1166C1.85786 22.566 2.41268 22.8276 2.98721 23.0556C4.10014 23.4916 5.26232 23.7297 6.44092 23.8906C8.066 24.1153 9.70093 24.169 11.3391 24.0885C13.1743 23.9979 14.9898 23.7632 16.7397 23.1529C17.2584 22.9718 17.764 22.7571 18.2105 22.4218C18.4107 22.2709 18.6044 22.0965 18.7587 21.8986C19.0575 21.5163 19.0673 21.0904 18.7587 20.7182C18.5486 20.4633 18.2892 20.2319 18.0135 20.0508C17.242 19.5444 16.3753 19.256 15.4888 19.0481C14.7535 18.8771 14.0082 18.7664 13.2663 18.6289C13.2006 18.6155 13.1382 18.6054 13.0726 18.5954C13.194 18.3338 13.217 18.3271 13.4829 18.3472C14.5795 18.4344 15.6727 18.5551 16.7462 18.8C17.3306 18.9307 17.9084 19.0884 18.437 19.3734C18.7686 19.5511 19.0969 19.7591 19.3693 20.0139C20.0686 20.6712 20.1934 21.5834 19.7469 22.4419C19.5072 22.9047 19.156 23.2702 18.7554 23.5888C17.8822 24.283 16.8874 24.7424 15.8434 25.0945C13.6471 25.8357 11.3851 26.0805 9.08045 25.9799C7.31091 25.8994 5.58077 25.6076 3.90645 24.9973C2.87559 24.6217 1.89397 24.1522 1.05352 23.4144C0.685829 23.0925 0.373944 22.7169 0.176964 22.2575C-0.154618 21.4828 -0.00360029 20.6645 0.57749 20.0642C1.06337 19.5612 1.67729 19.2829 2.31748 19.0649C3.19404 18.7664 4.10014 18.6122 5.01281 18.4981C5.5184 18.4344 6.02398 18.3975 6.53284 18.3439C6.77907 18.3204 6.79876 18.3338 6.92352 18.592Z"
                                            fill="#FFD700" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_681_16532">
                                            <rect width="20" height="26" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="text-white mb-0 fs-6 fw-5">New York, USA</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="our-services-section pt-60 px-30">
                <div class="section-heading text-center">
                    <h2 class="mb-0">Our Services</h2>
                </div>
                <div class="services">
                    <div class="row">
                        <div class="col-12 mb-40">
                            <div class="service-card h-100">
                                <div class="card-img d-flex justify-content-center align-items-center">
                                    <svg width="36" height="28" viewBox="0 0 36 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_1276_369)">
                                            <path
                                                d="M0 25.2152C0 19.6437 0 14.0722 0 8.50075C0.0704501 8.49791 0.139961 8.49225 0.210411 8.49225C12.0301 8.49225 23.8506 8.49225 35.6703 8.49225C35.7717 8.49225 35.8732 8.50452 35.9822 8.51208C35.9897 8.58007 35.9991 8.6254 35.9991 8.67072C35.9991 14.0628 36.0056 19.4558 35.985 24.8478C35.9831 25.2803 35.8647 25.7478 35.6769 26.1387C35.0513 27.4372 33.9767 28.0009 32.5508 27.999C22.8625 27.9896 13.1751 27.9943 3.48681 27.9943C3.35812 27.9943 3.22943 27.9934 3.10074 27.9887C1.75374 27.9386 0.590841 27.067 0.166262 25.7856C0.103327 25.5976 0.0544814 25.405 0 25.2152ZM9.16509 22.2557C8.06419 22.2557 7.01589 22.2557 5.95632 22.2557C5.95632 20.9289 5.95632 19.6277 5.95632 18.2905C6.51992 18.2905 7.05628 18.2981 7.59264 18.2877C8.0191 18.2792 8.32908 18.062 8.50568 17.6767C8.67663 17.3056 8.63624 16.9382 8.39577 16.6058C8.16188 16.2829 7.82654 16.1686 7.44423 16.1677C6.95389 16.1667 6.46356 16.1677 5.95726 16.1677C5.95726 15.1506 5.95726 14.1695 5.95726 13.1619C6.48798 13.1619 6.99053 13.1695 7.49307 13.16C8.15061 13.1468 8.60806 12.6973 8.60337 12.0854C8.59867 11.4735 8.14027 11.0438 7.47429 11.0391C6.70121 11.0334 5.92814 11.0372 5.15507 11.0381C4.18568 11.0381 3.82027 11.4064 3.81933 12.3847C3.81933 15.9363 3.81933 19.4888 3.81933 23.0404C3.81933 24.0329 4.18943 24.405 5.17949 24.4059C8.54231 24.4069 11.9042 24.4069 15.267 24.405C15.4192 24.405 15.5723 24.4031 15.7226 24.3804C16.2186 24.3049 16.5915 23.93 16.6027 23.4257C16.6243 22.4701 16.6243 21.5144 16.6027 20.5588C16.5905 20.0422 16.1979 19.6598 15.6906 19.5946C15.2163 19.5332 14.7325 19.8203 14.5841 20.2802C14.5268 20.4558 14.5146 20.6504 14.5108 20.8373C14.5014 21.3057 14.508 21.775 14.508 22.2585C13.4146 22.2585 12.3673 22.2585 11.2739 22.2585C11.2739 22.1112 11.2739 21.9856 11.2739 21.8591C11.272 21.4341 11.2842 21.0092 11.2645 20.5852C11.242 20.0875 10.9104 19.7108 10.4435 19.6107C9.77753 19.469 9.19515 19.9421 9.16978 20.6683C9.151 21.1848 9.16509 21.7033 9.16509 22.2557ZM25.1939 17.8438C23.4495 17.8438 21.7043 17.8429 19.9599 17.8438C19.1474 17.8448 18.7388 18.2414 18.736 19.0488C18.7303 20.4284 18.7313 21.8081 18.736 23.1887C18.7388 23.9744 19.1493 24.4012 19.9233 24.4021C23.4355 24.4069 26.9486 24.4078 30.4607 24.4021C31.2432 24.4012 31.6434 23.9791 31.6443 23.1906C31.6462 21.8109 31.6462 20.4313 31.6443 19.0507C31.6434 18.2461 31.2376 17.8448 30.4269 17.8438C28.6835 17.8429 26.9382 17.8438 25.1939 17.8438ZM25.1911 13.1619C26.9241 13.1619 28.6582 13.1638 30.3912 13.1591C30.565 13.1591 30.7454 13.1449 30.9107 13.0967C31.3653 12.9645 31.6603 12.5292 31.6434 12.0514C31.6274 11.5802 31.2902 11.159 30.8318 11.0646C30.673 11.0315 30.5058 11.0381 30.3424 11.0381C26.911 11.0372 23.4796 11.0372 20.0482 11.0372C19.9308 11.0372 19.8134 11.0344 19.6969 11.0438C19.1981 11.0853 18.8064 11.4735 18.7491 11.9777C18.6937 12.4612 18.9793 12.9381 19.4395 13.0854C19.6142 13.1411 19.8077 13.1572 19.9919 13.1581C21.7249 13.1638 23.458 13.1619 25.1911 13.1619ZM22.4802 16.4415C23.3462 16.4415 24.2113 16.4434 25.0774 16.4406C25.7735 16.4387 26.2328 16.0213 26.2394 15.3962C26.245 14.7691 25.7829 14.3206 25.1018 14.3187C23.3584 14.313 21.615 14.313 19.8716 14.3187C19.2141 14.3215 18.7472 14.7672 18.7397 15.3716C18.7322 15.9901 19.2056 16.4368 19.8829 16.4396C20.748 16.4444 21.6141 16.4415 22.4802 16.4415Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M-3.72278e-05 2.76407C0.0572622 2.57521 0.109865 2.38445 0.1728 2.19748C0.622742 0.869768 1.82509 0.00760486 3.25945 0.00382758C5.96568 -0.00278265 8.6719 0.00193895 11.3781 0.00193895C18.4307 0.00193895 25.4832 0.00193895 32.5357 0.00193895C34.6614 0.00193895 35.999 1.35137 36 3.49309C36 4.43552 36 5.37794 36 6.36759C35.8271 6.36759 35.6797 6.36759 35.5312 6.36759C23.8393 6.36759 12.1474 6.36759 0.45554 6.36759C0.303368 6.36759 0.151196 6.37326 -0.000976562 6.37609C-3.72278e-05 5.17208 -3.72278e-05 3.96808 -3.72278e-05 2.76407ZM4.02783 2.24847C4.02783 2.24942 4.02783 2.25036 4.02783 2.25036C3.7357 2.25036 3.44262 2.23431 3.15143 2.25414C2.62259 2.29002 2.21397 2.71969 2.18392 3.24378C2.1548 3.76222 2.5155 4.27876 3.04153 4.32314C3.69061 4.37791 4.35096 4.3798 4.9991 4.32503C5.54861 4.27876 5.89523 3.76883 5.85578 3.2164C5.81726 2.68664 5.41147 2.28058 4.87041 2.25036C4.58955 2.23525 4.30775 2.24847 4.02783 2.24847ZM8.74799 2.24942C8.45585 2.24942 8.16278 2.23525 7.87159 2.25225C7.33993 2.28436 6.92568 2.70552 6.89186 3.22773C6.85711 3.75372 7.2056 4.27404 7.73069 4.31936C8.3901 4.37697 9.06266 4.37697 9.72208 4.32031C10.2528 4.27498 10.5891 3.7726 10.56 3.23245C10.5318 2.70458 10.126 2.2853 9.58869 2.25225C9.31065 2.23525 9.02885 2.24942 8.74799 2.24942ZM13.4108 4.36469C13.4108 4.36375 13.4108 4.36375 13.4108 4.3628C13.6917 4.3628 13.9735 4.38074 14.2525 4.35903C14.8687 4.31086 15.2801 3.85854 15.267 3.27023C15.2538 2.68569 14.8133 2.25886 14.1924 2.24658C13.6898 2.2362 13.1863 2.23714 12.6838 2.24658C12.0638 2.25792 11.6158 2.68192 11.597 3.25984C11.5773 3.85759 12.0056 4.31842 12.6387 4.36091C12.8961 4.37886 13.1544 4.36469 13.4108 4.36469Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M20.8638 22.251C20.8638 21.4794 20.8638 20.741 20.8638 19.9855C23.7494 19.9855 26.6144 19.9855 29.5075 19.9855C29.5075 20.7297 29.5075 21.4766 29.5075 22.251C26.6416 22.251 23.7691 22.251 20.8638 22.251Z"
                                                fill="#FFD700" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1276_369">
                                                <rect width="36" height="28" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-white">Web Design</h3>
                                    <p class="mb-0 fs-14 text-gray-100">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="service-card h-100">
                                <div class="card-img d-flex justify-content-center align-items-center">
                                    <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_1276_379)">
                                            <path
                                                d="M27.9973 19.9999C26.2958 19.9999 24.6409 19.9915 22.986 20.0024C21.5943 20.0116 20.4225 20.9347 20.0951 22.2735C20.0268 22.5531 20.0044 22.8494 20.0027 23.1382C19.9935 24.7207 19.9977 26.304 19.9969 27.8865C19.9969 27.9065 19.991 27.9274 19.9802 27.9967C19.8894 27.9967 19.7911 27.9967 19.692 27.9967C18.1721 27.9967 16.6513 27.9984 15.1313 27.9958C13.2948 27.9933 12.0022 26.7063 12.0014 24.8734C11.9989 20.292 11.9989 15.7098 12.0014 11.1284C12.0022 9.293 13.2932 8.00263 15.1263 8.00096C18.3753 7.99846 21.6243 7.99846 24.8733 8.00096C26.7089 8.00263 27.9957 9.28966 27.9973 11.1276C28.0007 13.9804 27.9982 16.8341 27.9982 19.6869C27.9973 19.7804 27.9973 19.8722 27.9973 19.9999ZM20.0285 12.0014C19.0599 12.0014 18.0921 12.0006 17.1235 12.0014C16.4564 12.0023 16.005 12.4029 16.0016 12.9938C15.9983 13.5839 16.453 13.9996 17.1118 14.0004C19.0382 14.0021 20.9638 14.0021 22.8902 14.0004C23.5473 13.9996 24.0029 13.5814 23.9979 12.9913C23.9929 12.4146 23.5407 12.0031 22.9027 12.0014C21.9441 11.9998 20.9863 12.0014 20.0285 12.0014ZM18.9941 18.0001C19.6504 18.0001 20.3059 18.0051 20.9621 17.9984C21.551 17.9926 21.9916 17.5677 21.9982 17.0127C22.0049 16.4451 21.5593 16.0044 20.9563 16.0019C19.6546 15.9969 18.3536 15.9977 17.0519 16.0019C16.4422 16.0036 16 16.4318 16.0008 17.0027C16.0016 17.5702 16.448 17.9951 17.0577 17.9992C17.7032 18.0034 18.3486 18.0001 18.9941 18.0001Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M0.00355189 21.9763C0.00355189 20.686 0.0010533 19.3948 0.00438475 18.1044C0.00688334 16.8524 0.851406 16.0028 2.09737 16.0011C4.03294 15.9986 5.96935 15.9986 7.90492 16.0011C9.15171 16.0028 9.99873 16.8516 10.0004 18.1027C10.0029 20.7052 10.0037 23.3068 10.0004 25.9092C9.99873 27.1412 9.14838 27.995 7.92241 27.9975C5.97601 28.0017 4.02961 28.0017 2.08321 27.9975C0.856403 27.995 0.00688334 27.1412 0.00355189 25.9117C0.0010533 24.5997 0.00355189 23.2884 0.00355189 21.9763ZM4.00296 21.9839C4.00296 22.3277 3.99463 22.6708 4.00462 23.0147C4.02128 23.573 4.46686 24.0029 5.00989 23.9979C5.54125 23.9937 5.98517 23.573 5.99683 23.0288C6.01099 22.3419 6.01182 21.655 5.99683 20.9681C5.98517 20.4247 5.53959 20.0041 5.00822 20.0007C4.46186 19.9974 4.02128 20.4231 4.00462 20.9848C3.99546 21.3178 4.00296 21.6508 4.00296 21.9839Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M21.1096 0.0033489C22.6921 0.0033489 24.2737 0.00251425 25.8561 0.0033489C27.1662 0.00418355 27.9958 0.837164 27.9983 2.15341C27.9991 2.76771 28.0041 3.38201 27.9966 3.99548C27.9824 5.12726 27.1237 5.99697 25.9936 5.99947C22.7354 6.00698 19.4781 6.00782 16.2199 5.99279C15.9184 5.99112 15.6011 5.90098 15.3187 5.78413C14.6175 5.49534 13.9312 5.1715 13.2424 4.8535C12.4504 4.48792 12.0065 3.86861 12.0098 2.99223C12.0131 2.13004 12.4512 1.51657 13.2316 1.15683C13.9204 0.838833 14.605 0.509981 15.3088 0.22787C15.6286 0.0993336 15.9892 0.0175379 16.3332 0.01253C17.9248 -0.00917084 19.5172 0.0033489 21.1096 0.0033489Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M8.8626 13.8509C8.54694 13.9069 8.28792 13.992 8.02724 13.9937C6.00671 14.0045 3.98619 14.0095 1.9665 13.9962C0.887939 13.9887 0.0117671 13.1206 0.00843562 12.0439C-0.00239159 8.68028 -0.00322445 5.31665 0.00843562 1.95301C0.0125999 0.892169 0.882941 0.0174567 1.94234 0.00911017C3.98369 -0.00674817 6.02503 -7.09744e-05 8.06555 0.0116141C8.31457 0.0132834 8.56277 0.101756 8.86926 0.161851C8.43617 0.640105 8.05972 1.0566 7.6816 1.47142C6.64552 2.61238 5.60611 3.75084 4.57169 4.89264C3.40985 6.17466 3.41318 7.84063 4.57585 9.1168C5.92176 10.5958 7.266 12.0756 8.61107 13.5555C8.67854 13.6306 8.74267 13.7099 8.8626 13.8509Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M9.97258 12.079C8.73661 10.7211 7.55895 9.38645 6.33547 8.09525C5.49678 7.20969 5.52843 6.76398 6.33547 5.91014C7.55728 4.61726 8.73578 3.28433 9.97258 1.92468C9.97258 5.32421 9.97258 8.67116 9.97258 12.079Z"
                                                fill="#FFD700" />
                                            <path
                                                d="M27.3079 21.9997C25.5306 23.7725 23.7724 25.5244 22.0184 27.2738C22.0151 27.243 22.0001 27.1678 22.0001 27.0927C21.9984 25.7606 21.9976 24.4277 22.0001 23.0956C22.0018 22.4095 22.4032 22.0022 23.082 22.0005C24.4862 21.9972 25.8912 21.9997 27.3079 21.9997Z"
                                                fill="#FFD700" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1276_379">
                                                <rect width="28" height="28" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-white">Branding Design</h3>
                                    <p class="mb-0 fs-14 text-gray-100">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gallery-section pt-60 position-relative">
                <div class="box-img">
                    <img src="<?php echo e(asset('assets/img/vcard26/box.png')); ?>" alt="box-img" loading="lazy"/>
                </div>
                <div class="section-heading text-center px-30">
                    <h2 class="mb-0">Gallery</h2>
                </div>
                <div class="gallery-slider ps-sm-4">
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="<?php echo e(asset('assets/img/vcard26/gallery-img1.png')); ?>" loading="lazy"/>
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="<?php echo e(asset('assets/img/vcard26/gallery-img2.png')); ?>" loading="lazy"/>
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="<?php echo e(asset('assets/img/vcard26/gallery-img3.png')); ?>" loading="lazy"/>
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="<?php echo e(asset('assets/img/vcard26/gallery-img1.png')); ?>" loading="lazy"/>
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="<?php echo e(asset('assets/img/vcard26/gallery-img2.png')); ?>" loading="lazy"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial-section pt-60">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Testimonials</h2>
                </div>
                <div class="testimonial-slider">
                    <div class="">
                        <div class="testimonial-card card flex-sm-row">
                            <div class="testimonial-profile-img">
                                <img src="<?php echo e(asset('assets/img/vcard26/testimonial-profile-img.png')); ?>"
                                    class="w-100 h-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="card-body p-0 text-sm-start text-center">
                                <div class="">
                                    <h3 class="text-white fs-20 fw-6 mb-1">Jenny Wilson</h3>
                                    <p class="fs-16 text-white">Marketing Manager</p>
                                    <p class="desc text-gray-100 fs-14 mb-0">
                                        Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse cillum dolore eu fugiat nulla pariatu
                                    </p>
                                </div>
                            </div>
                            <div class="quote-img left">
                                <img src="<?php echo e(asset('assets/img/vcard26/quote-img-left.png')); ?>" alt="quote-img"
                                    class="mx-auto" loading="lazy"/>
                            </div>
                            <div class="quote-img right">
                                <img src="<?php echo e(asset('assets/img/vcard26/quote-img-right.png')); ?>" alt="quote-img"
                                    class="mx-auto" loading="lazy"/>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="testimonial-card card flex-sm-row">
                            <div class="testimonial-profile-img">
                                <img src="<?php echo e(asset('assets/img/vcard26/testimonial-profile-img.png')); ?>"
                                    class="w-100 h-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="card-body p-0 text-sm-start text-center">
                                <div class="">
                                    <h3 class="text-white fs-20 fw-6 mb-1">Jenny Wilson</h3>
                                    <p class="fs-16 text-white">Marketing Manager</p>
                                    <p class="desc text-gray-100 fs-14 mb-0">
                                        Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse cillum dolore eu fugiat nulla pariatu
                                    </p>
                                </div>
                            </div>
                            <div class="quote-img left">
                                <img src="<?php echo e(asset('assets/img/vcard26/quote-img-left.png')); ?>" alt="quote-img"
                                    class="mx-auto" loading="lazy"/>
                            </div>
                            <div class="quote-img right">
                                <img src="<?php echo e(asset('assets/img/vcard26/quote-img-right.png')); ?>" alt="quote-img"
                                    class="mx-auto" loading="lazy"/>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-section pt-60 px-30">
                <div class="cards-img">
                    <img src="<?php echo e(asset('assets/img/vcard26/cards.png')); ?>" alt="cards-img" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Products</h2>
                </div>
                <div class="">
                    <div class="product-slider">
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="<?php echo e(asset('assets/img/vcard26/product-img1.png')); ?>"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-white fs-18 fw-5 mb-0">Loreum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$250</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-14">
                                        Loreum Ipsm is dummy text loreum Ipsm is dummy text
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="<?php echo e(asset('assets/img/vcard26/product-img2.png')); ?>"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-white fs-18 fw-5 mb-0">Loreum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$250</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-14">
                                        Loreum Ipsm is dummy text loreum Ipsm is dummy text
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="<?php echo e(asset('assets/img/vcard26/product-img1.png')); ?>"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-white fs-18 fw-5 mb-0">Loreum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$250</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-14">
                                        Loreum Ipsm is dummy text loreum Ipsm is dummy text
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="<?php echo e(asset('assets/img/vcard26/product-img2.png')); ?>"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-white fs-18 fw-5 mb-0">Loreum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$250</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-14">
                                        Loreum Ipsm is dummy text loreum Ipsm is dummy text
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="appointment-section pt-60 px-30">
                <div class="section-heading text-center">
                    <h2 class="mb-0">Make an Appointment</h2>
                </div>
                <div class="appointment">
                    <form action="">
                        <div class="row justify-content-center">
                            <div class="col-sm-10 px-sm-0">
                                <div class="position-relative mb-20">
                                    <input type="text" class="form-control appointment-input"
                                        placeholder="Pick a Date" />

                                    <span class="calendar-icon"><svg width="20" height="20"
                                            viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M6.25 9.375V10.625C6.25 10.9705 5.97047 11.25 5.625 11.25H4.375C4.02953 11.25 3.75 10.9705 3.75 10.625V9.375C3.75 9.02953 4.02953 8.75 4.375 8.75H5.625C5.97047 8.75 6.25 9.02953 6.25 9.375ZM5.625 13.75H4.375C4.02953 13.75 3.75 14.0295 3.75 14.375V15.625C3.75 15.9705 4.02953 16.25 4.375 16.25H5.625C5.97047 16.25 6.25 15.9705 6.25 15.625V14.375C6.25 14.0295 5.97047 13.75 5.625 13.75ZM10.625 8.75H9.375C9.02953 8.75 8.75 9.02953 8.75 9.375V10.625C8.75 10.9705 9.02953 11.25 9.375 11.25H10.625C10.9705 11.25 11.25 10.9705 11.25 10.625V9.375C11.25 9.02953 10.9705 8.75 10.625 8.75ZM10.625 13.75H9.375C9.02953 13.75 8.75 14.0295 8.75 14.375V15.625C8.75 15.9705 9.02953 16.25 9.375 16.25H10.625C10.9705 16.25 11.25 15.9705 11.25 15.625V14.375C11.25 14.0295 10.9705 13.75 10.625 13.75ZM15.625 8.75H14.375C14.0295 8.75 13.75 9.02953 13.75 9.375V10.625C13.75 10.9705 14.0295 11.25 14.375 11.25H15.625C15.9705 11.25 16.25 10.9705 16.25 10.625V9.375C16.25 9.02953 15.9705 8.75 15.625 8.75ZM15.625 13.75H14.375C14.0295 13.75 13.75 14.0295 13.75 14.375V15.625C13.75 15.9705 14.0295 16.25 14.375 16.25H15.625C15.9705 16.25 16.25 15.9705 16.25 15.625V14.375C16.25 14.0295 15.9705 13.75 15.625 13.75ZM4.375 3.75H5.625C5.97047 3.75 6.25 3.47047 6.25 3.125V0.625C6.25 0.279531 5.97047 0 5.625 0H4.375C4.02953 0 3.75 0.279531 3.75 0.625V3.125C3.75 3.47047 4.02953 3.75 4.375 3.75ZM20 5V17.5C20 18.8806 18.8806 20 17.5 20H2.5C1.11937 20 0 18.8806 0 17.5V5C0 3.61937 1.11937 2.5 2.5 2.5H3.125V3.125C3.125 3.81348 3.6859 4.375 4.375 4.375H5.625C6.3141 4.375 6.875 3.81348 6.875 3.125V2.5H13.125V3.125C13.125 3.81348 13.6865 4.375 14.375 4.375H15.625C16.3135 4.375 16.875 3.81348 16.875 3.125V2.5H17.5C18.8806 2.5 20 3.61937 20 5ZM18.75 7.5C18.75 6.81152 18.1897 6.25 17.5 6.25H2.5C1.8109 6.25 1.25 6.81152 1.25 7.5V17.5C1.25 18.1897 1.8109 18.75 2.5 18.75H17.5C18.1897 18.75 18.75 18.1897 18.75 17.5V7.5ZM14.375 3.75H15.625C15.9705 3.75 16.25 3.47047 16.25 3.125V0.625C16.25 0.279531 15.9705 0 15.625 0H14.375C14.0295 0 13.75 0.279531 13.75 0.625V3.125C13.75 3.47047 14.0295 3.75 14.375 3.75Z"
                                                fill="#FFD700" />
                                        </svg>
                                    </span>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6 pe-sm-2 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-gray-100">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 ps-sm-2 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-gray-100">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 pe-sm-2 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-gray-100">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 ps-sm-2 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-gray-100">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2 text-center">
                                    <button class="btn btn-primary w-100">
                                        Book Appointment
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="blog-section pt-60">
                <div class="shoes-img text-end">
                    <img src="<?php echo e(asset('assets/img/vcard26/shoes.png')); ?>" alt="shoes-img" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Blog</h2>
                </div>
                <div class="blog-slider px-30 pt-40 pb-40 bg-secondary">
                    <div class="">
                        <div class="blog-card card-1">
                            <div class="blog-desc">
                                <h3 class="text-primary fs-18 fw-5 mb-1">Lorem Ipsum</h3>
                                <p class="mb-0 text-white fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="blog-card card-2">
                            <div class="blog-desc">
                                <h3 class="text-primary fs-18 fw-5 mb-1">Lorem Ipsum</h3>
                                <p class="mb-0 text-white fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="blog-card card-1">
                            <div class="blog-desc">
                                <h3 class="text-primary fs-18 fw-5 mb-1">Lorem Ipsum</h3>
                                <p class="mb-0 text-white fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="blog-card card-2">
                            <div class="blog-desc">
                                <h3 class="text-primary fs-18 fw-5 mb-1">Lorem Ipsum</h3>
                                <p class="mb-0 text-white fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="business-hour-section pt-60 px-40">
                <div class="home-img">
                    <img src="<?php echo e(asset('assets/img/vcard26/home.png')); ?>" alt="home-img" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Business Hours</h2>
                </div>
                <div class="business-hours">
                    <div class="mb-10 d-flex justify-content-between">
                        <span>Sunday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Monday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Tuesday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Wednesday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Thursday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Friday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Saturday:</span>
                        <span>Closed</span>
                    </div>
                </div>
            </div>
            <div class="qr-code-section pt-60 px-40">
                <div class="percentage-img2">
                    <img src="<?php echo e(asset('assets/img/vcard26/percrentage-2.png')); ?>" alt="percentage-img2" loading="lazy"/>
                </div>
                <div class="bag-img text-end">
                    <img src="<?php echo e(asset('assets/img/vcard26/bag.png')); ?>" alt="bag-img" loading="lazy"/>
                </div>
                <div class="section-heading mb-40 pb-40 text-center">
                    <h2 class="mb-0">QR Code</h2>
                </div>
                <div class="qr-code mx-auto position-relative">
                    <div class="qr-profile-img">
                        <img src="<?php echo e(asset('assets/img/vcard26/qr-profile-img.png')); ?>" class="w-100 h-100 object-fit-cover" loading="lazy"/>
                    </div>
                    <div class="qr-code-img mx-auto">
                        <img src="<?php echo e(asset('assets/img/vcard26/qr-code.png')); ?>"
                            class="w-100 h-100 object-fit-cover" loading="lazy"/>
                    </div>
                </div>
            </div>
            <div class="contact-us-section pt-60 px-30 position-relative">
                <div class="add-to-bag-img text-end mt-5">
                    <img src="<?php echo e(asset('assets/img/vcard26/add-to-bag.png')); ?>" alt="add-to-bag-img" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Inquiries</h2>
                </div>
                <div class="contact-form">
                    <form action="">
                        <div class="mb-10">
                            <input type="text" class="form-control" placeholder="Full Name" />
                        </div>
                        <div class="mb-10">
                            <input type="email" class="form-control" placeholder="Email Address" />
                        </div>
                        <div class="mb-10">
                            <input type="tel" class="form-control" placeholder="Phone Number" />
                        </div>
                        <div class="mb-10">
                            <textarea class="form-control h-100" placeholder="Your Message" rows="4"></textarea>
                        </div>
                        <div class="text-center pt-3">
                            <button class="send-btn rounded-2 btn btn-secondary" type="submit">
                                Send Message
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="create-vcard-section">
                <div class="delivery-van-img">
                    <img src="<?php echo e(asset('assets/img/vcard26/delivery-van.png')); ?>" alt="delivery-van-img" loading="lazy"/>
                </div>
                <div class="pt-60 pb-60 px-30">
                    <div class="section-heading text-center mb-40">
                        <h2 class="mb-0">Create Your VCard</h2>
                    </div>
                    <div class="px-sm-3 pb-60 mb-5">
                        <div class="vcard-link-card card">
                            <div class="d-flex align-items-center justify-content-center">
                                <a href="https://vcards.infyom.com/marlonbrasil"
                                    class="text-white link-text fw-normal">https://vcards.infyom.com/marlonbrasil</a>
                                <i class="icon fa-solid fa-arrow-up-right-from-square ms-3 text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="add-to-contact-section pb-60">
                <div class="text-center">
                    <button class="add-contact-btn rounded-2 btn-secondary"><i
                        class="fas fa-download fa-address-book"></i>
                    &nbsp;Add to Contact</button>
                </div>
            </div>
        </div>
    </div>
</body>
<?php echo $__env->make('vcardTemplates.template.templates', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript" src="<?php echo e(asset('assets/js/front-third-party.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('front/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/slider/js/slick.min.js')); ?>" type="text/javascript"></script>
<script>
    $().ready(function() {
        $(".gallery-slider").slick({
            arrows: false,
            infinite: true,
            dots: true,
            slidesToShow: 3,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                },
            }, ],
        });
        $(".product-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                    dots: true,
                },
            }, ],
        });
        $(".blog-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                    dots: true,
                },
            }, ],
        });
        $(".testimonial-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    dots: true,
                },
            }, ],
        });
    });
</script>
<script>
    $("#myID").flatpickr();
</script>

<script>
    $(document).ready(function() {
        $('.dropdown1').hover(function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(100);
        }, function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(100);
        });
    });
</script>

</html>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/vcards/vcard26.blade.php ENDPATH**/ ?>