<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(getFaviconUrl()); ?>" type="image/png">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <!-- General CSS Files -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(mix('assets/css/page.css')); ?>"> <!-- CSS Libraries -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/plugins.css')); ?>">
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldContent('css'); ?>
    <?php echo ReCaptcha::htmlScriptTagJsApi(); ?>

</head>

<body>
    <div
        class="d-flex flex-column flex-column-fluid bgi-position-y-bottom position-x-center bgi-no-repeat bgi-size-contain bgi-attachment-fixed authImage  <?php if(getLanguageByKey(checkFrontLanguageSession()) == 'Arabic'): ?> rtl <?php endif; ?>">
        <div class="dropdown ms-auto z-index-9">
            <button type="button" title="Active" class="dropdown-toggle hide-arrow btn btn btn-info m-7 mb-5 pl-2"
                id="dropdownMenuButton1" data-bs-toggle="dropdown" data-bs-boundary="viewport" aria-expanded="false"
                <?php if(getLanguageByKey(checkFrontLanguageSession()) == 'Arabic'): ?> dir="rtl" <?php endif; ?>>
                <?php echo e(getLanguageByKey(checkFrontLanguageSession())); ?> <i class="fa  fa-language"></i>
            </button>
            <ul class="dropdown-menu min-width-220" aria-labelledby="dropdownMenuButton1"
                style="max-height: 380px;overflow: auto;">
                <?php $__currentLoopData = getAllLanguageWithFullData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li style="padding: 0px"
                        class="dropdown-item languageSelection padding <?php echo e(checkFrontLanguageSession() == $value->iso_code ? 'active' : ''); ?>"
                        data-prefix-value="<?php echo e($value->iso_code); ?>"><a
                            class=" dropdown-item <?php echo e(checkFrontLanguageSession() == $value->iso_code ? 'active' : ''); ?>"
                            class="text-decoration-none" data-id="<?php echo e($value->iso_code); ?>" href="javascript:void(0)">

                            <?php if(array_key_exists($value->iso_code, \App\Models\User::FLAG)): ?>
                                <?php $__currentLoopData = \App\Models\User::FLAG; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageKey => $imageValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($imageKey == $value->iso_code): ?>
                                        <img src="<?php echo e(asset($imageValue)); ?>" width="20" height="18"
                                            class="me-1" />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php if(count($value->media) != 0): ?>
                                    <img src="<?php echo e($value->image_url); ?>" class="me-1" />
                                <?php else: ?>
                                    <i class="fa fa-flag fa-xl me-3 text-danger" aria-hidden="true"></i>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php echo e($value->name); ?>

                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <ul>
        </ul>
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <footer>
        <div class="container-fluid padding-0 d-none">
            <div class="row align-items-center justify-content-center">
                <div class="col-xl-6">
                    <div class="copyright text-center text-muted">
                        <?php echo e(__('messages.placeholder.all_rights_reserve')); ?> &copy; <?php echo e(date('Y')); ?> <a
                            href="<?php echo e(route('home')); ?>" class="font-weight-bold ml-1"
                            target="_blank"><?php echo e(getAppName()); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- Scripts -->
    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
    <script src="<?php echo e(mix('assets/js/front-third-party.js')); ?>"></script>
    <script src="<?php echo e(asset('messages.js?$mixID')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/custom/helpers.js')); ?>"></script>
    
    <script src="<?php echo e(mix('assets/js/auth/auth.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <script>
        let defaultCountryCodeValue = 'in';
        let mobileValidation = "<?php echo e(getSuperAdminSettingValue('mobile_validation')); ?>";
        let utilsScript = "<?php echo e(asset('assets/js/inttel/js/utils.min.js')); ?>"
        $(document).ready(function() {
            $('.alert').delay(5000).slideUp(300)
        })
    </script>
    <script src="<?php echo e(mix('assets/js/intl-tel-input/build/intlTelInput.js')); ?>"></script>
    
</body>

</html>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetas/resources/views/layouts/auth.blade.php ENDPATH**/ ?>