<div class="modal fade" id="addServiceModal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><?php echo e(__('messages.vcard.new_service')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            <?php echo e(Form::open(['id'=>'addServiceForm', 'files' => 'true'])); ?>

            <div class="modal-body">
                <div class="mb-5">
                    <?php echo e(Form::hidden('vcard_id', $vcard->id)); ?>

                    <?php echo e(Form::label('name',__('messages.common.name').(':'), ['class' => 'form-label required'])); ?>

                    <?php echo e(Form::text('name', null, ['class' => 'form-control','required', 'placeholder' => __('messages.form.service')])); ?>

                </div>
                <div class="mb-5">
                    <?php echo e(Form::label('service_url', __('messages.common.service_url').':', ['class' => 'form-label'])); ?>

                    <?php echo e(Form::text('service_url', null, ['class' => 'form-control', 'placeholder' => __('messages.common.service_url')])); ?>

                </div>
                <div class="mb-5">
                    <?php echo e(Form::label('description', __('messages.common.description').':', ['class' => 'form-label required'])); ?>

                    <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'placeholder' => __('messages.form.short_description'), 'rows' => '5' , 'required'])); ?>

                </div>
                <div class="mb-3" io-image-input="true">
                    <label for="exampleInputImage"
                           class="form-label required"><?php echo e(__('messages.vcard.service_icon').':'); ?></label>
                    <div class="d-block">
                        <div class="image-picker">
                            <div class="image previewImage" id="servicePreview"
                                 style="background-image: url(<?php echo e(asset('assets/images/default_service.png')); ?>)"></div>
                            <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                  data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                        <label>
                                        <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                            <input type="file" id="serviceIcon" name="service_icon"
                                                   class="image-upload file-validation d-none" accept="image/*"/>
                                        </label>
                                    </span>
                        </div>
                        <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer pt-0">
                <?php echo e(Form::button(__('messages.common.save'), ['type'=>'submit','class' => 'btn btn-primary m-0','id'=>'serviceSave'])); ?>

                <button type="button" class="btn btn-secondary my-0 ms-5 me-0"
                        data-bs-dismiss="modal"><?php echo e(__('messages.common.discard')); ?></button>
            </div>
            <?php echo Form::close(); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/vcards/services/create.blade.php ENDPATH**/ ?>