<?php $__env->startSection('title'); ?>
    <?php echo e(getAppName()); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- start hero section -->
    <section class="hero-section position-relative pb-60" <?php if(checkFrontLanguageSession() == 'ar'): ?> dir="rtl" <?php endif; ?>>
        <div class="container"> <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> </div>
        <div class="hero-bg-img text-end">
            <img src="<?php echo e(asset('assets/img/new_home_page/hero-bg.png')); ?>" class="w-100 h-100" alt="hero-img" />
        </div>
        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-6 text-lg-start text-center mb-lg-0 mb-md-5 mb-4">
                    <div class="hero-content">
                        <h1 class="text-black mb-2"><?php echo e($setting['home_page_title']); ?></h1>
                        <p class="text-gray-100 fs-18 mb-40 ">
                            <?php echo e($setting['sub_text'] ?? ''); ?>

                        </p>
                        <div class="position-relative vcard-alias-search">
                            <input id="search-alias-input" type="text" class="form-control" placeholder="<?php echo e(__('messages.vcard.search_vcard_alias')); ?>" required>
                            <button id="search-alias-btn" type="submit" class="btn btn-sm-success btn-primary top-50 end-0 me-2">
                                <?php echo e(__('messages.vcard.available')); ?>

                            </button>
                        </div>
                            <div id="search-alias-error" class="text-danger mt-1 ms-1 d-none"><?php echo e(__('messages.vcard.already_alias_url')); ?></div>
                            <div id="search-alias-success" class="text-success mt-1 ms-1 d-none"><?php echo e(__('messages.vcard.url_alias_available')); ?></div>
                        
                    </div>
                </div>
                <div class="col-lg-6 text-center mt-lg-0 mt-4">
                    <div class="hero-img mx-auto">
                        <img src="<?php echo e(isset($setting['home_page_banner']) ? $setting['home_page_banner'] : asset('assets/img/new_front/hero-img.png')); ?>"
                            alt="Vcard" class="zoom-in-zoom-out w-100 h-auto" />
                    </div>

                </div>
            </div>
        </div>
        <div class="main-banner banner-img-1">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-1.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-2">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-2.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-3">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-3.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-4">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-4.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-5">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-5.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-6">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-6.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-7">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-7.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
        <div class="main-banner banner-img-8">
            <img src="<?php echo e(asset('assets/img/new_home_page/shape-8.png')); ?>" class="w-100 h-auto" alt="image">
        </div>
    </section>
    <!-- end hero section -->
    <div class="vcard-template-section pt-60 pb-100 position-relative">
        <div class="vcard-bg position-absolute">
            <img src="<?php echo e(asset('assets/img/new_home_page/vcard-template-bg.png')); ?>" alt="vcard-bg" class="w-100 h-auto">
        </div>
        <div class="plus-vector1 position-absolute">
            <img src="<?php echo e(asset('assets/img/new_home_page/plus-vector.png')); ?>" alt="vector" class="w-100 h-auto">
        </div>
        <div class="plus-vector2 position-absolute">
            <img src="<?php echo e(asset('assets/img/new_home_page/plus-vector.png')); ?>" alt="vector" class="w-100 h-auto">
        </div>
        <div class="plus-vector3 position-absolute">
            <img src="<?php echo e(asset('assets/img/new_home_page/plus-vector2.png')); ?>" alt="vector" class="w-100 h-auto">
        </div>
        
        <section class="vcard-section pb-100" id="">
            <div class="container w-100">
                <div class="section-heading text-center mb-60">
                    <h2 class="d-inline-block"> <?php echo e(__('messages.vcards_templates')); ?></h2>
                </div>
                <div class="center-slider">
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard33.png')); ?>" class="w-100 vcard-img"
                                alt="vcard-img">
                        </div>
                    </div>
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard32.png')); ?>" class="img-fluid vcard-img"
                                alt="vcard-img">
                        </div>
                    </div>
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard31.png')); ?>" class="w-100 vcard-img "
                                alt="vcard-img">
                        </div>
                    </div>
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard30.png')); ?>" class="w-100 vcard-img"
                                alt="vcard-img">
                        </div>
                    </div>
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard29.png')); ?>" class="w-100 vcard-img"
                                alt="vcard-img">
                        </div>
                    </div>
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard28.png')); ?>" class="w-100 vcard-img"
                                alt="vcard-img">
                        </div>
                    </div>
                    <div>
                        <div class="vcard-card">
                            <img src="<?php echo e(asset('assets/img/templates/home/vcard27.png')); ?>" class="w-100 vcard-img"
                                alt="vcard-img">
                        </div>
                    </div>

                </div>
                <div class="col-12 text-center mt-5">
                    <a href="<?php echo e(route('vcard-templates')); ?>" class="btn btn-primary-light" role="button"
                        data-turbo="false"><?php echo e(__('messages.common.view_more')); ?></a>
                </div>
            </div>
        </section>
    </div>
    <!-- start features section -->
    <section class="features-section overflow-hidden <?php if(checkFrontLanguageSession() == 'ar'): ?> rtl <?php endif; ?>" id="frontFeaturesTab">
        <div class="container">
            <div class="section-heading text-start mb-60">
                <h2 class="d-inline-block"><?php echo e(__('messages.plan.features')); ?></h2>
            </div>
            <div class="feature-slider">
                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="">
                        <div class="feature-card">
                            <div class="card-img overflow-hidden">
                                <img src="<?php echo e($feature->profile_image); ?>" class="w-100 h-100 object-fit-cover"
                                    alt="feature-img">
                            </div>
                            <div class="card-body p-0">
                                <h3 class="fs-18 mb-3"><?php echo e($feature->name); ?></h3>
                                <p class="text-gray-100 mb-0"><?php echo $feature->description; ?>

                                </p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- end features section -->

    <!-- start modern & powerful-interface section -->
    <section class="modern-interface-section overflow-hidden pb-100" id="frontAboutTabUsTab"
        <?php if(checkFrontLanguageSession() == 'ar'): ?> dir="rtl" <?php endif; ?>>
        <div class="container">
            <div class="section-heading text-center mb-60">
                <h2 class="d-inline-block"><?php echo e(__('auth.modern_&_powerful_interface')); ?></h2>
            </div>
            <div class="interface-card mb-40">
                <div class="row m-0 pb-2 justify-content-between align-items-center">
                    <div class="col-lg-5 col-md-6 mb-md-0 mb-40">
                        <div class="interface-img">
                            <img class="h-auto w-100"
                                src="<?php echo e(isset($aboutUS[0]['about_url']) ? $aboutUS[0]['about_url'] : asset('front/images/about-1.png')); ?>"
                                alt="interface-img">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="card-desc ps-lg-0 ps-md-4">
                            <h3 class="card-title fs-20 fw-6 mb-3">
                                <?php echo e($aboutUS[0]['title']); ?>

                            </h3>
                            <p class="card-text text-gray-100">
                                <?php echo nl2br(e($aboutUS[0]['description'])); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="interface-card mb-40">
                <div class="row pb-2 m-0 flex-md-row flex-column-reverse justify-content-between align-items-center">
                    <div class="col-lg-6 col-md-6 pe-lg-0 pe-md-4">
                        <div class="card-desc">
                            <h3 class="card-title fs-20 fw-6 mb-3">
                                <?php echo e($aboutUS[1]['title']); ?>

                            </h3>
                            <p class="card-text text-gray-100">
                                <?php echo nl2br(e($aboutUS[1]['description'])); ?>

                            </p>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6 mb-md-0 mb-40">
                        <div class="interface-img">
                            <img class="h-auto w-100"
                                src="<?php echo e(isset($aboutUS[1]['about_url']) ? $aboutUS[1]['about_url'] : asset('front/images/about-2.png')); ?>"
                                alt="interface img" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="interface-card">
                <div class="row m-0 pb-2 justify-content-between align-items-center">
                    <div class="col-lg-5 col-md-6 mb-md-0 mb-40">
                        <div class="interface-img">
                            <img class="h-auto w-100"
                                src="<?php echo e(isset($aboutUS[2]['about_url']) ? $aboutUS[2]['about_url'] : asset('front/images/about-3.png')); ?>"
                                alt="interface img" />
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="card-desc ps-lg-0 ps-md-4">
                            <h3 class="card-title fs-20 fw-6 mb-3">
                                <?php echo e($aboutUS[2]['title']); ?>

                            </h3>
                            <p class="card-text text-gray-100">
                                <?php echo nl2br(e($aboutUS[2]['description'])); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- end modern & powerful-interface section  -->

    <!-- start pricing section -->
    <section class="pricing-plan-section pb-100 <?php if(checkFrontLanguageSession() == 'ar'): ?> rtl <?php endif; ?>" id="frontPricingTab">
        <div class="container">
            <div class="section-heading text-center mb-60">
                <h2 class="d-inline-block"> <?php echo e(__("auth.choose_a_plan_that's_right_for_you")); ?></h2>
            </div>
            <div class="pricing-slider">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="">
                        <div class="pricing-card h-100 position-relative">
                            <?php if($plan->trial_days > 0): ?>
                                <div class="trial-plan-lable">
                                    <span class="px-4 py-1"><?php echo e(__('messages.subscription.trial_plan')); ?></span>
                                </div>
                            <?php endif; ?>
                            <div class="pricing-card-body">
                                <div class="text-center">
                                    <h3 class="card-title text-primary"><?php echo $plan->name; ?></h3>
                                    <div
                                        class="<?php echo e(getLoggedInUserRoleId() != getSuperAdminRoleId() ? '' : 'd-flex justify-content-center align-items-center mb-4'); ?>">
                                        <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                            <h2 class="price text-center fw-5 mb-30">
                                                <?php echo e($plan->currency->currency_icon); ?> <span
                                                    class="custom-price-<?php echo e($plan->id); ?>"><?php echo e($plan->planCustomFields[0]->custom_vcard_price); ?></span>
                                                <?php if($plan->frequency == 1): ?>
                                                    <span class="fs-18">/ <?php echo e(__('messages.plan.monthly')); ?></span>
                                                <?php elseif($plan->frequency == 2): ?>
                                                    <span class="fs-18">/ <?php echo e(__('messages.plan.yearly')); ?></span>
                                                <?php endif; ?>
                                            </h2>
                                        <?php else: ?>
                                            <h2 class="price text-center fw-5 mb-30" id="price_<?php echo e($plan->id); ?>">
                                                <?php echo e($plan->currency->currency_icon); ?> <?php echo e($plan->price); ?>

                                                <?php if($plan->frequency == 1): ?>
                                                    <span class="fs-18">/ <?php echo e(__('messages.plan.monthly')); ?></span>
                                                <?php elseif($plan->frequency == 2): ?>
                                                    <span class="fs-18">/ <?php echo e(__('messages.plan.yearly')); ?></span>
                                                <?php endif; ?>
                                            </h2>
                                        <?php endif; ?>
                                        <div
                                            class="d-flex justify-content-center align-items-center <?php echo e(getLoggedInUserRoleId() != getSuperAdminRoleId() ? 'mb-4' : 'ms-2'); ?>">
                                            <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                
                                                <select id="vcardNumber-<?php echo e($plan->id); ?>"
                                                    class="form-select customSelect me-2"
                                                    data-plan-id="<?php echo e($plan->id); ?>"
                                                    style="<?php echo e(getLoggedInUserRoleId() != getSuperAdminRoleId() ? 'width:30% !important; padding: 10px 30px' : 'width:100% !important; padding: 10px 30px'); ?>">
                                                    <?php $__currentLoopData = $plan->planCustomFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $formattedPrice = $customField->custom_vcard_price;
                                                        ?>
                                                        <option value="<?php echo e($customField->id); ?>"
                                                            data-price="<?php echo e($formattedPrice); ?>"
                                                            data-currency="<?php echo e($plan->currency->currency_code); ?>">
                                                            <?php echo e($customField->custom_vcard_number); ?> </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            <?php endif; ?>
                                            <div class="text-center">
                                                <?php if(getLoggedInUserRoleId() != getSuperAdminRoleId()): ?>
                                                    <?php if(getLogInUser() && getLoggedInUserRoleId() != getSuperAdminRoleId()): ?>
                                                        <div class="mx-auto">
                                                            <?php if(
                                                                !empty(getCurrentSubscription()) &&
                                                                    $plan->id == getCurrentSubscription()->plan_id &&
                                                                    !getCurrentSubscription()->isExpired()): ?>
                                                                <?php if($plan->price != 0): ?>
                                                                    <button type="button"
                                                                        class="btn btn-success rounded-3  mx-auto w-100 d-block cursor-remove-plan pricing-plan-button-active"
                                                                        data-id="<?php echo e($plan->id); ?>" data-turbo="false">
                                                                        <?php echo e(__('messages.subscription.currently_active')); ?></button>
                                                                <?php else: ?>
                                                                    <button type="button"
                                                                        class="btn btn-info rounded-3  mx-auto d-block cursor-remove-plan"
                                                                        data-turbo="false">
                                                                        <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                    </button>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php if(
                                                                    !empty(getCurrentSubscription()) &&
                                                                        !getCurrentSubscription()->isExpired() &&
                                                                        ($plan->price == 0 || $plan->price != 0)): ?>
                                                                    <?php if($plan->hasZeroPlan->count() == 0): ?>
                                                                        <a href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                            class="btn btn-primary rounded-3 mx-auto w-100 <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                            data-id="<?php echo e($plan->id); ?>"
                                                                            id="planId<?php echo e($plan->id); ?>"
                                                                            data-plan-price="<?php echo e($plan->price); ?>"
                                                                            data-turbo="false">
                                                                            <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                    <?php else: ?>
                                                                        <button type="button"
                                                                            class="btn btn-info rounded-3 mx-auto d-block cursor-remove-plan"
                                                                            data-turbo="false">
                                                                            <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                        </button>
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <?php if($plan->hasZeroPlan->count() == 0): ?>
                                                                        <a href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                            class="btn btn-primary rounded-3 mx-auto w-100 <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                            data-id="<?php echo e($plan->id); ?>"
                                                                            id="planId<?php echo e($plan->id); ?>"
                                                                            data-plan-price="<?php echo e($plan->price); ?>"
                                                                            data-turbo="false">
                                                                            <?php echo e(__('messages.subscription.choose_plan')); ?></a>
                                                                    <?php else: ?>
                                                                        <button type="button"
                                                                            class="btn btn-info rounded-3 mx-auto d-block cursor-remove-plan"
                                                                            data-turbo="false">
                                                                            <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                        </button>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="mx-auto">
                                                            <?php if($plan->hasZeroPlan->count() == 0): ?>
                                                                <a href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                    class="btn btn-primary rounded-3 mx-auto w-100 <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                    data-id="<?php echo e($plan->id); ?>"
                                                                    data-plan-price="<?php echo e($plan->price); ?>"
                                                                    id="planId<?php echo e($plan->id); ?>" data-turbo="false">
                                                                    <?php echo e(__('messages.subscription.choose_plan')); ?></a>
                                                            <?php else: ?>
                                                                <button type="button"
                                                                    class="btn btn-info rounded-3 mx-auto d-block cursor-remove-plan"
                                                                    data-turbo="false">
                                                                    <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                </button>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <ul class="pricing-plan-list ps-xl-4 ps-lg-3 ps-md-4 ps-3 mb-60">
                                    <?php if($plan->trial_days > 0): ?>
                                        <li class="active-check">
                                            <span class="check-box">
                                                <i class="fa-solid fa-check"
                                                    style="font-size: 18px; color: #7638f9; margin-right: 20px"></i>
                                            </span>
                                            <label
                                                class=""><?php echo e(__('messages.subscription.trial_plan') . ' (' . $plan->trial_days . ' ' . __('messages.plan.days') . ')'); ?></label>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($plan->custom_select == 0 && $plan->planCustomFields->isEmpty()): ?>
                                        <li class="active-check">
                                            <span class="check-box">
                                                <i class="fa-solid fa-check"
                                                    style="font-size: 18px; color: #7638f9; margin-right: 20px"></i>
                                            </span>
                                            <label class=""><?php echo e(__('messages.plan.no_of_vcards')); ?>

                                                : <?php echo e($plan->no_of_vcards); ?></label>
                                        </li>
                                    <?php endif; ?>
                                    <li class="active-check">
                                        <span class="check-box">
                                            <i class="fa-solid fa-check"
                                                style="font-size: 18px; color: #7638f9; margin-right: 20px"></i>
                                        </span>
                                        <label class=""><?php echo e(__('messages.plan.storage_limit')); ?>:
                                            <?php echo e($plan->storage_limit); ?> <?php echo e(__('messages.mb')); ?></label>
                                    </li>
                                    <?php
                                        $skipCount =
                                            $plan->custom_select == 0 && $plan->planCustomFields->isEmpty() ? 9 : 10;
                                    ?>
                                    <?php $__currentLoopData = collect(getPlanFeature($plan))->take($skipCount); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="<?php echo e($value == 1 ? 'active-check' : 'unactive-check'); ?>"
                                            <?php if(checkFrontLanguageSession() == 'ar'): ?> style="text-align: right !important" <?php endif; ?>>
                                            <?php if(checkFrontLanguageSession() == 'ar'): ?>
                                                <?php echo e(__('messages.feature.' . $feature)); ?>

                                                <span class="check-box">
                                                    <i class="fa-solid <?php echo e($value == 1 ? 'fa-check' : 'fa-xmark'); ?>"></i>
                                                </span>
                                            <?php else: ?>
                                                <span class="check-box">
                                                    <i class="fa-solid <?php echo e($value == 1 ? 'fa-check' : 'fa-xmark'); ?>"></i>
                                                </span>
                                                <?php echo e(__('messages.feature.' . $feature)); ?>

                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="all-features d-none" style="display: none;">

                                        <?php $__currentLoopData = collect(getPlanFeature($plan))->skip($skipCount); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="<?php echo e($value == 1 ? 'active-check' : 'unactive-check'); ?>"
                                                <?php if(checkFrontLanguageSession() == 'ar'): ?> style="text-align: right !important" <?php endif; ?>>
                                                <?php if(checkFrontLanguageSession() == 'ar'): ?>
                                                    <?php echo e(__('messages.feature.' . $feature)); ?>

                                                    <span class="check-box">
                                                        <i
                                                            class="fa-solid <?php echo e($value == 1 ? 'fa-check' : 'fa-xmark'); ?>"></i>
                                                    </span>
                                                <?php else: ?>
                                                    <span class="check-box">
                                                        <i
                                                            class="fa-solid <?php echo e($value == 1 ? 'fa-check' : 'fa-xmark'); ?>"></i>
                                                    </span>
                                                    <?php echo e(__('messages.feature.' . $feature)); ?>

                                                <?php endif; ?>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </ul>
                                <div class="text-center show-plan-features" id="seeMorePlanFeatures">
                                    <i class="fa-solid fa-circle-chevron-down show-plan-icon-btn"></i>
                                </div>
                                <div class="text-center d-none less-plan-features" id="lessMorePlanFeatures">
                                    <i class="fa-solid fa-circle-chevron-up less-plan-icon-btn"></i>
                                </div>
                            </div>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- end pricing section -->

    <!-- start testimonial section -->
    <?php if(!$testimonials->isEmpty()): ?>
        <section class="testimonial-section <?php if(checkFrontLanguageSession() == 'ar'): ?> rtl <?php endif; ?>">
            <div class="section-heading text-center mb-60">
                <h2 class="d-inline-block"><?php echo e(__('auth.stories_from_our_customers')); ?></h2>
            </div>
            <div class="testimonial bg-light pt-50 pb-50">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="testimonial-slider">
                                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="">
                                        <div class="testimonial-card mb-60">
                                            <div class="quote-img">
                                                <img src="<?php echo e(asset('assets/img/new_home_page/quote-img.png')); ?>"
                                                    alt="quotation" class="w-sm-100 w-50 h-auto">
                                            </div>
                                            <div class="profile-img">
                                                <img src="<?php echo e($testimonial->testimonial_url); ?>" alt="profile-img"
                                                    class="w-100 h-100 object-fit-cover">
                                            </div>
                                            <div class="profile-desc ps-3">
                                                <p class="fs-20 mb-0 fw-6"><?php echo e($testimonial->name); ?></p>
                                            </div>
                                            <p class="mt-4 mb-0 profile-text text-gray-100"><?php echo $testimonial->description; ?>

                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- end testimonial section -->

    <!-- start contact section -->
    <section class="contact-section pt-100 pb-100" id="frontContactUsTab"
        <?php if(checkFrontLanguageSession() == 'ar'): ?> dir="rtl" <?php endif; ?>>
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6">
                    <div class="contact-info">
                        <div class="section-heading ms-0 mb-60">
                            <h2 class="d-inline-block"><?php echo e(__('messages.vcard_11.get_in_touch')); ?></h2>
                        </div>
                        <div class="d-flex align-items-center contact-info__block">
                            <div class="contact-icon fs-2 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-location-dot icon-purpul"></i>
                            </div>
                            <p class="address-text text-secondary mb-0">
                                <?php echo e($setting['address']); ?>

                            </p>
                        </div>
                        <div class="d-flex align-items-center contact-info__block">
                            <div class="contact-icon fs-2 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-at icon-purpul"></i>
                            </div>
                            <a href="mailto:<?php echo e($setting['email']); ?>"
                                class="text-decoration-none text-secondary"><?php echo e($setting['email']); ?></a>
                        </div>
                        <div class="d-flex align-items-center contact-info__block">
                            <div class="contact-icon fs-2 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-phone icon-purpul"></i>
                            </div>
                            <a href=" tel:<?php echo e($setting['phone']); ?>"
                                class="text-decoration-none text-secondary" dir="ltr"><?php echo e('+' . $setting['prefix_code'] . ' ' . $setting['phone']); ?></a>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-lg-6">
                    <form class="contact-form" id="myForm">
                        <?php echo csrf_field(); ?>
                        <div id="contactError" class="alert alert-danger d-none"></div>

                        <p class="text-center mb-40 fs-4 fw-6"><?php echo e(__('messages.contact_us.send_message')); ?></p>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <input name="name" id="name" type="text" class="form-control front-input"
                                        placeholder="<?php echo e(__('messages.front.enter_your_name')); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <input name="email" id="email" type="email" class="form-control front-input"
                                        placeholder="<?php echo e(__('messages.front.enter_your_email')); ?>" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-4">
                                    <input name="subject" id="subject" type="text" class="form-control front-input"
                                        placeholder="<?php echo e(__('messages.common.subject')); ?>" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-4">
                                    <textarea name="message" id="message" rows="4" class="form-control h-100 form-textarea front-input"
                                        placeholder="<?php echo e(__('messages.front.enter_your_message')); ?>" required></textarea>
                                </div>
                            </div>
                            <div class="col-lg-12 text-center">
                                <input type="submit" id="submit" name="send"
                                    class="contact-section-submit-btn btn btn-primary w-auto front-input "
                                    value="<?php echo e(__('messages.contact_us.send_message')); ?>">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <!-- end contact section -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/front/home/home1.blade.php ENDPATH**/ ?>