<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.plan.affiliation')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="col-12">
                <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="d-flex justify-content-between align-items-end mb-5">
                    <h1><?php echo e(__('messages.plan.affiliation')); ?></h1>
                </div>
                <div class="row">
                    <div class="col">
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" id="urlLink" placeholder="Copy Url"
                                aria-label="Recipient's username" aria-describedby="basic-addon2" readonly
                                value="<?php echo e(config('app.url')); ?>/register?referral-code=<?php echo e(getLogInUser()->affiliate_code); ?>">
                            <button onclick="copyClipboardUrl()" class="btn btn-primary" id="copyLinkBtn">
                                <span class="copy-link-btn"></span><?php echo e(__('messages.copy_text')); ?></button>
                        </div>
                        
                    </div>
                    <div class="col">
                        <div class="card-toolbar custom-toolbar ms-auto">
                            <div class="d-flex justify-content-end">
                                <a type="button" class="btn btn-warning me-2" data-bs-target="#adminGuideAffiliationModal"
                                    id="adminGuideAffiliation"><?php echo e(__('messages.affiliation.how_it_works')); ?></a>
                                <a type="button"
                                    class="btn btn-primary sendInviteBtn"><?php echo e(__('messages.plan.sendinvite')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 widget">
                                <div
                                    class="bg-info shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center
                            justify-content-between my-3">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <h2 class="fw-bolder text-white">
                                            <?php echo e(__('messages.affiliation.total_affiliation_amount')); ?></h2>
                                    </div>
                                    <div class="text-end text-white">
                                        <h3 class="mb-0 fs-3 "><?php echo e(currencyFormat($totalAmount, 2)); ?></h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 widget">
                                <div
                                    class="bg-success shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <h2 class="fw-bolder text-white"><?php echo e(__('messages.affiliation.current_amount')); ?>

                                        </h2>
                                    </div>
                                    <div class="text-end text-white">
                                        <h3 class="mb-0 fs-3"> <?php echo e(currencyFormat($currentAmount, 2)); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h3 class="text-primary">
                            <?php echo e(__('messages.affiliation.affiliate_note')); ?>

                            <?php if(getSuperAdminSettingValue('affiliation_amount_type') == 1): ?>
                                <?php echo e(currencyFormat(getSuperAdminSettingValue('affiliation_amount'))); ?>

                            <?php else: ?>
                                <?php echo e(getSuperAdminSettingValue('affiliation_amount')); ?>%
                            <?php endif; ?>
                        </h3>
                    </div>
                </div>
                <ul class="nav nav-pills my-5 products-detail__nav-pills position-relative" id="affiliationWithdraw">
                    <li class="nav-item">
                        <button class="nav-link active position-relative" id="affiliation-tab" data-bs-toggle="pill"
                            data-bs-target="#affiliation" type="button" role="tab" aria-controls="affiliation"
                            aria-selected="true"><?php echo e(__('messages.feature.affiliation')); ?>

                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link position-relative" id="withdrawal-tab" data-bs-toggle="pill"
                            data-bs-target="#withdrawal" type="button" role="tab" aria-controls="withdrawal"
                            aria-selected="false"><?php echo e(__('messages.affiliation.withdrawal')); ?>

                        </button>
                    </li>
                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="affiliation" role="tabpanel"
                        aria-labelledby="affiliation-tab">
                        <div class="">
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('affiliate-user-table', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-833735127-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                        </div>
                    </div>
                    <div class="tab-pane fade " id="withdrawal" role="tabpanel" aria-labelledby="withdrawal-tab">
                        <div class="">
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('withdrawal-table', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-833735127-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user-settings.affiliationWithdraw.guide_affiliation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('user-settings.affiliationWithdraw.withdraw-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('user-settings.affiliationWithdraw.sendmail-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('sadmin.affiliationWithdraw.show-withdraw-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/user-settings/affiliationWithdraw/index.blade.php ENDPATH**/ ?>