<div class="modal fade" id="editTestimonialModal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title"><?php echo e(__('messages.vcard.edit_testimonial')); ?></h2>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['id'=>'editTestimonialForm', 'files' => 'true']); ?>

                <div class="row">
                    <div class="col-sm-12 mb-5">
                        <?php echo e(Form::hidden('testimonial_id', null,['id' => 'testimonialId'])); ?>

                        <?php echo e(Form::label('name',__('messages.common.name').(':'), ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::text('name', null, ['class' => 'form-control', 'id' => 'editName', 'required', 'placeholder' => __('messages.form.testimonial')])); ?>

                    </div>
                    <div class="col-sm-12 mb-5">
                        <?php echo e(Form::label('description', __('messages.common.description').':', ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'id' => 'editDescription', 'placeholder' => __('messages.form.short_description'), 'rows' => '5' , 'required'])); ?>

                    </div>
                    <div class="col-sm-12 mb-5">

                        <div class="mb-3" io-image-input="true">
                            <label for="editTestimonialPreview"
                                   class="form-label required"><?php echo e(__('messages.vcard.image').':'); ?></label>
                            <div class="d-block">
                                <div class="image-picker">
                                    <div class="image previewImage" id="editTestimonialPreview"
                                         style="background-image: url('<?php echo e(asset('web/media/avatars/user.png')); ?>')"></div>
                                    <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                          data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                        <label>
                                            <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                            <input type="file" id="editTestimonialImg" name="image"
                                                   class="image-upload file-validation d-none" accept="image/*"/> </label>
                                    </span>
                                </div>
                                <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer pt-0">
                        <?php echo e(Form::button(__('messages.common.save'),['class' => 'btn btn-primary m-0','id' => 'testimonialUpdate','type'=>'submit'])); ?>

                        <?php echo e(Form::button(__('messages.common.discard'),['class' => 'btn btn-secondary my-0 ms-5 me-0','data-bs-dismiss' => 'modal'])); ?>

                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/vcards/testimonials/edit.blade.php ENDPATH**/ ?>