    <!-- start header section -->
    <header class="header" <?php if(checkFrontLanguageSession() == 'ar'): ?> dir="rtl" <?php endif; ?>>
        <div class="container" id="frontHomeTab">
            <div class="row align-items-center justify-content-between">
                <div class="col-lg-2 col-md-8 col-sm-7 col-5 order-lg-1 order-0">
                    <a class="navbar-brand p-0" href="#">
                        <img src="<?php echo e(getLogoUrl()); ?>" alt="company-logo" class="w-auto h-100" />
                    </a>
                </div>
                <div class="col-lg-10 col-sm-1 col-2 order-lg-1 order-2">
                    <nav class="navbar navbar-expand-lg navbar-light justify-content-end">
                        <div class="navbar-toggler mt-2 nav-btn" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false"
                            aria-label="Toggle navigation" id="toogler-icon">
                            <span class="navbar-toggler-icon top-bar"></span>
                            <span class="navbar-toggler-icon middle-bar"></span>
                            <span class="navbar-toggler-icon bottom-bar"></span>
                        </div>
                        <div class="navbar-collapse justify-content-end new-home-nav d-none" id="navbarNav">
                            <ul class="navbar-nav align-items-lg-center" data-turbo="false">
                                <li class="nav-item">
                                    <a class="nav-link active" aria-current="page" data-turbo="false"
                                        href="<?php echo e(asset('') . '#frontHomeTab'); ?>"><?php echo e(__('auth.home')); ?></a>
                                </li>
                                
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="<?php echo e(asset('') . '#frontAboutTabUsTab'); ?>"><?php echo e(__('auth.about')); ?></a>
                                </li>
                                <li class="nav-item <?php if($faqs === null): ?> d-none <?php endif; ?>">
                                    <a class="nav-link"
                                        href="<?php echo e(route('fornt-faq')); ?>"><?php echo e(__('messages.faqs.faqs')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="<?php echo e(asset('') . '#frontPricingTab'); ?>"><?php echo e(__('auth.pricing')); ?></a>
                                </li>
                                <li class="nav-item px-3">
                                    <a class="nav-link mt-1"
                                        href="<?php echo e(route('fornt-blog')); ?>"><?php echo e(__('messages.blog.blogs')); ?> </a>
                                </li>

                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="<?php echo e(asset('') . '#frontContactUsTab'); ?>"><?php echo e(__('auth.contact')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <div class="dropdown">
                                        <a class="btn dropdown-toggle" href="#" role="button"
                                            id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                                            <?php echo e(__('messages.language')); ?></a>
                                        <ul class="dropdown-menu p-2" aria-labelledby="dropdownMenuLink">
                                            <?php $__currentLoopData = getAllLanguageWithFullData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="languageSelection <?php echo e(checkFrontLanguageSession() == $key ? 'active' : ''); ?>"
                                                    data-prefix-value="<?php echo e($language->iso_code); ?>">
                                                    <a href="javascript:void(0)"
                                                        class="nav-link d-flex align-items-center dropdown-item <?php echo e(checkFrontLanguageSession() == $key ? 'active' : ''); ?>">
                                                        <?php if(array_key_exists($language->iso_code, \App\Models\User::FLAG)): ?>
                                                            <?php $__currentLoopData = \App\Models\User::FLAG; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageKey => $imageValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($imageKey == $language->iso_code): ?>
                                                                    <img src="<?php echo e(asset($imageValue)); ?>"
                                                                        class="me-1" />
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <?php if(count($language->media) != 0): ?>
                                                                <img src="<?php echo e($language->image_url); ?>" class="me-1" />
                                                            <?php else: ?>
                                                                <i class="fa fa-flag fa-xl me-3 text-danger"
                                                                    aria-hidden="true"></i>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                        <?php echo e($language->name); ?>

                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </li>
                                <?php if(empty(getLogInUser())): ?>
                                    <li>
                                        <a class="btn btn-white fs-18 d-lg-block d-none" href="<?php echo e(route('login')); ?>"
                                            role="button" data-turbo="false"><?php echo e(__('auth.sign_in')); ?></a>
                                    </li>
                                <?php else: ?>
                                    <?php if(getLogInUser()->hasrole('admin') || getLogInUser()->hasrole('user')): ?>
                                        <li>
                                            <a class="btn btn-white fs-18 d-lg-block d-none"
                                                href="<?php echo e(route('admin.dashboard')); ?>" role="button"
                                                data-turbo="false"><?php echo e(__('messages.dashboard')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(getLogInUser()->hasrole('super_admin')): ?>
                                        <li>
                                            <a class="btn btn-white fs-18 d-lg-block d-none"
                                                href="<?php echo e(route('sadmin.dashboard')); ?>" role="button"
                                                data-turbo="false"><?php echo e(__('messages.dashboard')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </nav>
                </div>
                <div class="col-lg-2 col-md-3 col-sm-4 col-5 text-end order-lg-2 order-1 pe-lg-2 pe-0 ps-0 d-lg-none">

                        <?php if(empty(getLogInUser())): ?>
                            <a class="btn btn-white fs-18 me-sm-2" href="<?php echo e(route('login')); ?>" data-turbo="false"
                                role="button">
                                <span><?php echo e(__('auth.sign_in')); ?></span>
                            </a>
                        <?php else: ?>
                            <?php if(getLogInUser()->hasrole('admin') || getLogInUser()->hasrole('user')): ?>
                                <span> <a class="btn btn-white fs-18 me-sm-2" href="<?php echo e(route('admin.dashboard')); ?>"
                                        data-turbo="false" role="button">
                                        <?php echo e(__('messages.dashboard')); ?>

                                    </a></span>
                            <?php endif; ?>
                            <?php if(getLogInUser()->hasrole('super_admin')): ?>
                                <span><a class="btn btn-white fs-18 me-sm-2" href="<?php echo e(route('sadmin.dashboard')); ?>"
                                        data-turbo="false" role="button">
                                        <?php echo e(__('messages.dashboard')); ?>

                                    </a></span>
                            <?php endif; ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </header>

    <!-- end header section -->
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/front/layouts/header1.blade.php ENDPATH**/ ?>