<div class="modal fade" id="editWpStoreProductModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><?php echo e(__('messages.vcard.edit_product')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editWhatsappStoreProductForm">
                    <input type="hidden" value="<?php echo e($whatsappStore->id); ?>" name="whatsapp_store_id">
                    <input type="hidden" name="id" id="editProductID">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label required"><?php echo e(__('messages.common.name') . ':'); ?></label>
                                <input type="text" class="form-control" name="name"
                                    placeholder="<?php echo e(__('messages.form.product')); ?>" required id="editProductName">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label"><?php echo e(__('messages.whatsapp_stores.net_price') . ':'); ?></label>
                                <input type="number" id="editProductNetPrice" class="form-control" name="net_price"
                                    placeholder="<?php echo e(__('messages.whatsapp_stores.enter_net_price')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label required"><?php echo e(__('messages.whatsapp_stores.selling_price') . ':'); ?></label>
                                <input type="number" id="editProductSellingPrice" class="form-control"
                                    name="selling_price" placeholder="<?php echo e(__('messages.whatsapp_stores.enter_selling_price')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6 mt-5">
                            <div class="form-group">
                                <label class="form-label required"><?php echo e(__('messages.whatsapp_stores.category') . ':'); ?></label>
                                <select name="category_id" class="form-control wpStoreCategory" required
                                    data-control="select2" data-dropdown-parent="#editWpStoreProductModal">
                                    <option value=""><?php echo e(__('messages.whatsapp_stores.select_category')); ?></option>
                                    <?php $__currentLoopData = $productsCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 mt-5">
                            <div class="form-group">
                                <label class="form-label required"><?php echo e(__('messages.setting.currency') . ':'); ?></label>
                                <select name="currency_id" class="form-control wpStoreCategory" required
                                    data-control="select2" data-dropdown-parent="#editWpStoreProductModal">
                                    <option value=""><?php echo e(__('messages.setting.select_currency')); ?></option>
                                    <?php $__currentLoopData = getCurrencies(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12 mt-5">
                            <div class="form-group">
                                <label for="description" class="form-label required">
                                    <?php echo e(__('messages.vcard.description')); ?>:
                                </label>
                                <div id="editWpStoreProductDescriptionQuill" class="editor-height" style="height: 150px">
                                </div>
                                <input type="hidden" name="description" id="editWpStoreProductDescriptionData">
                            </div>
                        </div>
                        <div class="col-sm-12 mt-5 col-lg-12">
                            <div class="mb-3" io-image-input="true">
                                <div class="d-flex justify-content-between">
                                    <label for="editProductPreview"
                                        class="form-label required"><?php echo e(__('messages.whatsapp_stores.product_images') . ':'); ?></label>
                                </div>
                                <div class="d-flex align-items-start flex-wrap" id="editWpStoreImageContainer">
                                    <div class="d-block">
                                        <div class="image-picker">
                                            <div class="image previewImage ms-4 mt-1" id="editProductPreview"
                                                style="background-image: url('<?php echo e(asset('assets/images/default_service.png')); ?>')">
                                            </div>
                                            <span class="picker-edit rounded-circle text-gray-500 fs-small"
                                                data-bs-toggle="tooltip" data-placement="top"
                                                data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                                <label>
                                                    <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                                    <input type="file" id="editProductIcon" name="images[]"
                                                        class="image-upload file-validation d-none" accept="image/*"
                                                        multiple />
                                                </label>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="submit" id="editWPStoreProductSave" class="btn btn-primary m-0"><?php echo e(__('crud.save')); ?>

                </button>
                </form>
                <button class="btn btn-secondary my-0 ms-5 me-0"
                    data-bs-dismiss="modal"><?php echo e(__('messages.common.discard')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/whatsapp_stores/products/edit_product.blade.php ENDPATH**/ ?>