<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Corporate CEO</title>
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
      integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
      crossorigin="anonymous"
      referrerpolicy="no-referrer"
    />

    <link href="<?php echo e(asset('front/css/bootstrap.min.css')); ?>" rel="stylesheet">

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vcard18.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/slick-theme.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/custom.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/plugins.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-vcard.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/lightbox.css')); ?>">
  </head>
  <body>
    <div class="container p-0">
      <div class="main-content mx-auto w-100 overflow-hidden">
        <div class="banner-section">
            <div class="banner-img">
                <img src="<?php echo e(asset('assets/img/vcard18/banner-img.png')); ?>" class="w-100 h-100 object-fit-cover" alt="" loading="lazy">  </div>
          <img
            src="<?php echo e(asset('assets//img/vcard18/curve-shape.png')); ?>"
            class="curve-img w-100"
            loading="lazy"
          />
          <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
            <div class="language pt-3 me-2">
                <ul class="text-decoration-none">
                    <li class="dropdown1 dropdown lang-list">
                        <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                            role="button" aria-haspopup="true" aria-expanded="false">
                            <i class="fa-solid fa-language me-2"></i>Language</a>
                        <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/english.png')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">English</a>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/spain.png')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">Spanish</a>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/france.png')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">Franch</a>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/arabic.svg')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">Arabic</a>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/german.png')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">German</a>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/russian.jpeg')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">russian</a>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('assets/img/vcard1/turkish.png')); ?>" width="25px"
                                    height="20px" class="me-3" loading="lazy"><a href="#">Turkish</a>
                            </li>

                        </ul>
                    </li>
                </ul>
            </div>
        </div>
        <div class="overlay"></div>
        </div>

        <div class="profile-section pb-40 px-30">
          <div class="card flex-sm-row-reverse align-items-center pt-sm-0 pt-4">
            <div
              class="card-img d-flex justify-content-center align-items-center"
            >
              <img
                src="<?php echo e(asset('assets//img/vcard18/profile-img.png')); ?>"
                class="w-100 h-100 object-fit-cover"
                loading="lazy"
              />
            </div>
            <div class="card-body pt-sm-5 px-0">
              <div class="profile-name">
                <h2 class="fs-24 text-black mb-2">Jenny Wilson</h2>
                <p class="fs-6 text-gray-200 mb-0">Corporate CEO</p>
              </div>
            </div>
          </div>
          <div class="social-media pt-4 d-flex">
            <a
              href=""
              class="social-icon d-flex justify-content-center align-items-center"
            >
              <svg
                width="10"
                height="20"
                viewBox="0 0 10 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M2.79059 11.2889C2.34698 11.2889 1.93968 11.2889 1.53237 11.2889C1.18499 11.2889 0.837601 11.2954 0.49082 11.2863C0.127698 11.2772 0.00907804 11.1596 0.00605203 10.7711C-0.00181561 9.753 -0.00242081 8.73429 0.00665723 7.71622C0.0102884 7.33094 0.137381 7.20882 0.495661 7.20621C1.16744 7.20164 1.83921 7.20491 2.51159 7.20491C2.5939 7.20491 2.67621 7.20491 2.79059 7.20491C2.79059 7.09455 2.78938 6.99986 2.79059 6.90582C2.80633 5.97788 2.77365 5.04601 2.84748 4.12329C3.03449 1.77307 4.69698 0.0947997 6.88297 0.0183961C7.77262 -0.012949 8.66469 0.0046826 9.55494 0.00729469C9.86844 0.00794771 9.99553 0.146388 9.99674 0.48596C10.001 1.43872 10.001 2.39213 9.99735 3.34489C9.99614 3.70993 9.87752 3.84249 9.52953 3.85098C8.91827 3.86666 8.30702 3.86666 7.69516 3.8771C7.00946 3.88821 6.72138 4.1775 6.70686 4.90823C6.69233 5.6468 6.70383 6.38667 6.70383 7.15397C6.80732 7.15397 6.88781 7.15397 6.96831 7.15397C7.74599 7.15397 8.52368 7.15266 9.30136 7.15462C9.79158 7.15528 9.90657 7.27805 9.90717 7.79785C9.90778 8.76694 9.90899 9.73667 9.90657 10.7058C9.90536 11.1394 9.79945 11.2563 9.39517 11.2582C8.51218 11.2621 7.62919 11.2595 6.70444 11.2595C6.70444 11.3731 6.70444 11.4744 6.70444 11.5749C6.70444 14.1243 6.70444 16.6744 6.70444 19.2238C6.70444 19.9264 6.63545 19.9996 5.97335 19.9996C5.10489 19.9996 4.23703 20.0009 3.36856 19.9989C2.90376 19.9983 2.79059 19.8775 2.79059 19.3812C2.78999 16.7906 2.78999 14.2001 2.78999 11.6102C2.79059 11.5142 2.79059 11.4182 2.79059 11.2889Z"
                  fill="#49ADFE"
                />
              </svg>
            </a>
            <a
              href=""
              class="social-icon d-flex justify-content-center align-items-center"
            >
              <svg
                width="20"
                height="20"
                viewBox="0 0 20 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <g clip-path="url(#clip0_603_306)">
                  <path
                    d="M20 8.98051C20 9.37148 20 9.76195 20 10.1529C19.9686 10.4103 19.9431 10.6682 19.9054 10.9246C19.6001 12.9983 18.7208 14.7927 17.2485 16.287C15.6704 17.8891 13.7574 18.8335 11.5225 19.0923C9.56846 19.3189 7.70799 18.9763 5.95927 18.0657C5.8387 18.0031 5.73627 17.9786 5.59561 18.029C4.56049 18.3999 3.52047 18.7566 2.48291 19.1212C1.65462 19.4118 0.827799 19.7069 0 20C0.0171539 19.9183 0.0249957 19.8336 0.052442 19.7553C0.665082 18.0006 1.27674 16.245 1.89918 14.4937C1.97221 14.2887 1.96682 14.1296 1.86488 13.931C0.925331 12.1029 0.616071 10.1617 0.91749 8.13545C1.22038 6.0989 2.10013 4.32952 3.55772 2.87037C5.71961 0.706596 8.3471 -0.228495 11.3878 0.0469922C13.236 0.21434 14.8979 0.896452 16.3487 2.05859C18.238 3.57156 19.4197 5.51514 19.8481 7.90303C19.9118 8.25974 19.95 8.62135 20 8.98051ZM8.23192 7.89373C8.24417 7.8722 8.24613 7.86535 8.25054 7.86094C8.50295 7.6065 8.75683 7.35401 9.00728 7.09809C9.30134 6.79716 9.30134 6.47372 9.00434 6.17377C8.57794 5.74366 8.14958 5.31501 7.71828 4.8893C7.41441 4.58935 7.09437 4.58935 6.79148 4.88735C6.47585 5.19807 6.17198 5.52102 5.84851 5.82342C5.48239 6.16594 5.37359 6.58529 5.42309 7.06384C5.50592 7.85948 5.83429 8.56654 6.24011 9.2374C7.29532 10.9813 8.69508 12.3989 10.3943 13.5204C11.0814 13.974 11.8112 14.3459 12.6297 14.5113C13.259 14.6385 13.8138 14.548 14.2608 14.0313C14.5156 13.7367 14.8112 13.4769 15.0866 13.1994C15.4023 12.8809 15.4018 12.5658 15.0837 12.2453C14.6798 11.8386 14.273 11.4345 13.8672 11.0298C13.4947 10.6584 13.2007 10.6574 12.8302 11.0268C12.5871 11.2695 12.3449 11.5132 12.1048 11.754C10.3605 10.9001 9.07883 9.62005 8.23192 7.89373Z"
                    fill="#49ADFE"
                  />
                </g>
                <defs>
                  <clipPath id="clip0_603_306">
                    <rect width="20" height="20" fill="white" />
                  </clipPath>
                </defs>
              </svg>
            </a>

            <a
              href=""
              class="social-icon d-flex justify-content-center align-items-center"
            >
              <svg
                width="20"
                height="20"
                viewBox="0 0 20 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <g clip-path="url(#clip0_603_309)">
                  <path
                    d="M19.9863 12.1092C19.9798 11.181 19.8872 10.258 19.6173 9.36114C19.2797 8.2379 18.6675 7.33447 17.5757 6.81916C16.7321 6.42126 15.8326 6.30972 14.9134 6.33712C13.3046 6.38539 12.0028 7.00637 11.1326 8.4101C11.1228 8.42575 11.0967 8.43163 11.042 8.46294C11.042 7.84652 11.042 7.2575 11.042 6.66783C9.70369 6.66783 8.398 6.66783 7.09557 6.66783C7.09557 11.123 7.09557 15.5605 7.09557 20C8.47427 20 9.83081 20 11.2225 20C11.2225 19.878 11.2225 19.7815 11.2225 19.6843C11.2225 17.6009 11.2167 15.5168 11.2271 13.4334C11.2291 12.9709 11.2591 12.5052 11.3249 12.0479C11.5048 10.7942 12.1423 10.1165 13.3001 9.97951C14.5719 9.82949 15.4597 10.2933 15.7113 11.6585C15.8006 12.1438 15.8397 12.6441 15.843 13.1379C15.8573 15.3192 15.8508 17.5004 15.8515 19.6817C15.8515 19.7756 15.8515 19.8689 15.8515 19.9583C17.253 19.9583 18.6154 19.9583 19.9902 19.9583C19.9941 19.9035 20 19.8643 20 19.8245C19.9967 17.2532 20.0032 14.6812 19.9863 12.1092Z"
                    fill="#49ADFE"
                  />
                  <path
                    d="M0.343781 19.9909C1.72509 19.9909 3.09336 19.9909 4.4662 19.9909C4.4662 15.5416 4.4662 11.1106 4.4662 6.66456C3.09011 6.66456 1.7277 6.66456 0.343781 6.66456C0.343781 11.1191 0.343781 15.5507 0.343781 19.9909Z"
                    fill="#49ADFE"
                  />
                  <path
                    d="M2.38454 9.52735e-05C1.07363 0.0118365 -0.000651573 1.09464 2.96507e-07 2.40314C0.000652166 3.73381 1.09905 4.83488 2.41778 4.82705C3.72934 4.81922 4.80493 3.72011 4.7971 2.394C4.78993 1.06333 3.70653 -0.011646 2.38454 9.52735e-05Z"
                    fill="#49ADFE"
                  />
                </g>
                <defs>
                  <clipPath id="clip0_603_309">
                    <rect width="20" height="20" fill="white" />
                  </clipPath>
                </defs>
              </svg>
            </a>

            <a
              href=""
              class="social-icon d-flex justify-content-center align-items-center"
            >
              <svg
                width="20"
                height="20"
                viewBox="0 0 20 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <g clip-path="url(#clip0_603_319)">
                  <path
                    d="M19.9977 4.60899C19.9977 8.20239 19.9977 11.7952 19.9977 15.3886C19.9189 15.7622 19.8724 16.1468 19.7556 16.5081C19.0745 18.6096 17.1845 19.9884 14.9669 19.9945C11.6541 20.0037 8.34136 19.9994 5.02861 19.9957C3.96472 19.9945 2.98398 19.7004 2.12246 19.0706C0.699046 18.03 0.000788423 16.6145 0.000788423 14.853C0.000176989 11.6313 -0.00165731 8.40967 0.00384559 5.18802C0.00445703 4.85784 0.0197429 4.52156 0.079052 4.1975C0.414729 2.34974 1.46456 1.06084 3.19859 0.355243C3.6431 0.174259 4.13775 0.11495 4.60917 0C8.20256 0 11.7954 0 15.3887 0C15.5288 0.0250688 15.6694 0.0483033 15.8088 0.074595C17.6443 0.421278 18.9296 1.46072 19.6364 3.1819C19.8216 3.63131 19.881 4.13207 19.9977 4.60899ZM18.3194 9.99878C18.3218 9.99878 18.3242 9.99878 18.3267 9.99878C18.3267 8.37176 18.3236 6.74473 18.3285 5.11709C18.3297 4.59554 18.26 4.08927 18.0271 3.6203C17.3961 2.34913 16.367 1.67716 14.9442 1.67227C11.6443 1.66066 8.34442 1.66799 5.04451 1.67044C4.85007 1.67044 4.65441 1.68878 4.46242 1.7163C2.9479 1.92969 1.69385 3.2993 1.68407 4.83278C1.66144 8.23663 1.67489 11.6405 1.67306 15.0443C1.67306 15.5066 1.76355 15.9529 1.96716 16.3663C2.60672 17.6619 3.65533 18.3235 5.10259 18.3253C8.36337 18.3302 11.6242 18.3277 14.8849 18.3247C15.105 18.3247 15.327 18.3076 15.5453 18.2776C17.0305 18.074 18.2937 16.6891 18.3139 15.1917C18.3377 13.4613 18.3194 11.7304 18.3194 9.99878Z"
                    fill="#49ADFE"
                  />
                  <path
                    d="M14.9974 10.0232C14.9711 12.7918 12.7033 15.0327 9.9641 14.9966C7.19858 14.9606 4.97418 12.7099 5.00047 9.9731C5.02677 7.20331 7.29274 4.96485 10.0332 4.9997C12.7993 5.03577 15.0237 7.28646 14.9974 10.0232ZM10.002 6.67014C8.16281 6.66708 6.67825 8.14675 6.67091 9.99084C6.66296 11.8276 8.14141 13.3152 9.98672 13.3274C11.829 13.339 13.3294 11.8435 13.3276 9.99695C13.3258 8.15531 11.8436 6.67319 10.002 6.67014Z"
                    fill="#49ADFE"
                  />
                  <path
                    d="M15.4248 5.82573C14.729 5.83063 14.1714 5.27728 14.1714 4.58208C14.172 3.89788 14.7192 3.34453 15.4059 3.33353C16.084 3.32252 16.666 3.89972 16.6654 4.58269C16.6654 5.26321 16.1084 5.82084 15.4248 5.82573Z"
                    fill="#49ADFE"
                  />
                </g>
                <defs>
                  <clipPath id="clip0_603_319">
                    <rect width="20" height="20" fill="white" />
                  </clipPath>
                </defs>
              </svg>
            </a>
            <a
              href=""
              class="social-icon d-flex justify-content-center align-items-center"
            >
              <svg
                width="19"
                height="20"
                viewBox="0 0 19 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <g clip-path="url(#clip0_603_322)">
                  <path
                    d="M5.61595 14.8971C3.83255 14.6534 2.64934 13.769 1.98057 12C2.55502 12 3.06089 12 3.55818 12C1.74907 11.2509 0.728761 9.94224 0.600151 7.86643C1.14889 8.02888 1.65475 8.18231 2.16062 8.32672C2.18634 8.29061 2.21206 8.25451 2.23779 8.21841C1.48327 7.57762 0.943112 6.78339 0.754483 5.77256C0.565855 4.76173 0.651595 3.78701 1.17461 2.7852C3.33526 5.37545 5.97605 6.88267 9.2256 7.09928C9.2256 6.72022 9.21703 6.39531 9.2256 6.0704C9.27705 4.34657 10.083 3.09206 11.5492 2.39711C12.981 1.72022 14.3872 1.90072 15.6218 2.96571C15.9648 3.26354 16.2734 3.32672 16.6593 3.16426C17.2509 2.92058 17.8425 2.6769 18.4855 2.42419C18.2112 3.32672 17.6453 3.94044 17.0537 4.6083C17.671 4.43682 18.2883 4.25632 18.9057 4.08484C18.9314 4.11192 18.9657 4.13899 18.9914 4.16607C18.5027 4.69856 18.0397 5.27617 17.5081 5.75451C17.2166 6.01625 17.1051 6.27798 17.0965 6.66607C17.0451 9.38267 16.2734 11.8466 14.6787 13.9946C12.5352 16.8917 9.6886 18.3538 6.18183 18.426C4.17551 18.4711 2.2978 18.0289 0.531559 17.0271C0.360079 16.9278 0.188599 16.8195 0.00854492 16.6661C2.04058 16.7653 3.89257 16.2599 5.61595 14.8971Z"
                    fill="#49ADFE"
                  />
                </g>
                <defs>
                  <clipPath id="clip0_603_322">
                    <rect
                      width="19"
                      height="16.426"
                      fill="white"
                      transform="translate(0 2)"
                    />
                  </clipPath>
                </defs>
              </svg>
            </a>
          </div>
        </div>
        <div class="desc px-30 pb-60">
          <p class="text-gray-200 fs-14 mb-0">
            Lorem Ipsum is simply dummy text of the printing and typesetting
            industry. Lorem Ipsum has been the industry's standard dummy text
            ever since the 1500s, when an unknown printer took a galley of type
            and scrambled it to make a type specimen book.
          </p>
        </div>
        <div class="contact-section position-relative px-40">
          <div class="contact-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/earth.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-start mb-40 overflow-hidden">
            <h2 class="mb-0 d-inline-block">Contact</h2>
          </div>

          <div class="position-relative">
            <div class="row">
              <div class="col-sm-6">
                <div class="contact-box d-flex align-items-center">
                  <div
                    class="contact-icon d-flex justify-content-center align-items-center"
                  >
                    <svg
                      width="26"
                      height="20"
                      viewBox="0 0 26 20"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_603_396)">
                        <path
                          d="M13.025 -0.000469008C16.3358 -0.000469008 19.6399 -0.0071379 22.9507 0.00619988C23.3837 0.00619988 23.8233 0.0528821 24.243 0.146247C24.9958 0.319638 25.5154 0.799798 25.8418 1.49336C26.1282 2.10023 26.035 2.43368 25.4754 2.78713C24.7493 3.24728 24.0165 3.70076 23.2904 4.16092C20.1195 6.18159 16.9486 8.18893 13.7911 10.2229C13.2182 10.5964 12.7652 10.5831 12.1923 10.2163C8.34859 7.74211 4.48489 5.3013 0.627859 2.84715C0.54792 2.7938 0.46132 2.74711 0.388043 2.69376C0.00833517 2.43368 -0.0649418 2.22694 0.068289 1.79346C0.394705 0.72644 1.20741 0.106233 2.39983 0.0395443C2.87946 0.0128688 3.35909 0.0128688 3.83206 0.00619988C6.89637 0.00619988 9.96068 0.00619988 13.025 -0.000469008C13.025 0.00619988 13.025 -0.000469008 13.025 -0.000469008Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M12.9702 20C9.60609 20 6.24868 20.0067 2.8846 19.9934C2.46492 19.9934 2.03192 19.9467 1.62557 19.8333C0.806196 19.5999 0.299919 19.0197 0.0534418 18.2128C-0.0731275 17.7926 0.000149465 17.5859 0.379857 17.3458C3.48414 15.3918 6.58842 13.4378 9.69269 11.4838C10.0191 11.2771 10.3655 11.2771 10.6919 11.4705C11.2781 11.8173 11.851 12.1774 12.4239 12.5442C12.8969 12.851 13.0967 12.8576 13.5564 12.5575C14.1626 12.1641 14.7755 11.7839 15.3817 11.3905C15.7081 11.1771 16.0012 11.2438 16.3009 11.4372C17.2935 12.0774 18.2861 12.7109 19.2853 13.3445C21.3237 14.6382 23.3688 15.9187 25.4073 17.2124C26.0335 17.6059 26.1334 17.9327 25.827 18.5929C25.4073 19.4865 24.6479 19.8666 23.7219 19.98C23.4887 20.0067 23.2556 20.0067 23.0224 20.0067C19.6717 20 16.3209 20 12.9702 20Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M0.0471191 15.3651C0.0471191 11.7773 0.0471191 8.24942 0.0471191 4.66156C2.85829 6.45549 5.62949 8.21608 8.44733 10.01C5.63616 11.8039 2.86495 13.5712 0.0471191 15.3651Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M17.5732 10.01C20.3778 8.22275 23.149 6.45549 25.9601 4.66156C25.9601 8.23608 25.9601 11.7573 25.9601 15.3518C23.1556 13.5712 20.3844 11.8039 17.5732 10.01Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_603_396">
                          <rect width="26" height="20" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="contact-desc">
                    <p class="text-black mb-0 fw-5 fs-14">E-mail address</p>
                    <a
                      href="mailto:jackie@gmail.com"
                      class="fs-14 text-gray-200"
                      >jackie@gmail.com</a
                    >
                  </div>
                </div>
              </div>
              <div class="col-sm-6 mt-sm-0 mt-40">
                <div class="contact-box d-flex align-items-center">
                  <div
                    class="contact-icon d-flex justify-content-center align-items-center"
                  >
                    <svg
                      width="26"
                      height="26"
                      viewBox="0 0 26 26"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <path
                        d="M5.24875 11.2533C7.38447 15.3496 10.4178 18.4566 14.4261 20.5898C14.5964 20.6825 14.9988 20.5743 15.169 20.4197C16.0821 19.5541 16.9797 18.673 17.8464 17.761C18.3261 17.2509 18.8523 17.1736 19.5178 17.2973C21.0964 17.5755 22.6904 17.8537 24.2845 18.0392C25.5535 18.1938 26.0023 18.6112 26.0023 19.9096C26.0023 21.3008 26.0023 22.6766 26.0023 24.0678C26.0023 25.5672 25.5226 26.0309 23.9904 26C13.0952 25.8145 3.34518 18.0856 0.776133 7.48157C0.327324 5.61118 0.188038 3.64804 0.0177999 1.71581C-0.0905334 0.571938 0.54399 0.0154578 1.68923 0.0154578C3.2059 0 4.72256 0 6.23923 0C7.35351 0 7.8178 0.510107 7.95709 1.62307C8.17375 3.26159 8.4678 4.90012 8.77732 6.52319C8.90113 7.21879 8.77732 7.77527 8.26661 8.26992C7.24518 9.25922 6.2547 10.2485 5.24875 11.2533Z"
                        fill="#49ADFE"
                      />
                    </svg>
                  </div>
                  <div class="contact-desc">
                    <p class="text-black mb-0 fw-5 fs-14">Mobile Number</p>
                    <a href="tel:+1 4078461474" class="fs-14 text-gray-200"
                      >+1 4078461474</a
                    >
                  </div>
                </div>
              </div>
              <div class="col-sm-6 mt-40">
                <div class="contact-box d-flex align-items-center">
                  <div
                    class="contact-icon d-flex justify-content-center align-items-center"
                  >
                    <svg
                      width="30"
                      height="26"
                      viewBox="0 0 30 26"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_603_378)">
                        <path
                          d="M0.390531 26C0.264533 25.7615 0.0629374 25.5355 0.0251381 25.2844C-0.0378606 24.8324 0.0251381 24.3679 -6.1387e-05 23.916C-0.0126611 23.5017 0.163735 23.2883 0.592127 23.3008C0.718124 23.3008 0.844122 23.3008 0.970119 23.3008C10.3317 23.3008 19.6807 23.3008 29.0424 23.3134C29.3574 23.3134 29.6723 23.4389 29.9873 23.5017C29.9873 24.3303 29.9873 25.1714 29.9873 26C20.1343 26 10.2561 26 0.390531 26Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M15.0315 10.6461C18.3957 10.6461 21.7598 10.6461 25.1365 10.6461C27.0391 10.6461 27.9715 11.5877 27.9841 13.4959C27.9841 13.521 27.9841 13.5336 27.9841 13.5587C28.2109 14.6635 27.6943 15.2912 26.7115 15.718C25.7161 16.1449 24.7585 16.2328 23.8892 15.492C23.4608 15.128 23.108 14.6886 22.7552 14.2492C22.289 13.6842 21.848 13.6717 21.3692 14.2241C21.0542 14.5881 20.7392 14.9522 20.3864 15.2661C19.391 16.1574 18.2949 16.2579 17.1735 15.5423C16.6695 15.2159 16.2159 14.8016 15.7749 14.3873C15.1701 13.8223 14.9055 13.8223 14.3133 14.4124C13.9731 14.7513 13.6204 15.0778 13.2298 15.354C11.9068 16.3081 10.7098 16.2453 9.47504 15.1907C9.28604 15.0275 9.10965 14.8518 8.94585 14.6635C8.10167 13.6968 7.92527 13.6968 7.08109 14.7011C5.93451 16.057 4.48554 16.3583 2.87277 15.6301C2.24278 15.3414 2.00339 14.902 2.06639 14.2492C2.10419 13.9353 2.14199 13.6215 2.10419 13.3201C1.88999 11.776 3.13737 10.621 4.75013 10.6335C8.16467 10.6712 11.5918 10.6461 15.0315 10.6461Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M27.7321 21.606C19.2525 21.606 10.8107 21.606 2.33105 21.606C2.33105 20.2878 2.33105 18.9696 2.33105 17.6012C4.43521 18.3042 6.27478 17.8522 7.78675 16.2327C10.3067 18.6432 12.625 18.3168 15.0568 16.1574C18.0681 18.7687 20.2353 18.1661 22.2891 16.1198C22.982 16.8605 23.738 17.5384 24.7712 17.802C25.7918 18.0657 26.7494 17.8522 27.7573 17.4254C27.7321 18.8315 27.7321 20.1874 27.7321 21.606Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M13.2297 9.46596C13.2297 8.22308 13.2171 7.00531 13.2423 5.77499C13.2549 5.37325 13.5447 5.13472 13.9605 5.13472C14.6535 5.12217 15.3465 5.12217 16.0269 5.13472C16.5056 5.13472 16.7828 5.41092 16.7828 5.87542C16.808 7.05553 16.7954 8.24819 16.7954 9.46596C15.5985 9.46596 14.4393 9.46596 13.2297 9.46596Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M15.0188 0C15.3212 0.55239 15.674 1.18011 16.0142 1.82038C16.1654 2.10913 16.367 2.39788 16.4552 2.71173C16.6442 3.40222 16.3418 4.15548 15.8 4.45678C15.2582 4.75809 14.4266 4.67021 13.9856 4.26847C13.5194 3.82907 13.3682 2.98793 13.6958 2.37277C14.1242 1.54418 14.5904 0.740705 15.0188 0Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_603_378">
                          <rect width="30" height="26" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="contact-desc">
                    <p class="text-black mb-0 fw-5 fs-14">Date of Birth</p>
                    <p class="mb-0 text-gray-200 fs-14">12th June, 1990</p>
                  </div>
                </div>
              </div>
              <div class="col-sm-6 mt-40">
                <div class="contact-box d-flex align-items-center">
                  <div
                    class="contact-icon d-flex justify-content-center align-items-center"
                  >
                    <svg
                      width="20"
                      height="26"
                      viewBox="0 0 20 26"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_603_370)">
                        <path
                          d="M9.99348 21.3251C9.65861 20.9328 9.33688 20.5605 9.02171 20.1849C7.32112 18.1393 5.71245 16.0232 4.32046 13.7461C3.69341 12.7233 3.14515 11.6602 2.67568 10.5502C1.81225 8.50119 1.95999 6.48571 2.91206 4.53395C4.14318 2.01209 6.16222 0.509702 8.89368 0.0905097C13.0959 -0.55337 17.088 2.45811 17.7742 6.71375C17.9974 8.10882 17.784 9.41671 17.2489 10.6978C16.6514 12.1264 15.8799 13.4544 15.0394 14.7388C13.5391 17.0259 11.8615 19.1688 10.0756 21.2279C10.0559 21.2514 10.0329 21.2782 9.99348 21.3251ZM13.9429 7.37105C13.9462 5.151 12.1734 3.34344 9.99676 3.34344C7.81685 3.34344 6.04732 5.14765 6.04732 7.36769C6.04732 9.58774 7.81685 11.3953 9.99348 11.3953C12.1701 11.3953 13.9396 9.59444 13.9429 7.37105Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M6.92352 18.592C6.54269 18.649 6.16515 18.7027 5.79088 18.7698C4.66153 18.9676 3.55517 19.246 2.51117 19.7457C2.10408 19.9435 1.71669 20.1716 1.39824 20.5036C0.886091 21.0401 0.886091 21.5901 1.41137 22.1166C1.85786 22.566 2.41268 22.8276 2.98721 23.0556C4.10014 23.4916 5.26232 23.7297 6.44092 23.8906C8.066 24.1153 9.70093 24.169 11.3391 24.0885C13.1743 23.9979 14.9898 23.7632 16.7397 23.1529C17.2584 22.9718 17.764 22.7571 18.2105 22.4218C18.4107 22.2709 18.6044 22.0965 18.7587 21.8986C19.0575 21.5163 19.0673 21.0904 18.7587 20.7182C18.5486 20.4633 18.2892 20.2319 18.0135 20.0508C17.242 19.5444 16.3753 19.256 15.4888 19.0481C14.7535 18.8771 14.0082 18.7664 13.2663 18.6289C13.2006 18.6155 13.1382 18.6054 13.0726 18.5954C13.194 18.3338 13.217 18.3271 13.4829 18.3472C14.5795 18.4344 15.6727 18.5551 16.7462 18.8C17.3306 18.9307 17.9084 19.0884 18.437 19.3734C18.7686 19.5511 19.0969 19.7591 19.3693 20.0139C20.0686 20.6712 20.1934 21.5834 19.7469 22.4419C19.5072 22.9047 19.156 23.2702 18.7554 23.5888C17.8822 24.283 16.8874 24.7424 15.8434 25.0945C13.6471 25.8357 11.3851 26.0805 9.08045 25.9799C7.31091 25.8994 5.58077 25.6076 3.90645 24.9973C2.87559 24.6217 1.89397 24.1522 1.05352 23.4144C0.685829 23.0925 0.373944 22.7169 0.176964 22.2575C-0.154618 21.4828 -0.00360029 20.6645 0.57749 20.0642C1.06337 19.5612 1.67729 19.2829 2.31748 19.0649C3.19404 18.7664 4.10014 18.6122 5.01281 18.4981C5.5184 18.4344 6.02398 18.3975 6.53284 18.3439C6.77907 18.3204 6.79876 18.3338 6.92352 18.592Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_603_370">
                          <rect width="20" height="26" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="contact-desc">
                    <p class="text-black mb-0 fw-5 fs-14">Location</p>
                    <p class="text-gray-200 fs-14 mb-0">New York, USA</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="our-services-section px-40 pt-60">
          <div class="amount-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/amount.png')); ?>" loading="lazy"/>
          </div>
          <div class="bag-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/bag.png')); ?>" loading="lazy"/>
          </div>
          <div class="dollar-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/dollar.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-end mb-40 overflow-hidden">
            <h2 class="mb-0 d-inline-block">Our Services</h2>
          </div>
          <div class="services">
            <div class="row">
              <div class="col-12 mb-3">
                <div
                  class="service-card card d-flex flex-row align-items-center"
                >
                  <div class="card-img me-4">
                    <svg
                      width="39"
                      height="30"
                      viewBox="0 0 39 30"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_605_484)">
                        <path
                          d="M0 27.8139C0 19.2737 0 10.726 0 2.18581C0.175195 1.63556 0.365625 1.06269 0.853125 0.715958C1.26445 0.421988 1.75195 0.233546 2.20898 -0.00012207C13.7338 -0.00012207 25.2662 -0.00012207 36.791 -0.00012207C37.248 0.233546 37.7355 0.421988 38.1469 0.715958C38.642 1.06269 38.8248 1.63556 39 2.18581C39 10.726 39 19.2737 39 27.8139C38.8248 28.3642 38.6344 28.9371 38.1469 29.2838C37.7355 29.5778 37.248 29.7662 36.791 29.9999C25.2662 29.9999 13.7338 29.9999 2.20898 29.9999C1.75195 29.7662 1.26445 29.5778 0.853125 29.2838C0.365625 28.9371 0.175195 28.3642 0 27.8139ZM1.67578 6.33907C1.67578 6.48983 1.67578 6.62551 1.67578 6.76118C1.67578 13.628 1.67578 20.5024 1.67578 27.3692C1.67578 28.1381 1.88906 28.3567 2.66602 28.3567C13.9242 28.3567 25.1824 28.3567 36.4406 28.3567C37.2023 28.3567 37.4232 28.1456 37.4232 27.4069C37.4232 20.525 37.4232 13.6431 37.4232 6.76118C37.4232 6.62551 37.408 6.49736 37.408 6.34661C25.4871 6.33907 13.6043 6.33907 1.67578 6.33907ZM25.0301 1.9446C24.2988 1.93706 23.7123 2.50239 23.7047 3.21847C23.6971 3.91948 24.2988 4.52249 25.0072 4.52249C25.7156 4.52249 26.2869 3.9647 26.3021 3.25616C26.3174 2.53254 25.7613 1.95214 25.0301 1.9446ZM29.41 1.9446C28.7016 1.95214 28.1227 2.51747 28.1227 3.21093C28.115 3.91948 28.7092 4.51495 29.4252 4.51495C30.1488 4.51495 30.7277 3.93455 30.7201 3.21847C30.7201 2.49485 30.1488 1.93706 29.41 1.9446ZM35.1457 3.24862C35.1533 2.525 34.5896 1.95214 33.8584 1.95214C33.1348 1.95214 32.5406 2.525 32.5406 3.23355C32.5406 3.92701 33.1195 4.50742 33.8203 4.52249C34.5439 4.53757 35.1305 3.9647 35.1457 3.24862Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M4.02197 21.3315C4.02197 17.0426 4.02197 12.7687 4.02197 8.47223C14.2519 8.47223 24.4513 8.47223 34.6812 8.47223C34.6812 12.7536 34.6812 17.0275 34.6812 21.3315C24.4665 21.3315 14.2595 21.3315 4.02197 21.3315ZM12.119 12.1657C11.4564 12.1657 10.8546 12.1657 10.2147 12.1657C10.2147 12.324 10.2147 12.4597 10.2147 12.5953C10.2147 13.8014 10.2224 15.0074 10.2071 16.2134C10.1995 16.937 9.78057 17.3139 9.07979 17.2762C8.50088 17.2461 8.14287 16.8692 8.13526 16.221C8.12002 15.0074 8.12764 13.7863 8.12764 12.5652C8.12764 12.4295 8.12764 12.3014 8.12764 12.1657C7.46494 12.1657 6.86318 12.1657 6.25381 12.1657C6.25381 13.628 6.17764 15.0752 6.27666 16.5074C6.36807 17.8265 7.12217 18.5803 8.30283 18.7386C8.81319 18.8064 9.33877 18.8139 9.85674 18.7762C11.0069 18.6783 11.8144 17.9697 12.02 16.8466C12.1038 16.3943 12.1038 15.927 12.1114 15.4597C12.1267 14.3667 12.119 13.2813 12.119 12.1657ZM19.1192 12.1582C19.1192 13.4396 19.104 14.6757 19.1269 15.9195C19.1345 16.319 19.1802 16.726 19.2868 17.1029C19.5382 17.9622 20.0942 18.5652 21.0159 18.7009C21.5872 18.7838 22.1814 18.8139 22.7526 18.7762C23.8952 18.6933 24.6646 17.9923 24.9083 16.8767C24.9769 16.5752 24.9997 16.2587 24.9997 15.9421C25.0073 14.9622 25.0073 13.9823 25.0073 13.0024C25.0073 12.731 25.0073 12.4597 25.0073 12.1657C24.3675 12.1657 23.7657 12.1657 23.1107 12.1657C23.1107 12.324 23.1107 12.4747 23.1107 12.618C23.1107 13.8089 23.1183 14.9999 23.103 16.1984C23.0954 16.9295 22.7069 17.2913 22.0366 17.2838C21.412 17.2687 21.0312 16.8843 21.0312 16.2059C21.0235 14.9923 21.0312 13.7712 21.0235 12.5501C21.0235 12.422 21.0159 12.2863 21.0083 12.1582C20.3608 12.1582 19.7667 12.1582 19.1192 12.1582ZM29.0292 14.1632C28.6788 13.5225 28.3741 12.9496 28.0618 12.3843C28.0085 12.2863 27.8943 12.1582 27.8105 12.1582C27.1859 12.1355 26.5536 12.1506 25.8681 12.1506C25.9671 12.324 26.028 12.437 26.0966 12.5577C26.5993 13.3868 27.1021 14.2084 27.62 15.03C27.7419 15.226 27.7419 15.3692 27.62 15.5727C27.0335 16.4923 26.4622 17.427 25.8833 18.3617C25.8224 18.4672 25.7691 18.5727 25.6853 18.7159C26.3251 18.7159 26.9116 18.7084 27.4905 18.7235C27.7114 18.731 27.8333 18.6556 27.94 18.4672C28.2751 17.8642 28.6255 17.2687 28.9987 16.6205C29.3644 17.2612 29.7071 17.8566 30.0575 18.4521C30.1185 18.5501 30.2175 18.7009 30.3013 18.7009C30.964 18.7235 31.6267 18.7159 32.3427 18.7159C31.6876 17.6531 31.0859 16.6506 30.4536 15.6707C30.2937 15.4144 30.3089 15.2486 30.4612 15.0074C30.9792 14.1783 31.4819 13.334 31.9847 12.4898C32.038 12.3994 32.0837 12.3014 32.1446 12.1657C31.5429 12.1657 30.9868 12.1732 30.4308 12.1582C30.1946 12.1506 30.0651 12.2185 29.9585 12.4295C29.6691 12.9722 29.3644 13.53 29.0292 14.1632ZM15.3487 18.6782C15.3487 16.4923 15.3487 14.3365 15.3487 12.1657C14.7165 12.1657 14.0995 12.1657 13.4825 12.1657C13.4825 14.3441 13.4825 16.4999 13.4825 18.6782C14.1071 18.6782 14.7089 18.6782 15.3487 18.6782ZM16.1028 18.7838C16.9331 18.8893 16.9331 18.8893 17.1007 18.1883C17.3673 17.0275 17.6339 15.8667 17.9005 14.7059C18.0985 13.8315 18.2966 12.9571 18.5023 12.0602C18.3575 12.0526 18.2585 12.0602 18.1595 12.0376C17.7558 11.9622 17.6034 12.128 17.5196 12.535C17.2302 13.9446 16.8874 15.3466 16.5675 16.7486C16.4151 17.4195 16.2628 18.0903 16.1028 18.7838Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M27.5361 24.0752C29.5775 24.0752 31.6266 24.0677 33.668 24.0752C34.4906 24.0752 34.9934 24.731 34.7953 25.4848C34.6582 25.9898 34.2545 26.2762 33.6451 26.2762C31.5656 26.2762 29.4785 26.2762 27.399 26.2762C25.3805 26.2762 23.3619 26.2838 21.3434 26.2762C20.5055 26.2762 19.9951 25.5451 20.2694 24.7762C20.4369 24.3089 20.8102 24.0752 21.4043 24.0752C23.4533 24.0752 25.4947 24.0752 27.5361 24.0752Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M10.5499 26.2914C8.66087 26.2914 6.76419 26.2989 4.87512 26.2914C4.02962 26.2914 3.50403 25.5226 3.82395 24.7537C3.99915 24.3316 4.31907 24.0979 4.79134 24.0904C5.19505 24.0828 5.60638 24.0904 6.01009 24.0904C9.41497 24.0904 12.8122 24.0904 16.2171 24.0904C17.1083 24.0904 17.6263 24.7612 17.3749 25.5602C17.215 26.0427 16.8493 26.2989 16.2704 26.2989C14.3585 26.2914 12.4542 26.2914 10.5499 26.2914Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_605_484">
                          <rect width="39" height="30" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="card-body p-0">
                    <h3 class="card-title fs-6 fw-5">Web Design</h3>
                    <p class="mb-0 fs-14 text-gray-200">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum is dummy text.
                    </p>
                  </div>
                </div>
              </div>
              <div class="col-12 mb-3">
                <div
                  class="service-card card d-flex flex-row align-items-center"
                >
                  <div class="card-img me-4">
                    <svg
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_605_527)">
                        <path
                          d="M40 6.17717C39.6879 6.85397 39.1518 7.06718 38.4249 7.04762C37.0328 7.01046 35.6397 7.03882 34.2466 7.03589C33.3534 7.03393 32.8975 6.5811 32.8916 5.69597C32.8897 5.37419 32.8916 5.05242 32.8916 4.71206C31.3097 4.71206 29.7669 4.71206 28.1459 4.71206C28.3014 4.82747 28.4071 4.90962 28.5166 4.98591C32.1687 7.53371 34.3278 11.0195 34.9872 15.4128C35.1055 16.2001 35.266 16.7527 36.0643 17.186C37.2901 17.8511 37.8106 19.4404 37.4858 20.7911C37.1531 22.176 35.9752 23.2782 34.6408 23.4562C33.0912 23.6616 31.7147 23.0034 31.0133 21.7202C30.0203 19.904 30.6855 17.7963 32.5561 16.8574C32.7488 16.7606 32.8094 16.6647 32.785 16.4407C32.3819 12.7672 30.7667 9.7568 27.8729 7.4496C26.5336 6.38158 25.0202 5.65098 23.3708 5.19325C23.1663 5.13653 23.0743 5.19423 22.9648 5.36246C21.5169 7.59239 18.4831 7.59728 17.047 5.37126C16.9257 5.18347 16.8239 5.13751 16.6087 5.20401C11.6144 6.74247 8.56507 10.0717 7.42241 15.1595C7.33142 15.5644 7.31284 15.985 7.22968 16.3918C7.17881 16.6403 7.24533 16.7576 7.47328 16.873C8.73529 17.5088 9.42598 18.5543 9.44065 19.9578C9.45533 21.3554 8.80867 22.4283 7.56622 23.1042C5.82092 24.0548 3.65886 23.3135 2.75197 21.464C1.93118 19.7886 2.71676 17.6222 4.46107 16.8623C4.80446 16.7126 4.88175 16.5102 4.91305 16.1972C5.29068 12.3662 6.86086 9.10738 9.64903 6.45395C10.3055 5.82898 11.0509 5.29595 11.7543 4.72282C10.2419 4.72282 8.69812 4.72282 7.11424 4.72282C7.11424 5.08567 7.12011 5.44755 7.11326 5.80844C7.09859 6.54882 6.62509 7.03295 5.88549 7.03687C4.33585 7.04567 2.78719 7.04567 1.23756 7.03687C0.495022 7.03002 0.0107609 6.54589 0.00684771 5.80649C-0.00195705 4.28367 -0.00195705 2.75988 0.00684771 1.23707C0.0107609 0.497671 0.495022 0.01354 1.23462 0.00962781C2.78426 0.000825421 4.33292 0.000825421 5.88255 0.00962781C6.62215 0.01354 7.09565 0.497671 7.11131 1.23805C7.11815 1.58819 7.11228 1.93931 7.11228 2.35008C7.2649 2.35008 7.40088 2.35008 7.53785 2.35008C10.4542 2.35008 13.3705 2.34617 16.2868 2.35693C16.5813 2.35791 16.7339 2.28553 16.8738 2.00288C17.5048 0.721643 18.5653 0.0282106 19.9868 0.0223424C21.4259 0.0164741 22.4932 0.714797 23.1369 2.00777C23.2651 2.26499 23.3942 2.35889 23.6867 2.35791C26.6158 2.34519 29.5448 2.35008 32.4739 2.35008C32.6001 2.35008 32.7273 2.35008 32.8916 2.35008C32.8916 1.96571 32.8877 1.61753 32.8926 1.26935C32.9043 0.483979 33.3769 0.0115839 34.1683 0.00864976C35.6651 0.00278151 37.1629 0.0213643 38.6597 -0.000152622C39.322 -0.00993305 39.7222 0.316733 40 0.865415C40 2.63665 40 4.40691 40 6.17717Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M12.8931 39.9998C12.8021 39.9529 12.7111 39.9069 12.6211 39.859C12.0752 39.5666 11.8639 39.0179 12.0742 38.4399C12.7698 36.5278 14.4711 35.2681 16.4913 35.2436C18.8314 35.2153 21.1735 35.2153 23.5136 35.2436C25.5338 35.2681 27.235 36.5278 27.9306 38.4399C28.1742 39.1088 27.9277 39.5793 27.1108 39.9998C22.3709 39.9998 17.632 39.9998 12.8931 39.9998Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M21.2556 10.4004C22.6331 12.467 24.0115 14.5336 25.389 16.6002C26.9983 19.013 28.6076 21.4258 30.215 23.8406C30.6914 24.5566 30.666 25.0338 30.0721 25.6569C28.0725 27.7557 26.7987 30.2273 26.2254 33.0655C26.2049 33.1653 26.1687 33.2631 26.1296 33.3951C25.9212 33.3277 25.7314 33.2367 25.5318 33.2054C24.803 33.091 24.0712 32.9208 23.3384 32.9071C21.1783 32.868 19.0173 32.9002 16.8572 32.8895C15.9111 32.8846 14.9896 32.9971 14.0993 33.3257C14.0289 33.3511 13.9516 33.357 13.9115 33.3648C13.6287 32.4425 13.3861 31.5251 13.0662 30.6361C12.4244 28.8521 11.4305 27.2755 10.1401 25.8867C10.0697 25.8104 9.99727 25.7351 9.92781 25.6578C9.34963 25.0192 9.31148 24.5556 9.78889 23.8387C11.721 20.9378 13.6552 18.0379 15.5893 15.138C16.6419 13.5585 17.6956 11.9789 18.7932 10.3319C18.8108 10.4923 18.8284 10.5833 18.8284 10.6732C18.8294 14.1355 18.8275 17.5968 18.8353 21.0591C18.8363 21.2987 18.7727 21.42 18.5447 21.5256C17.0528 22.2112 16.3015 23.6695 16.5578 25.339C16.7691 26.721 18.0438 27.9602 19.4409 28.143C21.1089 28.3612 22.5607 27.5699 23.224 26.0823C23.9773 24.3903 23.2201 22.3433 21.5276 21.5618C21.2429 21.4307 21.1666 21.2791 21.1676 20.9799C21.1783 17.5831 21.1744 14.1864 21.1744 10.7896C21.1744 10.6644 21.1744 10.5393 21.1744 10.4141C21.2008 10.4092 21.2282 10.4053 21.2556 10.4004Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M21.1704 24.6974C21.1665 25.3351 20.6324 25.8633 19.9945 25.8594C19.3567 25.8555 18.8284 25.3205 18.8323 24.6837C18.8362 24.0461 19.3704 23.5179 20.0082 23.5218C20.6461 23.5257 21.1743 24.0597 21.1704 24.6974Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_605_527">
                          <rect width="40" height="40" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="card-body p-0">
                    <h3 class="card-title fs-6 fw-5">Web Design</h3>
                    <p class="mb-0 fs-14 text-gray-200">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum is dummy text.
                    </p>
                  </div>
                </div>
              </div>
              <div class="col-12 mb-3">
                <div
                  class="service-card card d-flex flex-row align-items-center"
                >
                  <div class="card-img me-4">
                    <svg
                      width="39"
                      height="30"
                      viewBox="0 0 39 30"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_605_484)">
                        <path
                          d="M0 27.8139C0 19.2737 0 10.726 0 2.18581C0.175195 1.63556 0.365625 1.06269 0.853125 0.715958C1.26445 0.421988 1.75195 0.233546 2.20898 -0.00012207C13.7338 -0.00012207 25.2662 -0.00012207 36.791 -0.00012207C37.248 0.233546 37.7355 0.421988 38.1469 0.715958C38.642 1.06269 38.8248 1.63556 39 2.18581C39 10.726 39 19.2737 39 27.8139C38.8248 28.3642 38.6344 28.9371 38.1469 29.2838C37.7355 29.5778 37.248 29.7662 36.791 29.9999C25.2662 29.9999 13.7338 29.9999 2.20898 29.9999C1.75195 29.7662 1.26445 29.5778 0.853125 29.2838C0.365625 28.9371 0.175195 28.3642 0 27.8139ZM1.67578 6.33907C1.67578 6.48983 1.67578 6.62551 1.67578 6.76118C1.67578 13.628 1.67578 20.5024 1.67578 27.3692C1.67578 28.1381 1.88906 28.3567 2.66602 28.3567C13.9242 28.3567 25.1824 28.3567 36.4406 28.3567C37.2023 28.3567 37.4232 28.1456 37.4232 27.4069C37.4232 20.525 37.4232 13.6431 37.4232 6.76118C37.4232 6.62551 37.408 6.49736 37.408 6.34661C25.4871 6.33907 13.6043 6.33907 1.67578 6.33907ZM25.0301 1.9446C24.2988 1.93706 23.7123 2.50239 23.7047 3.21847C23.6971 3.91948 24.2988 4.52249 25.0072 4.52249C25.7156 4.52249 26.2869 3.9647 26.3021 3.25616C26.3174 2.53254 25.7613 1.95214 25.0301 1.9446ZM29.41 1.9446C28.7016 1.95214 28.1227 2.51747 28.1227 3.21093C28.115 3.91948 28.7092 4.51495 29.4252 4.51495C30.1488 4.51495 30.7277 3.93455 30.7201 3.21847C30.7201 2.49485 30.1488 1.93706 29.41 1.9446ZM35.1457 3.24862C35.1533 2.525 34.5896 1.95214 33.8584 1.95214C33.1348 1.95214 32.5406 2.525 32.5406 3.23355C32.5406 3.92701 33.1195 4.50742 33.8203 4.52249C34.5439 4.53757 35.1305 3.9647 35.1457 3.24862Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M4.02197 21.3315C4.02197 17.0426 4.02197 12.7687 4.02197 8.47223C14.2519 8.47223 24.4513 8.47223 34.6812 8.47223C34.6812 12.7536 34.6812 17.0275 34.6812 21.3315C24.4665 21.3315 14.2595 21.3315 4.02197 21.3315ZM12.119 12.1657C11.4564 12.1657 10.8546 12.1657 10.2147 12.1657C10.2147 12.324 10.2147 12.4597 10.2147 12.5953C10.2147 13.8014 10.2224 15.0074 10.2071 16.2134C10.1995 16.937 9.78057 17.3139 9.07979 17.2762C8.50088 17.2461 8.14287 16.8692 8.13526 16.221C8.12002 15.0074 8.12764 13.7863 8.12764 12.5652C8.12764 12.4295 8.12764 12.3014 8.12764 12.1657C7.46494 12.1657 6.86318 12.1657 6.25381 12.1657C6.25381 13.628 6.17764 15.0752 6.27666 16.5074C6.36807 17.8265 7.12217 18.5803 8.30283 18.7386C8.81319 18.8064 9.33877 18.8139 9.85674 18.7762C11.0069 18.6783 11.8144 17.9697 12.02 16.8466C12.1038 16.3943 12.1038 15.927 12.1114 15.4597C12.1267 14.3667 12.119 13.2813 12.119 12.1657ZM19.1192 12.1582C19.1192 13.4396 19.104 14.6757 19.1269 15.9195C19.1345 16.319 19.1802 16.726 19.2868 17.1029C19.5382 17.9622 20.0942 18.5652 21.0159 18.7009C21.5872 18.7838 22.1814 18.8139 22.7526 18.7762C23.8952 18.6933 24.6646 17.9923 24.9083 16.8767C24.9769 16.5752 24.9997 16.2587 24.9997 15.9421C25.0073 14.9622 25.0073 13.9823 25.0073 13.0024C25.0073 12.731 25.0073 12.4597 25.0073 12.1657C24.3675 12.1657 23.7657 12.1657 23.1107 12.1657C23.1107 12.324 23.1107 12.4747 23.1107 12.618C23.1107 13.8089 23.1183 14.9999 23.103 16.1984C23.0954 16.9295 22.7069 17.2913 22.0366 17.2838C21.412 17.2687 21.0312 16.8843 21.0312 16.2059C21.0235 14.9923 21.0312 13.7712 21.0235 12.5501C21.0235 12.422 21.0159 12.2863 21.0083 12.1582C20.3608 12.1582 19.7667 12.1582 19.1192 12.1582ZM29.0292 14.1632C28.6788 13.5225 28.3741 12.9496 28.0618 12.3843C28.0085 12.2863 27.8943 12.1582 27.8105 12.1582C27.1859 12.1355 26.5536 12.1506 25.8681 12.1506C25.9671 12.324 26.028 12.437 26.0966 12.5577C26.5993 13.3868 27.1021 14.2084 27.62 15.03C27.7419 15.226 27.7419 15.3692 27.62 15.5727C27.0335 16.4923 26.4622 17.427 25.8833 18.3617C25.8224 18.4672 25.7691 18.5727 25.6853 18.7159C26.3251 18.7159 26.9116 18.7084 27.4905 18.7235C27.7114 18.731 27.8333 18.6556 27.94 18.4672C28.2751 17.8642 28.6255 17.2687 28.9987 16.6205C29.3644 17.2612 29.7071 17.8566 30.0575 18.4521C30.1185 18.5501 30.2175 18.7009 30.3013 18.7009C30.964 18.7235 31.6267 18.7159 32.3427 18.7159C31.6876 17.6531 31.0859 16.6506 30.4536 15.6707C30.2937 15.4144 30.3089 15.2486 30.4612 15.0074C30.9792 14.1783 31.4819 13.334 31.9847 12.4898C32.038 12.3994 32.0837 12.3014 32.1446 12.1657C31.5429 12.1657 30.9868 12.1732 30.4308 12.1582C30.1946 12.1506 30.0651 12.2185 29.9585 12.4295C29.6691 12.9722 29.3644 13.53 29.0292 14.1632ZM15.3487 18.6782C15.3487 16.4923 15.3487 14.3365 15.3487 12.1657C14.7165 12.1657 14.0995 12.1657 13.4825 12.1657C13.4825 14.3441 13.4825 16.4999 13.4825 18.6782C14.1071 18.6782 14.7089 18.6782 15.3487 18.6782ZM16.1028 18.7838C16.9331 18.8893 16.9331 18.8893 17.1007 18.1883C17.3673 17.0275 17.6339 15.8667 17.9005 14.7059C18.0985 13.8315 18.2966 12.9571 18.5023 12.0602C18.3575 12.0526 18.2585 12.0602 18.1595 12.0376C17.7558 11.9622 17.6034 12.128 17.5196 12.535C17.2302 13.9446 16.8874 15.3466 16.5675 16.7486C16.4151 17.4195 16.2628 18.0903 16.1028 18.7838Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M27.5361 24.0752C29.5775 24.0752 31.6266 24.0677 33.668 24.0752C34.4906 24.0752 34.9934 24.731 34.7953 25.4848C34.6582 25.9898 34.2545 26.2762 33.6451 26.2762C31.5656 26.2762 29.4785 26.2762 27.399 26.2762C25.3805 26.2762 23.3619 26.2838 21.3434 26.2762C20.5055 26.2762 19.9951 25.5451 20.2694 24.7762C20.4369 24.3089 20.8102 24.0752 21.4043 24.0752C23.4533 24.0752 25.4947 24.0752 27.5361 24.0752Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M10.5499 26.2914C8.66087 26.2914 6.76419 26.2989 4.87512 26.2914C4.02962 26.2914 3.50403 25.5226 3.82395 24.7537C3.99915 24.3316 4.31907 24.0979 4.79134 24.0904C5.19505 24.0828 5.60638 24.0904 6.01009 24.0904C9.41497 24.0904 12.8122 24.0904 16.2171 24.0904C17.1083 24.0904 17.6263 24.7612 17.3749 25.5602C17.215 26.0427 16.8493 26.2989 16.2704 26.2989C14.3585 26.2914 12.4542 26.2914 10.5499 26.2914Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_605_484">
                          <rect width="39" height="30" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="card-body p-0">
                    <h3 class="card-title fs-6 fw-5">Web Design</h3>
                    <p class="mb-0 fs-14 text-gray-200">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum is dummy text.
                    </p>
                  </div>
                </div>
              </div>
              <div class="col-12">
                <div
                  class="service-card card d-flex flex-row align-items-center"
                >
                  <div class="card-img me-4">
                    <svg
                      width="39"
                      height="30"
                      viewBox="0 0 39 30"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clip-path="url(#clip0_605_484)">
                        <path
                          d="M0 27.8139C0 19.2737 0 10.726 0 2.18581C0.175195 1.63556 0.365625 1.06269 0.853125 0.715958C1.26445 0.421988 1.75195 0.233546 2.20898 -0.00012207C13.7338 -0.00012207 25.2662 -0.00012207 36.791 -0.00012207C37.248 0.233546 37.7355 0.421988 38.1469 0.715958C38.642 1.06269 38.8248 1.63556 39 2.18581C39 10.726 39 19.2737 39 27.8139C38.8248 28.3642 38.6344 28.9371 38.1469 29.2838C37.7355 29.5778 37.248 29.7662 36.791 29.9999C25.2662 29.9999 13.7338 29.9999 2.20898 29.9999C1.75195 29.7662 1.26445 29.5778 0.853125 29.2838C0.365625 28.9371 0.175195 28.3642 0 27.8139ZM1.67578 6.33907C1.67578 6.48983 1.67578 6.62551 1.67578 6.76118C1.67578 13.628 1.67578 20.5024 1.67578 27.3692C1.67578 28.1381 1.88906 28.3567 2.66602 28.3567C13.9242 28.3567 25.1824 28.3567 36.4406 28.3567C37.2023 28.3567 37.4232 28.1456 37.4232 27.4069C37.4232 20.525 37.4232 13.6431 37.4232 6.76118C37.4232 6.62551 37.408 6.49736 37.408 6.34661C25.4871 6.33907 13.6043 6.33907 1.67578 6.33907ZM25.0301 1.9446C24.2988 1.93706 23.7123 2.50239 23.7047 3.21847C23.6971 3.91948 24.2988 4.52249 25.0072 4.52249C25.7156 4.52249 26.2869 3.9647 26.3021 3.25616C26.3174 2.53254 25.7613 1.95214 25.0301 1.9446ZM29.41 1.9446C28.7016 1.95214 28.1227 2.51747 28.1227 3.21093C28.115 3.91948 28.7092 4.51495 29.4252 4.51495C30.1488 4.51495 30.7277 3.93455 30.7201 3.21847C30.7201 2.49485 30.1488 1.93706 29.41 1.9446ZM35.1457 3.24862C35.1533 2.525 34.5896 1.95214 33.8584 1.95214C33.1348 1.95214 32.5406 2.525 32.5406 3.23355C32.5406 3.92701 33.1195 4.50742 33.8203 4.52249C34.5439 4.53757 35.1305 3.9647 35.1457 3.24862Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M4.02197 21.3315C4.02197 17.0426 4.02197 12.7687 4.02197 8.47223C14.2519 8.47223 24.4513 8.47223 34.6812 8.47223C34.6812 12.7536 34.6812 17.0275 34.6812 21.3315C24.4665 21.3315 14.2595 21.3315 4.02197 21.3315ZM12.119 12.1657C11.4564 12.1657 10.8546 12.1657 10.2147 12.1657C10.2147 12.324 10.2147 12.4597 10.2147 12.5953C10.2147 13.8014 10.2224 15.0074 10.2071 16.2134C10.1995 16.937 9.78057 17.3139 9.07979 17.2762C8.50088 17.2461 8.14287 16.8692 8.13526 16.221C8.12002 15.0074 8.12764 13.7863 8.12764 12.5652C8.12764 12.4295 8.12764 12.3014 8.12764 12.1657C7.46494 12.1657 6.86318 12.1657 6.25381 12.1657C6.25381 13.628 6.17764 15.0752 6.27666 16.5074C6.36807 17.8265 7.12217 18.5803 8.30283 18.7386C8.81319 18.8064 9.33877 18.8139 9.85674 18.7762C11.0069 18.6783 11.8144 17.9697 12.02 16.8466C12.1038 16.3943 12.1038 15.927 12.1114 15.4597C12.1267 14.3667 12.119 13.2813 12.119 12.1657ZM19.1192 12.1582C19.1192 13.4396 19.104 14.6757 19.1269 15.9195C19.1345 16.319 19.1802 16.726 19.2868 17.1029C19.5382 17.9622 20.0942 18.5652 21.0159 18.7009C21.5872 18.7838 22.1814 18.8139 22.7526 18.7762C23.8952 18.6933 24.6646 17.9923 24.9083 16.8767C24.9769 16.5752 24.9997 16.2587 24.9997 15.9421C25.0073 14.9622 25.0073 13.9823 25.0073 13.0024C25.0073 12.731 25.0073 12.4597 25.0073 12.1657C24.3675 12.1657 23.7657 12.1657 23.1107 12.1657C23.1107 12.324 23.1107 12.4747 23.1107 12.618C23.1107 13.8089 23.1183 14.9999 23.103 16.1984C23.0954 16.9295 22.7069 17.2913 22.0366 17.2838C21.412 17.2687 21.0312 16.8843 21.0312 16.2059C21.0235 14.9923 21.0312 13.7712 21.0235 12.5501C21.0235 12.422 21.0159 12.2863 21.0083 12.1582C20.3608 12.1582 19.7667 12.1582 19.1192 12.1582ZM29.0292 14.1632C28.6788 13.5225 28.3741 12.9496 28.0618 12.3843C28.0085 12.2863 27.8943 12.1582 27.8105 12.1582C27.1859 12.1355 26.5536 12.1506 25.8681 12.1506C25.9671 12.324 26.028 12.437 26.0966 12.5577C26.5993 13.3868 27.1021 14.2084 27.62 15.03C27.7419 15.226 27.7419 15.3692 27.62 15.5727C27.0335 16.4923 26.4622 17.427 25.8833 18.3617C25.8224 18.4672 25.7691 18.5727 25.6853 18.7159C26.3251 18.7159 26.9116 18.7084 27.4905 18.7235C27.7114 18.731 27.8333 18.6556 27.94 18.4672C28.2751 17.8642 28.6255 17.2687 28.9987 16.6205C29.3644 17.2612 29.7071 17.8566 30.0575 18.4521C30.1185 18.5501 30.2175 18.7009 30.3013 18.7009C30.964 18.7235 31.6267 18.7159 32.3427 18.7159C31.6876 17.6531 31.0859 16.6506 30.4536 15.6707C30.2937 15.4144 30.3089 15.2486 30.4612 15.0074C30.9792 14.1783 31.4819 13.334 31.9847 12.4898C32.038 12.3994 32.0837 12.3014 32.1446 12.1657C31.5429 12.1657 30.9868 12.1732 30.4308 12.1582C30.1946 12.1506 30.0651 12.2185 29.9585 12.4295C29.6691 12.9722 29.3644 13.53 29.0292 14.1632ZM15.3487 18.6782C15.3487 16.4923 15.3487 14.3365 15.3487 12.1657C14.7165 12.1657 14.0995 12.1657 13.4825 12.1657C13.4825 14.3441 13.4825 16.4999 13.4825 18.6782C14.1071 18.6782 14.7089 18.6782 15.3487 18.6782ZM16.1028 18.7838C16.9331 18.8893 16.9331 18.8893 17.1007 18.1883C17.3673 17.0275 17.6339 15.8667 17.9005 14.7059C18.0985 13.8315 18.2966 12.9571 18.5023 12.0602C18.3575 12.0526 18.2585 12.0602 18.1595 12.0376C17.7558 11.9622 17.6034 12.128 17.5196 12.535C17.2302 13.9446 16.8874 15.3466 16.5675 16.7486C16.4151 17.4195 16.2628 18.0903 16.1028 18.7838Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M27.5361 24.0752C29.5775 24.0752 31.6266 24.0677 33.668 24.0752C34.4906 24.0752 34.9934 24.731 34.7953 25.4848C34.6582 25.9898 34.2545 26.2762 33.6451 26.2762C31.5656 26.2762 29.4785 26.2762 27.399 26.2762C25.3805 26.2762 23.3619 26.2838 21.3434 26.2762C20.5055 26.2762 19.9951 25.5451 20.2694 24.7762C20.4369 24.3089 20.8102 24.0752 21.4043 24.0752C23.4533 24.0752 25.4947 24.0752 27.5361 24.0752Z"
                          fill="#49ADFE"
                        />
                        <path
                          d="M10.5499 26.2914C8.66087 26.2914 6.76419 26.2989 4.87512 26.2914C4.02962 26.2914 3.50403 25.5226 3.82395 24.7537C3.99915 24.3316 4.31907 24.0979 4.79134 24.0904C5.19505 24.0828 5.60638 24.0904 6.01009 24.0904C9.41497 24.0904 12.8122 24.0904 16.2171 24.0904C17.1083 24.0904 17.6263 24.7612 17.3749 25.5602C17.215 26.0427 16.8493 26.2989 16.2704 26.2989C14.3585 26.2914 12.4542 26.2914 10.5499 26.2914Z"
                          fill="#49ADFE"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_605_484">
                          <rect width="39" height="30" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div class="card-body p-0">
                    <h3 class="card-title fs-6 fw-5">Web Design</h3>
                    <p class="mb-0 fs-14 text-gray-200">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum is dummy text.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="appointment-section pt-60 px-40">
          <div class="appointment-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/appointment-bg.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-start overflow-hidden mb-40">
            <h2 class="mb-0 d-inline-block">Make an Appointment</h2>
          </div>
          <div class="appointment">
            <div class="row mb-3 pb-2">
              <div class="col-sm-2">
                <label
                  for="date"
                  class="appoint-date fs-18 fw-5 mt-sm-2 mb-sm-0 mb-2"
                  >Date:</label
                >
              </div>
              <div class="col-sm-10">
                <div class="position-relative">
                  <input
                    type="text"
                    class="form-control appointment-input"
                    placeholder="Pick a Date"
                  />
                  <span class="calendar-icon">
                    <svg
                      width="20"
                      height="20"
                      viewBox="0 0 20 20"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <path
                        d="M6.25 9.375V10.625C6.25 10.9705 5.97047 11.25 5.625 11.25H4.375C4.02953 11.25 3.75 10.9705 3.75 10.625V9.375C3.75 9.02953 4.02953 8.75 4.375 8.75H5.625C5.97047 8.75 6.25 9.02953 6.25 9.375ZM5.625 13.75H4.375C4.02953 13.75 3.75 14.0295 3.75 14.375V15.625C3.75 15.9705 4.02953 16.25 4.375 16.25H5.625C5.97047 16.25 6.25 15.9705 6.25 15.625V14.375C6.25 14.0295 5.97047 13.75 5.625 13.75ZM10.625 8.75H9.375C9.02953 8.75 8.75 9.02953 8.75 9.375V10.625C8.75 10.9705 9.02953 11.25 9.375 11.25H10.625C10.9705 11.25 11.25 10.9705 11.25 10.625V9.375C11.25 9.02953 10.9705 8.75 10.625 8.75ZM10.625 13.75H9.375C9.02953 13.75 8.75 14.0295 8.75 14.375V15.625C8.75 15.9705 9.02953 16.25 9.375 16.25H10.625C10.9705 16.25 11.25 15.9705 11.25 15.625V14.375C11.25 14.0295 10.9705 13.75 10.625 13.75ZM15.625 8.75H14.375C14.0295 8.75 13.75 9.02953 13.75 9.375V10.625C13.75 10.9705 14.0295 11.25 14.375 11.25H15.625C15.9705 11.25 16.25 10.9705 16.25 10.625V9.375C16.25 9.02953 15.9705 8.75 15.625 8.75ZM15.625 13.75H14.375C14.0295 13.75 13.75 14.0295 13.75 14.375V15.625C13.75 15.9705 14.0295 16.25 14.375 16.25H15.625C15.9705 16.25 16.25 15.9705 16.25 15.625V14.375C16.25 14.0295 15.9705 13.75 15.625 13.75ZM4.375 3.75H5.625C5.97047 3.75 6.25 3.47047 6.25 3.125V0.625C6.25 0.279531 5.97047 0 5.625 0H4.375C4.02953 0 3.75 0.279531 3.75 0.625V3.125C3.75 3.47047 4.02953 3.75 4.375 3.75ZM20 5V17.5C20 18.8806 18.8806 20 17.5 20H2.5C1.11937 20 0 18.8806 0 17.5V5C0 3.61937 1.11937 2.5 2.5 2.5H3.125V3.125C3.125 3.81348 3.6859 4.375 4.375 4.375H5.625C6.3141 4.375 6.875 3.81348 6.875 3.125V2.5H13.125V3.125C13.125 3.81348 13.6865 4.375 14.375 4.375H15.625C16.3135 4.375 16.875 3.81348 16.875 3.125V2.5H17.5C18.8806 2.5 20 3.61937 20 5ZM18.75 7.5C18.75 6.81152 18.1897 6.25 17.5 6.25H2.5C1.8109 6.25 1.25 6.81152 1.25 7.5V17.5C1.25 18.1897 1.8109 18.75 2.5 18.75H17.5C18.1897 18.75 18.75 18.1897 18.75 17.5V7.5ZM14.375 3.75H15.625C15.9705 3.75 16.25 3.47047 16.25 3.125V0.625C16.25 0.279531 15.9705 0 15.625 0H14.375C14.0295 0 13.75 0.279531 13.75 0.625V3.125C13.75 3.47047 14.0295 3.75 14.375 3.75Z"
                        fill="#49ADFE"
                      />
                    </svg>
                  </span>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-sm-2">
                <label class="fs-18 fw-5 mt-sm-2 mb-sm-0 mb-2">Hour:</label>
              </div>
              <div class="col-sm-10">
                <div class="row">
                  <div class="col-sm-6 mb-2 pe-sm-1">
                    <div
                      class="hour-input d-flex justify-content-center align-items-center"
                    >
                      <span class="text-gray-100">8:10 - 20:00</span>
                    </div>
                  </div>
                  <div class="col-sm-6 mb-2 ps-sm-1">
                    <div
                      class="hour-input d-flex justify-content-center align-items-center"
                    >
                      <span class="text-gray-100">8:10 - 20:00</span>
                    </div>
                  </div>
                  <div class="col-sm-6 mb-2 pe-sm-1">
                    <div
                      class="hour-input d-flex justify-content-center align-items-center"
                    >
                      <span class="text-gray-100">8:10 - 20:00</span>
                    </div>
                  </div>
                  <div class="col-sm-6 mb-2 ps-sm-1">
                    <div
                      class="hour-input d-flex justify-content-center align-items-center"
                    >
                      <span class="text-gray-100">8:10 - 20:00</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row justify-content-center">
              <div class="col-sm-10 mt-3">
                <button type="submit" class="btn btn-primary w-100">
                  Make an Appointment
                </button>
              </div>
            </div>
          </div>
        </div>
        <div class="gallery-section pt-60 px-40">
          <div class="bag-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/bag.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-end overflow-hidden">
            <h2 class="mb-0 d-inline-block">Gallery</h2>
          </div>
          <div class="gallery-slider pt-3 mt-3">
            <div>
              <div class="gallery-img">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/gallery-img1.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
            </div>
            <div>
              <div class="gallery-img">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/gallery-img2.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
            </div>
            <div>
              <div class="gallery-img">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/gallery-img3.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
            </div>
            <div>
              <div class="gallery-img">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/gallery-img1.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
            </div>
            <div>
              <div class="gallery-img">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/gallery-img2.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
            </div>
          </div>
        </div>
        <div class="product-section bg-gray pt-60 px-40">
          <div class="product-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/product-bg.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-start overflow-hidden mb-40 mx-3">
            <h2 class="mb-0 d-inline-block">Products</h2>
          </div>
          <div class="product-slider pb-0">
            <div class="">
              <div class="product-card card mb-3">
                <div class="product-img card-img">
                  <img
                    src="<?php echo e(asset('assets//img/vcard18/product-img1.png')); ?>"
                    class="w-100 h-100 object-fit-cover"
                    loading="lazy"
                  />
                </div>
                <div class="product-desc card-body">
                  <div class="d-flex justify-content-between">
                    <h3 class="product-title text-black fs-6 fw-5">Lorem 1</h3>
                    <div class="product-amount text-primary fw-5 fs-6">$25</div>
                  </div>
                  <p class="fs-14 text-gray-200 mb-0">Lorem is dummy text</p>
                </div>
              </div>
            </div>
            <div class="">
              <div class="product-card card mb-3">
                <div class="product-img card-img">
                  <img
                    src="<?php echo e(asset('assets//img/vcard18/product-img2.png')); ?>"
                    class="w-100 h-100 object-fit-cover"
                    loading="lazy"
                  />
                </div>
                <div class="product-desc card-body">
                  <div class="d-flex justify-content-between">
                    <h3 class="product-title text-black fs-6 fw-5">Lorem 2</h3>
                    <div class="product-amount text-primary fw-5 fs-6">
                      $155
                    </div>
                  </div>
                  <p class="fs-14 text-gray-200 mb-0">Lorem is dummy text</p>
                </div>
              </div>
            </div>
            <div class="">
              <div class="product-card card mb-3">
                <div class="product-img card-img">
                  <img
                    src="<?php echo e(asset('assets//img/vcard18/product-img1.png')); ?>"
                    class="w-100 h-100 object-fit-cover"
                    loading="lazy"
                  />
                </div>
                <div class="product-desc card-body">
                  <div class="d-flex justify-content-between">
                    <h3 class="product-title text-black fs-6 fw-5">Lorem 1</h3>
                    <div class="product-amount text-primary fw-5 fs-6">$25</div>
                  </div>
                  <p class="fs-14 text-gray-200 mb-0">Lorem is dummy text</p>
                </div>
              </div>
            </div>
            <div class="">
              <div class="product-card card mb-3">
                <div class="product-img card-img">
                  <img
                    src="<?php echo e(asset('assets//img/vcard18/product-img2.png')); ?>"
                    class="w-100 h-100 object-fit-cover"
                    loading="lazy"
                  />
                </div>
                <div class="product-desc card-body">
                  <div class="d-flex justify-content-between">
                    <h3 class="product-title text-black fs-6 fw-5">Lorem 2</h3>
                    <div class="product-amount text-primary fw-5 fs-6">
                      $155
                    </div>
                  </div>
                  <p class="fs-14 text-gray-200 mb-0">Lorem is dummy text</p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="blog-section pt-60 px-sm-4 px-1">
          <div class="blog-bg">
            <img src="<?php echo e(asset('assets//img/vcard18/blog-bg.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-end overflow-hidden px-3 mb-40">
            <h2 class="mb-0 d-inline-block">Blog</h2>
          </div>
          <div class="blog-slider mb-0">
            <div class="px-3">
              <div class="blog-card d-flex flex-sm-row flex-column">
                <div class="card-img">
                  <img
                    src="<?php echo e(asset('assets//img/vcard18/blog-img.png')); ?>"
                    class="img-fluid h-100 object-fit-cover mx-auto"
                    loading="lazy"
                  />
                </div>
                <div
                  class="card-body text-sm-start text-center bg-white pt-sm-3 pt-4"
                >
                  <h2 class="fs-6 fw-5 text-black mb-1">Coding</h2>
                  <p class="text-gray-200 blog-desc fw-normal mb-0 fs-14">
                    Lorem Ipsum is simply dummy text of the printing and type
                    setting industry. Lorem Ipsum has been the industry's
                    standard.
                  </p>
                </div>
              </div>
            </div>
            <div class="px-3">
              <div class="blog-card d-flex flex-sm-row flex-column">
                <div class="card-img">
                  <img
                    src="<?php echo e(asset('assets//img/vcard18/blog-img.png')); ?>"
                    class="img-fluid h-100 object-fit-cover mx-auto"
                    loading="lazy"
                  />
                </div>
                <div
                  class="card-body text-sm-start text-center bg-white pt-sm-3 pt-4"
                >
                  <h2 class="fs-6 fw-5 text-black mb-1">Coding</h2>
                  <p class="text-gray-200 blog-desc mb-0 fw-normal fs-14">
                    Lorem Ipsum is simply dummy text of the printing and type
                    setting industry. Lorem Ipsum has been the industry's
                    standard.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="testimonial-section pt-60 px-sm-4 px-1">
          <div class="section-heading text-start mb-40 overflow-hidden px-3">
            <h2 class="mb-0 d-inline-block">Testimonial</h2>
          </div>
          <div class="testimonial-slider">
            <div class="px-3">
              <div class="testimonial-card">
                <div class="card-img mb-3">
                  <img src="<?php echo e(asset('assets//img/vcard18/testimonial.png')); ?>" loading="lazy"/>
                </div>
                <div class="card-body text-center p-0">
                  <h3 class="fs-20 fw-6 text-black mb-0">Jane Doe</h3>
                  <p class="text-black fw-4 fs-6 mb-2">CEO</p>
                  <div class="d-flex">
                    <div class="quote-img quote-left-img">
                      <img src="<?php echo e(asset('assets//img/vcard18/quote-left-img.png')); ?>" loading="lazy"/>
                    </div>
                    <p class="card-desc fs-6 fw-4 text-gray-200 mb-0">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum has been the industry's
                      standard dummy text.
                    </p>
                    <div class="quote-img quote-right-img align-self-end">
                      <img src="<?php echo e(asset('assets//img/vcard18/quote-right-img.png')); ?>" loading="lazy"/>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="px-3">
              <div class="testimonial-card">
                <div class="card-img mb-3">
                  <img src="<?php echo e(asset('assets//img/vcard18/testimonial.png')); ?>" loading="lazy"/>
                </div>
                <div class="card-body text-center p-0">
                  <h3 class="fs-20 fw-6 text-black mb-0">Jane Doe</h3>
                  <p class="text-black fw-4 fs-6 mb-2">CEO</p>
                  <div class="d-flex">
                    <div class="quote-img quote-left-img">
                      <img src="<?php echo e(asset('assets//img/vcard18/quote-left-img.png')); ?>" loading="lazy"/>
                    </div>
                    <p class="card-desc fs-6 fw-4 text-gray-200 mb-0">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum has been the industry's
                      standard dummy text.
                    </p>
                    <div class="quote-img quote-right-img align-self-end">
                      <img src="<?php echo e(asset('assets//img/vcard18/quote-right-img.png')); ?>" loading="lazy"/>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="px-3">
              <div class="testimonial-card">
                <div class="card-img mb-3">
                  <img src="<?php echo e(asset('assets//img/vcard18/testimonial.png')); ?>" loading="lazy"/>
                </div>
                <div class="card-body text-center p-0">
                  <h3 class="fs-20 fw-6 text-black mb-0">Jane Doe</h3>
                  <p class="text-black fw-4 fs-6 mb-2">CEO</p>
                  <div class="d-flex">
                    <div class="quote-img quote-left-img">
                      <img src="<?php echo e(asset('assets//img/vcard18/quote-left-img.png')); ?>" loading="lazy"/>
                    </div>
                    <p class="card-desc fs-6 fw-4 text-gray-200 mb-0">
                      Lorem Ipsum is simply dummy text of the printing and
                      typesetting industry. Lorem Ipsum has been the industry's
                      standard dummy text.
                    </p>
                    <div class="quote-img quote-right-img align-self-end">
                      <img src="<?php echo e(asset('assets//img/vcard18/quote-right-img.png')); ?>" loading="lazy"/>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="qr-code-section pt-60 px-40">
          <div class="section-heading text-end mb-40">
            <h2 class="inline-block mb-0">QR Code</h2>
          </div>
          <div class="d-inline-block w-100 mx-auto mt-40">
            <div class="qr-code mx-auto position-relative">
              <div class="qr-profile-img">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/qr-profile-img.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
              <div class="qr-code-img mx-auto">
                <img
                  src="<?php echo e(asset('assets//img/vcard18/qr-code.png')); ?>"
                  class="w-100 h-100 object-fit-cover"
                  loading="lazy"
                />
              </div>
              <div class="text-center">
                <button class="btn btn-primary" type="button">
                  Download My QR Code
                </button>
              </div>
            </div>
          </div>
        </div>

        <div class="business-hour-section pt-60 px-40">
          <div class="time-bg-1">
            <img src="<?php echo e(asset('assets//img/vcard18/time.png')); ?>" loading="lazy"/>
          </div>
          <div class="time-bg-2">
            <img src="<?php echo e(asset('assets//img/vcard18/time.png')); ?>" loading="lazy"/>
          </div>
          <div class="section-heading text-start overflow-hidden mb-40">
            <h2 class="mb-0 d-inline-block">Business Hours</h2>
          </div>
          <div class="business-hours mt-3">
            <div class="mb-10 d-flex justify-content-between">
              <span>Sunday:</span>
              <span>08:10 - 20:00</span>
            </div>
            <div
              class="mb-10 d-flex justify-content-between align-items-center"
            >
              <span>Monday:</span>
              <span>08:10 - 20:00</span>
            </div>
            <div
              class="mb-10 d-flex justify-content-between align-items-center"
            >
              <span>Tuesday:</span>
              <span>08:10 - 20:00</span>
            </div>
            <div
              class="mb-10 d-flex justify-content-between align-items-center"
            >
              <span>Wednesday:</span>
              <span>08:10 - 20:00</span>
            </div>
            <div
              class="mb-10 d-flex justify-content-between align-items-center"
            >
              <span>Thursday:</span>
              <span>08:10 - 20:00</span>
            </div>
            <div
              class="mb-10 d-flex justify-content-between align-items-center"
            >
              <span>Friday:</span>
              <span>08:10 - 20:00</span>
            </div>
            <div class="d-flex justify-content-between align-items-center">
              <span>Saturday:</span>
              <span>Closed</span>
            </div>
          </div>
        </div>

        <div class="contact-us-section pt-60 px-40">
          <div class="section-heading text-end overflow-hidden mb-40">
            <h2 class="mb-0">Inquiries</h2>
          </div>
          <div class="contact-form">
            <form action="">
              <div class="row">
                <div class="col-sm-6 pe-sm-2">
                  <div class="mb-3">
                    <label class="fs-14 mb-1">Your Name</label>
                    <div class="input-group mb-3">
                      <span class="input-group-text">
                        <svg
                          width="17"
                          height="20"
                          viewBox="0 0 17 20"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <g clip-path="url(#clip0_614_765)">
                            <path
                              d="M13.8856 5.60086C13.8856 8.69099 11.4291 11.1803 8.43129 11.1588C5.43352 11.1373 3.03947 8.60515 3.0811 5.51502C3.10192 2.46781 5.51679 0 8.47292 0C11.4707 0 13.9064 2.51073 13.8856 5.60086ZM11.3874 5.55794C11.3666 3.90558 10.0551 2.57511 8.45211 2.57511C6.84913 2.59657 5.55843 3.9485 5.57924 5.60086C5.57924 7.25322 6.91159 8.58369 8.49374 8.58369C10.0967 8.56223 11.4082 7.18884 11.3874 5.55794Z"
                              fill="#49ADFE"
                            />
                            <path
                              d="M15.6758 20.0001C15.2386 19.6139 14.8014 19.3778 14.5516 19.013C11.304 14.3349 5.64156 14.3135 2.45643 18.9486C1.87353 19.7856 1.16572 20.0216 0.541186 19.5495C-0.187438 18.9916 -0.0833488 18.3049 0.333008 17.5753C3.89286 11.3521 13.1776 11.395 16.6126 17.6611C16.8416 18.0903 16.8416 18.7555 16.6958 19.2276C16.6334 19.5066 16.1129 19.6783 15.6758 20.0001Z"
                              fill="#49ADFE"
                            />
                          </g>
                          <defs>
                            <clipPath id="clip0_614_765">
                              <rect width="16.8" height="20" fill="white" />
                            </clipPath>
                          </defs>
                        </svg>
                      </span>
                      <input type="text" class="form-control"   placeholder="<?php echo e(__('messages.form.your_name')); ?>" />
                    </div>
                  </div>
                </div>
                <div class="col-sm-6 ps-sm-2">
                  <div class="mb-3">
                    <label class="fs-14 mb-1">Phone</label>
                    <div class="input-group mb-3">
                      <span class="input-group-text">
                        <svg
                          width="17"
                          height="17"
                          viewBox="0 0 17 17"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M4.45778 0C4.97911 0.226667 5.13022 0.627111 5.18311 1.18622C5.28134 2.18356 5.47022 3.16578 5.68178 4.148C5.78756 4.65422 5.74978 5.04711 5.36445 5.41733C4.78267 5.97644 4.23111 6.55822 3.64934 7.11733C3.48311 7.28356 3.43778 7.40444 3.55867 7.62356C4.93378 10.1396 6.88311 12.0813 9.39912 13.4564C9.58801 13.5547 9.69378 13.5547 9.85245 13.396C10.4342 12.7916 11.0462 12.2022 11.6356 11.5978C11.9756 11.2502 12.3533 11.1747 12.8067 11.3182C13.804 11.6356 14.8316 11.8244 15.8818 11.832C16.4636 11.8396 16.8338 12.0738 17.0151 12.6178C17.0151 13.8267 17.0151 15.0356 17.0151 16.2444C16.8791 16.6071 16.6373 16.8716 16.2596 17C15.9347 17 15.6022 17 15.2773 17C15.1565 16.9773 15.0356 16.9547 14.9071 16.9396C14.0156 16.8036 13.0938 16.7582 12.2325 16.5164C5.73467 14.688 1.74533 10.4796 0.294667 3.89111C0.143556 3.18844 0.0982223 2.45556 0 1.73778C0 1.41289 0 1.08044 0 0.755556C0.136 0.385333 0.385334 0.136 0.755556 0C1.98711 0 3.22622 0 4.45778 0Z"
                            fill="#49ADFE"
                          />
                        </svg>
                      </span>
                      <input type="tel" class="form-control" placeholder="<?php echo e(__('messages.form.phone')); ?>"  />
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="mb-3">
                    <label class="fs-14 mb-1">E-mail</label>
                    <div class="input-group mb-3">
                      <span class="input-group-text">
                        <svg
                          width="23"
                          height="17"
                          viewBox="0 0 23 17"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M11.5029 0.0084951C14.7635 0.0084951 18.0241 0.0204145 21.2848 -0.000444422C22.1021 -0.00640411 22.8763 0.595524 22.9885 1.48352C22.9971 1.55801 23 1.63251 23 1.70701C23 6.23636 23 10.7687 23 15.2981C23 16.2397 22.2661 16.9996 21.3539 16.9996C14.7865 16.9996 8.21634 16.9996 1.64902 17.0025C0.684935 17.0025 0 16.1503 0 15.304C0.00863363 10.7657 0.00287788 6.23041 0.00575576 1.69509C0.00575576 0.747496 0.719469 0.0084951 1.63751 0.0084951C4.92693 0.0084951 8.21346 0.0084951 11.5029 0.0084951ZM2.48649 1.71296C2.55268 1.77256 2.59585 1.81428 2.63901 1.85302C3.94269 2.95556 5.24925 4.0581 6.55293 5.16362C8.16454 6.52839 9.77615 7.89316 11.3849 9.2609C11.4655 9.32944 11.5201 9.33242 11.6036 9.2609C12.4871 8.507 13.3735 7.75906 14.2599 7.01112C15.2873 6.14101 16.3118 5.2709 17.3392 4.40376C18.3148 3.57835 19.2904 2.75591 20.2631 1.93049C20.338 1.86792 20.4272 1.81726 20.4876 1.71594C14.4872 1.71296 8.50125 1.71296 2.48649 1.71296ZM2.47785 15.2891C8.50988 15.2891 14.5045 15.2891 20.5221 15.2891C20.1164 14.9464 19.7336 14.6187 19.348 14.2939C18.5278 13.5996 17.7105 12.9082 16.8903 12.2139C15.955 11.4243 15.0196 10.6346 14.0901 9.84197C14.0095 9.77344 13.9606 9.77642 13.8858 9.84197C13.1231 10.5035 12.3576 11.162 11.595 11.8265C11.523 11.8891 11.4799 11.8861 11.4137 11.8236C11.3187 11.7312 11.2151 11.6507 11.1172 11.5673C10.4467 10.9922 9.77615 10.4171 9.10848 9.83601C9.03941 9.77642 8.99625 9.77344 8.92718 9.83005C7.95733 10.6555 6.98749 11.4779 6.01764 12.2974C5.08233 13.087 4.1499 13.8767 3.21459 14.6663C2.96997 14.866 2.73398 15.0686 2.47785 15.2891ZM21.351 13.5936C21.3539 13.5161 21.3567 13.4774 21.3567 13.4386C21.3567 10.1519 21.3567 6.86511 21.3567 3.57835C21.3567 3.53663 21.3769 3.47405 21.3395 3.45319C21.2905 3.42339 21.2531 3.48597 21.2215 3.51279C20.6171 4.03128 20.0156 4.55275 19.4113 5.07423C18.5681 5.80131 17.7248 6.52541 16.8816 7.25249C16.4356 7.63689 15.9952 8.02427 15.5463 8.40271C15.4427 8.48913 15.4715 8.53382 15.5549 8.59938C15.6614 8.68579 15.7621 8.77519 15.8657 8.86458C16.6485 9.54101 17.4313 10.2174 18.2141 10.8939C18.9854 11.5584 19.7595 12.2258 20.5337 12.8904C20.7984 13.1168 21.0632 13.3433 21.351 13.5936ZM1.65478 3.41445C1.65478 6.81743 1.65478 10.1847 1.65478 13.5698C1.70083 13.537 1.73248 13.5191 1.76126 13.4953C2.02315 13.2688 2.28216 13.0423 2.54404 12.8159C3.31532 12.1484 4.08946 11.4839 4.86074 10.8164C5.72985 10.0684 6.5961 9.3205 7.46809 8.57554C7.5458 8.50998 7.52565 8.46529 7.46234 8.41463C7.35586 8.32523 7.24937 8.23286 7.14002 8.14048C6.42055 7.5177 5.6982 6.89491 4.97873 6.2751C4.13263 5.54504 3.28654 4.81796 2.44044 4.0879C2.18719 3.87037 1.93393 3.65284 1.65478 3.41445Z"
                            fill="#49ADFE"
                          />
                        </svg>
                      </span>
                      <input type="tel" class="form-control" placeholder="<?php echo e(__('messages.form.your_email')); ?>" />
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="mb-3">
                    <label class="fs-14 mb-1">Your Message</label>
                    <div class="input-group h-100">
                      <textarea
                        class="form-control h-100 ps-3"
                        placeholder="<?php echo e(__('messages.form.type_message')); ?>"
                        rows="4"
                      ></textarea>
                    </div>
                  </div>
                </div>
                <div class="col-12 text-center mt-3">
                  <button class="send-btn btn btn-primary  rounded-2" type="submit">
                    Send Message
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
        <div class="create-vcard-section pt-60 pb-60 mb-40 px-30">
          <div class="section-heading text-start overflow-hidden mb-40">
            <h2 class="mb-0 d-inline-block">Create Your VCard</h2>
          </div>
          <div class="vcard-link-card card mb-5 mx-sm-4">
            <div class="d-flex justify-content-center align-items-center">
              <a
                href="https://vcards.infyom.com/marlonbrasil"
                class="text-black link-text"
                >https://vcards.infyom.com/marlonbrasil</a
              >
              <i
                class="icon fa-solid fa-arrow-up-right-from-square ms-3 text-primary"
              ></i>
            </div>
          </div>
        </div>
        <div class="add-to-contact-section mt-60 pb-60">
          <div class="text-center mt-40" style="margin-bottom:-180px">
            <button class="btn btn-primary rounded-2" style="width: 250px"><i
                class="fas fa-download fa-address-book"></i>
            &nbsp;Add to Contact</button>
          </div>
        </div>
        <div class="bg-img">
          <img src="<?php echo e(asset('assets//img/vcard18/bg-img.png')); ?>" />
        </div>
      </div>
    </div>
  </body>
  <script type="text/javascript" src="<?php echo e(asset('assets/js/front-third-party.js')); ?>"></script>
  <script type="text/javascript" src="<?php echo e(asset('front/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/js/slider/js/slick.min.js')); ?>" type="text/javascript"></script>

  <script>
    $().ready(function () {
      $(".gallery-slider").slick({
        slidesToShow: 3,
        slidesToScroll: 1,
        arrows: false,
        dots: false,
        speed: 300,
        infinite: true,
        autoplaySpeed: 5000,
        autoplay: true,
        responsive: [
          {
            breakpoint: 500,

            settings: {
              dots: true,
              slidesToShow: 2,
            },
          },
          {
            breakpoint: 375,

            settings: {
              dots: true,
              slidesToShow: 1,
            },
          },
        ],
      });
      $(".product-slider").slick({
        arrows: false,
        infinite: true,
        dots: false,
        slidesToShow: 2,
        slidesToScroll: 1,
        autoplay: true,
        responsive: [
          {
            breakpoint: 575,
            settings: {
              slidesToShow: 1,
            },
          },
        ],
      });
      $(".testimonial-slider").slick({
        arrows: false,
        infinite: true,
        dots: true,
        slidesToShow: 1,
        autoplay: true,
      });
      $(".blog-slider").slick({
        arrows: true,
        infinite: true,
        dots: false,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplay: true,
        prevArrow:
          '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-arrow-left"></i></button>',
        nextArrow:
          '<button class="slide-arrow next-arrow"><i class="fa-solid fa-arrow-right"></i></button>',
        responsive: [
          {
            breakpoint: 575,
            settings: {
              slidesToShow: 1,
              arrows: false,
              dots: true,
            },
          },
        ],
      });
    });
  </script>
  <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
  <script src="<?php echo e(asset('messages.js?$mixID')); ?>"></script>
  <script src="<?php echo e(mix('assets/js/custom/helpers.js')); ?>"></script>
  <script src="<?php echo e(mix('assets/js/custom/custom.js')); ?>"></script>
  <script src="<?php echo e(mix('assets/js/vcards/vcard-view.js')); ?>"></script>
  <script src="<?php echo e(mix('assets/js/lightbox.js')); ?>"></script>

</html>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/vcards/vcard18.blade.php ENDPATH**/ ?>