<?php $__env->startSection('title'); ?>
    <?php echo e(__('Virtual Backgrounds')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="col-12">
            <?php echo $__env->make('layouts.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="d-flex justify-content-between align-items-end mb-5">
            <h1><?php echo e(__('messages.common.add_virtual_background')); ?></h1>
            <a class="btn btn-outline-primary float-end"
                href="<?php echo e(route('virtual-backgrounds.index')); ?>"><?php echo e(__('messages.common.back')); ?></a>
        </div>
        <div class="card">
            <form data-turbo="false" name="e_card_form" action="<?php echo e(route('download.ecard')); ?>" method="post"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.vcard.vcard_name')); ?></label>
                            <select id="e-vcard-id" name="vcard_id">
                                <option value=""><?php echo e(__('messages.vcard.select_vcard')); ?></option>
                                <?php $__currentLoopData = $vcards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $vcard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($id); ?>" <?php if(old('vcard_id')): echo 'selected'; endif; ?>><?php echo e($vcard); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6 mt-4">
                            <div class="mb-3" io-image-input="true">
                                <label for="exampleInputImage"
                                    class="form-label required"><?php echo e(__('messages.e_card.add_ecard') . ':'); ?></label>
                                <span data-bs-toggle="tooltip" data-placement="top"
                                    data-bs-original-title="<?php echo e(__('messages.e_card.ecard_info')); ?>">
                                    <i class="fas fa-question-circle ml-1 mt-1 general-question-mark"></i>
                                </span>
                                <div class="d-block">
                                    <div class="image-picker">
                                        <div class="image previewImage" id="exampleInputImage"
                                            style="background-image: url('<?php echo e(getLogoUrl()); ?>')">
                                        </div>
                                        <span class="picker-edit rounded-circle text-gray-500 fs-small"
                                            data-bs-toggle="tooltip" data-placement="top"
                                            data-bs-original-title="<?php echo e(__('messages.tooltip.profile')); ?>">
                                            <label>
                                                <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                                <input type="file" id="e-card-logo" name="ecard-logo"
                                                    class="image-upload file-validation d-none" accept="image/*" />
                                            </label>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-text text-danger" id="logoImageValidationErrors"></div>
                        </div>
                    </div>
                    <input type="hidden" name="e-card-id" value="<?php echo e($ecard); ?>">
                    <div class="row">
                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.form.first_name')); ?></label>
                            <input type="text" class="form-control" name="first_name" id="e-card-first-name" required
                                value="<?php echo e(old('first_name')); ?>" placeholder="<?php echo e(__('messages.form.f_name')); ?>"
                                maxlength="10">
                        </div>
                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.form.last_name')); ?></label>
                            <input type="text" class="form-control" name="last_name" id="e-card-last-name" required
                                value="<?php echo e(old('last_name')); ?>" placeholder="<?php echo e(__('messages.form.l_name')); ?>"
                                maxlength="10">
                        </div>
                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.user.email')); ?></label>
                            <input type="email" class="form-control" name="email" id="e-card-email" required
                                placeholder="<?php echo e(__('messages.form.enter_email')); ?>" value="<?php echo e(old('email')); ?>">
                        </div>
                        
                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.form.occupation')); ?></label>
                            <input type="text" class="form-control" name="occupation" id="e-card-occupation" required
                                value="<?php echo e(old('occupation')); ?>" placeholder="<?php echo e(__('messages.form.occupation')); ?>"
                                maxlength="20">
                        </div>
                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.user.location')); ?></label>
                            <input type="text" class="form-control" name="location" id="e-card-location" required
                                value="<?php echo e(old('location')); ?>" placeholder="<?php echo e(__('messages.form.location')); ?>">
                        </div>
                        <div class="col-md-6 mt-4">
                            <div class="form-group">
                                <?php echo e(Form::label('phone', __('messages.user.phone') . ':', ['class' => 'form-label required'])); ?>

                                <?php echo e(Form::text('phone', null, ['class' => 'form-control', 'required', 'placeholder' => __('messages.form.phone'), 'id' => 'phoneNumber', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

                                <?php echo e(Form::hidden('region_code', null, ['id' => 'prefix_code'])); ?>

                            </div>
                        </div>

                        <div class="col-md-6 mt-4">
                            <label class="form-label required"><?php echo e(__('messages.social.website')); ?></label>
                            <input type="text" class="form-control" name="website" id="e-card-website" required
                                value="<?php echo e(old('website')); ?>" placeholder="<?php echo e(__('messages.form.website')); ?>">
                        </div>
                    </div>

                    <div class="col-lg-12 d-flex mt-5">
                        <button type="submit" class="btn btn-primary me-3" id="virtualBackgroundSubmitBtn">
                            <?php echo e(__('messages.common.save')); ?>

                        </button>
                        <a href="<?php echo e(route('virtual-backgrounds.index')); ?>"
                            class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/virtual-backgrounds/create.blade.php ENDPATH**/ ?>