<div class="modal fade" id="addNfcModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><?php echo e(__('messages.nfc.new_nfc_card')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            <?php echo e(Form::open(['id'=>'addNfcForm', 'files' => 'true'])); ?>

            <div class="modal-body">
                <div class="alert alert-danger fs-4 text-white d-flex align-items-center  d-none" role="alert" id="NfcValidationErrorsBox">
                    <i class="fa-solid fa-face-frown me-5"></i>
                </div>
                <div class="mb-5">
                    <?php echo e(Form::label('name',__('messages.common.name').':', ['class' => 'form-label required'])); ?>

                    <?php echo e(Form::text('name', null, ['class' => 'form-control', 'required','placeholder' => __('messages.common.name'),'id' => 'Name','autofocus'])); ?>

                </div>
                <div>
                        <?php echo e(Form::label('price', __('messages.common.price').':', ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::number('price', null, ['class' => 'form-control','required','step'=>'0.01', 'min'=>'0', 'placeholder' => __('messages.form.price')])); ?>

                </div>

            <div>
                <div class="col-sm-12 mb-5 mt-5">
                    <?php echo e(Form::label('description', __('messages.common.description').':', ['class' => 'form-label required'])); ?>

                    <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'placeholder' => __('messages.form.short_description'), 'rows' => '5', 'required'])); ?>

                </div>
            </div>
                <div class="col-sm-12 mb-5 mt-5 d-flex">
                    <div class="mb-3" io-image-input="true">
                        <label for="nfcImgId"
                               class="form-label required"><?php echo e(__('messages.nfc.nfc_image'). " : "); ?></label>
                        <div class="d-block">
                            <div class="image-picker">
                                <div class="image previewImage" id="nfcPreview"
                                     style="background-image: url('<?php echo e(asset('assets/img/nfc/card_default.png')); ?>')"></div>
                                <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                      data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                    <label>
                                        <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                        <input type="file" id="nfc_img" name="nfc_img"
                                               class="image-upload file-validation  d-none" accept="image/*"/> </label>
                                </span>
                            </div>
                            <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                        </div>
                        <input type="hidden" id="defaultNfcImgUrl" value="<?php echo e(asset('assets/img/nfc/card_default.png')); ?>" />
                    </div>
                    <div class="mb-3" io-image-input="true">
                        <label for="nfcImgId"
                               class="form-label required"><?php echo e(__('messages.nfc.nfc_back_image'). " : "); ?></label>
                        <div class="d-block">
                            <div class="image-picker">
                                <div class="image previewImage" id="nfcPreview"
                                     style="background-image: url('<?php echo e(asset('assets/img/nfc/card_default.png')); ?>')"></div>
                                <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                      data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                    <label>
                                        <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                        <input type="file" id="nfc_back_img" name="nfc_back_img"
                                               class="image-upload file-validation  d-none" accept="image/*"/> </label>
                                </span>
                            </div>
                            <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                        </div>
                        <input type="hidden" id="defaultNfcImgUrl" value="<?php echo e(asset('assets/img/nfc/card_default.png')); ?>" />
                    </div>
                </div>

            </div>
            <div class="modal-footer pt-0">
                <?php echo e(Form::button(__('messages.common.save'), ['type'=>'submit','class' => 'btn btn-primary m-0','id'=>'btnSave'])); ?>

                <button type="button" class="btn btn-secondary my-0 ms-5 me-0"
                        data-bs-dismiss="modal"><?php echo e(__('messages.common.discard')); ?></button>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/sadmin/nfc/add_nfc_modal.blade.php ENDPATH**/ ?>