<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.subscription.manage_subscription')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('layouts.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-7">
                            <h2><?php echo $currentPlan->plan->name; ?></h2>
                            <h4><?php echo e(__('messages.plan.no_of_vcards') . ': ' . $currentPlan->no_of_vcards); ?></h4>
                            <h5 class="mb-12">

                                <?php if(\Carbon\Carbon::now() > $currentPlan->ends_at): ?>
                                    <span class="text-danger">
                                        <?php echo e(__('messages.subscription.expired') . ' ' . localized_date($currentPlan->ends_at, 'dS M, Y')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-success">
                                        <?php echo e(__('messages.subscription.active_until') . ' ' . localized_date($currentPlan->ends_at, 'dS M, Y')); ?>

                                    </span>
                                <?php endif; ?>
                            </h5>
                            <div class="fs-5 mb-2">
                                <?php
                                    $subscriptionPlanDays = collect(
                                        \App\Models\Plan::DURATION[$currentPlan->plan_frequency],
                                    )
                                        ->map(function ($value) {
                                            return trans('messages.plan.' . $value);
                                        })
                                        ->implode(', ');
                                ?>
                                <div class="text-gray-800 fw-bolder me-1">
                                    <?php echo e(currencyFormat($currentPlan->plan_amount, 2, $currentPlan->plan->currency->currency_code) . '/ ' . $subscriptionPlanDays); ?>

                                    
                                </div>
                                <?php if(!empty($currentPlan->trial_ends_at)): ?>
                                    <?php
                                        $startsAt = \Carbon\Carbon::now();
                                        $totalDays = \Carbon\Carbon::parse($currentPlan->starts_at)->diffInDays(
                                            $currentPlan->ends_at,
                                        );
                                        $usedDays = \Carbon\Carbon::parse($currentPlan->starts_at)->diffInDays(
                                            $startsAt,
                                        );
                                        $remainingDays = $totalDays - $usedDays;
                                    ?>
                                    <div class="text-gray-600 fw-bold">
                                        <small>
                                            <?php if($remainingDays > 0): ?>
                                                <?php echo e(__('messages.plan.trial_days')); ?> :
                                                <?php echo e($remainingDays . ' ' . __('messages.plan.days') . ' ' . __('messages.subscription.remaining')); ?>

                                            <?php endif; ?>
                                        </small>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="fs-6 text-gray-600 fw-bold mb-2">
                                <?php echo e(__('messages.subscription.subscribed_date') . ': ' . localized_date($currentPlan->starts_at, 'dS M Y')); ?>

                            </div>
                            <div>
                                <?php $__currentLoopData = getPlanFeature($currentPlan->plan); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($value): ?>
                                        <span
                                            class="badge <?php echo e(getRandomColor($loop->index)); ?>  fs-7 m-1"><?php echo e(__('messages.feature.' . $feature)); ?></span>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="col-lg-5 mt-lg-0 mt-5">
                            <div class="d-flex justify-content-end">
                                <a class="btn btn-primary" href="<?php echo e(route('subscription.upgrade')); ?>">
                                    <?php echo e(__('messages.subscription.upgrade_plan')); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid mt-5">
        <div class="d-flex flex-column table-striped">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('usersubscription-table', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3792065043-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/subscription/index.blade.php ENDPATH**/ ?>