<div class="modal fade" id="addProductCategoryModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><?php echo e(__('messages.whatsapp_stores.new_product_category')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="whatsappStoreProductCategoryForm">
                    <input type="hidden" value="<?php echo e($whatsappStore->id); ?>" name="whatsappStoreId">
                    <div class="form-group">
                        <label class="form-label required"><?php echo e(__('messages.common.name') . ':'); ?></label>
                        <input type="text" class="form-control" name="name"
                            placeholder="<?php echo e(__('messages.whatsapp_stores.category_placeholder')); ?>" required>
                    </div>
                    <div class="mb-3 mt-5" io-image-input="true">
                        <label for="productCategoryPreview" class="form-label required"><?php echo e(__('messages.vcard.image') . ':'); ?></label>
                        <div class="d-block">
                            <div class="image-picker">
                                <input type="hidden" id="categoryDefaultImage" value="<?php echo e(asset('images/category.png')); ?>">
                                <div class="image previewImage" id="productCategoryPreview" style="background-image: url(<?php echo e(asset('images/category.png')); ?>)" >
                                </div>
                                <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                    data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                    <label>
                                        <i class="fa-solid fa-pen"></i>
                                        <input type="file" id="image" name="image"
                                            class="image-upload file-validation d-none" accept="image/*" />
                                    </label>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
            </div>
            <div class="modal-footer">
                <button type="submit" id="productCategorySave" class="btn btn-primary m-0"><?php echo e(__('crud.save')); ?>

                </button>
                </form>
                <button class="btn btn-secondary my-0 ms-5 me-0"
                    data-bs-dismiss="modal"><?php echo e(__('messages.common.discard')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/whatsapp_stores/products_category/add_product_category.blade.php ENDPATH**/ ?>