<header class='d-flex align-items-center justify-content-between flex-grow-1 header px-3 px-xl-0'>
    <button type="button" class="btn px-0 aside-menu-container__aside-menubar d-block d-xl-none sidebar-btn sidemenu-btn">
        <i class="fa-solid fa-bars fs-1"></i>
    </button>
    <nav class="navbar navbar-expand-xl navbar-light top-navbar d-xl-flex d-block px-3 px-xl-0 py-4 py-xl-0 <?php echo e(!getLogInUser()->theme_mode ? 'bg-white' : ''); ?>" id="nav-header">
        <div class="container-fluid pe-0">
            <div class="navbar-collapse">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <?php echo $__env->make('layouts.sub_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </ul>
            </div>
        </div>
    </nav>
    <ul class="nav align-items-center flex-nowrap">
        <li class="nav-item px-3 mt-1">
            <div class="dropdown">
                <a class="btn dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                    data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="<?php echo e(asset(\App\Models\User::FLAG[getCurrentLanguageName()])); ?>" class="me-2"
                            style="width: 18px; height: 20px;" />
                <?php echo e(getLanguageByKey(getCurrentLanguageName())); ?>

                </a>
                <ul class="dropdown-menu lang-drop-menu p-2" aria-labelledby="dropdownMenuLink">
                    <?php $__currentLoopData = getAllLanguageWithFullData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="adminLanguageSelection <?php echo e(checkFrontLanguageSession() == $key ? 'active' : ''); ?>"
                            data-prefix-value="<?php echo e($language->iso_code); ?>">
                            <a href="javascript:void(0)"
                                class="nav-link d-flex align-items-center dropdown-item <?php echo e(checkFrontLanguageSession() == $key ? 'active' : ''); ?>">
                                <?php if(array_key_exists($language->iso_code, \App\Models\User::FLAG)): ?>
                                    <?php $__currentLoopData = \App\Models\User::FLAG; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageKey => $imageValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($imageKey == $language->iso_code): ?>
                                            <img src="<?php echo e(asset($imageValue)); ?>" class="me-2"
                                                style="width: 18px; height: 20px;" />
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <?php if(count($language->media) != 0): ?>
                                        <img src="<?php echo e($language->image_url); ?>" class="me-2"
                                        style="width: 18px; height: 20px;" />
                                    <?php else: ?>
                                        <i class="fa fa-flag fa-xl me-3 text-danger" aria-hidden="true"></i>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php echo e($language->name); ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </li>
        <?php if(getLogInUser()->theme_mode): ?>
            <li class="px-xxl-3 px-2">
                <a data-turbo="false" href="<?php echo e(route('mode.theme')); ?>" title="<?php echo e(__('messages.tooltip.light_mode')); ?>">
                    <i class="fa-solid fa-sun text-primary fs-2"></i>
                </a>
            </li>
        <?php else: ?>
            <li class="px-xxl-3 px-2">
                <a data-turbo="false" href="<?php echo e(route('mode.theme')); ?>" title="<?php echo e(__('messages.tooltip.dark_mode')); ?>">
                    <i class="fa-solid fa-moon text-primary fs-2"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', \App\Models\Role::ROLE_ADMIN)): ?>
        <?php if(!empty(getCurrentSubscription()) && getCurrentSubscription()->plan->is_trial): ?>
            <li class="px-xxl-3 px-2">
                <span class="text-primary">
                    <?php echo e(__('messages.subscription.trial_plan')); ?>

                </span>
            </li>
        <?php endif; ?>
        <?php endif; ?>

        <?php if (is_impersonating()) : ?>
        <li class="px-xxl-3 px-2">
            <span class="text-primary">
                <a data-turbo="false" data-turbo-eval="false" href="<?php echo e(route('impersonate.leave')); ?>">
                    <i class="fas fa-user-check fs-2"></i>
                </a>
            </span>
        </li>
        <?php endif; ?>

        <li class="px-xxl-3 px-2">
            <div class="dropdown d-flex align-items-center py-4">
                <div class="image image-circle image-mini">
                    <img src="<?php echo e(getLogInUser()->profile_image); ?>"
                         class="img-fluid" alt="profile image">
                </div>
                <button class="btn dropdown-toggle ps-2 pe-0" type="button" id="dropdownMenuButton1"
                        data-bs-toggle="dropdown" aria-expanded="false" data-bs-auto-close="outside">
                    <?php echo getLogInUser()->full_name; ?>

                </button>
                <div class="dropdown-menu py-7 pb-4 my-2" aria-labelledby="dropdownMenuButton1" data-bs-auto-close="outside" style="z-index: 999999">
                    <div class="text-center border-bottom pb-5">
                        <div class="image image-circle image-tiny mb-5">
                            <img src="<?php echo e(getLogInUser()->profile_image); ?>" class="img-fluid" alt="profile image">
                        </div>
                        <h3 class="text-gray-900"><?php echo e(getLogInUser()->full_name); ?></h3>
                        <h4 class="mb-0 fw-400 fs-6"><?php echo e(getLogInUser()->email); ?></h4>
                    </div>
                    <ul class="pt-4">
                        <li>
                            <a class="dropdown-item text-gray-900" href="<?php echo e(route('profile.setting')); ?>">
                            <span class="dropdown-icon me-4 text-gray-600">
                                <i class="fa-solid fa-user icon-color-bs-green"></i>
                            </span>
                                <?php echo e(__('messages.user.account_setting')); ?>

                            </a>
                        </li>
                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', \App\Models\Role::ROLE_ADMIN)): ?>
                            <li>
                                <a class="dropdown-item text-gray-900" href="<?php echo e(route('subscription.index')); ?>">
                                    <span class="dropdown-icon me-4 text-gray-600">
                                        <i class="fa-solid fa-money-bill icon-color-bs-purple"></i>
                                    </span>
                                    <?php echo e(__('messages.subscription.manage_subscription')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if((is_impersonating() === false)): ?>
                            <li>
                                <a class="dropdown-item text-gray-900" id="changePassword" href="javascript:void(0)">
                                    <span class="dropdown-icon me-4 text-gray-600">
                                        <i class="fa-solid fa-lock icon-color-bs-orange"></i>
                                    </span>
                                    <?php echo e(__('messages.user.change_password')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a class="dropdown-item text-gray-900" id="changeLanguage" href="javascript:void(0)">
                               <span class="dropdown-icon me-4 text-gray-600">
                                   <i class="fa-solid fa-globe icon-color-bs-yellow"></i>
                               </span>
                                <?php echo e(__('messages.user.change_language')); ?>

                            </a>
                        </li>
                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', \App\Models\Role::ROLE_ADMIN)): ?>
                        <li>
                            <a class="dropdown-item text-gray-900" href="<?php echo e(route('delete-account')); ?>">
                                <span class="dropdown-icon me-4 text-gray-600">
                                    <i class="fa-solid fa-trash icon-color-bs-red"></i>
                                </span>
                                <?php echo e(__('messages.user.delete_my_account')); ?></a>
                        </li>
                        <?php endif; ?>
                        <li>
                            <a class="dropdown-item text-gray-900 d-flex justify-content-start" href="javascript:void(0)">
                                <span class="dropdown-icon me-4 text-gray-600">
                                    <i class="fa-solid fa-right-from-bracket icon-color-bs-blue"></i>
                                </span>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                </form>
                                <span onclick="event.preventDefault(); localStorage.clear();  document.getElementById('logout-form').submit();">
                                    <?php echo e(__('messages.sign_out')); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </li>
        <li>
            <button type="button" class="btn px-0 d-block d-xl-none header-btn pb-2">
                <i class="fa-solid fa-bars fs-1"></i>
            </button>
        </li>
    </ul>
</header>
<div class="bg-overlay" id="nav-overly"></div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetas/resources/views/layouts/header.blade.php ENDPATH**/ ?>