<div class="modal fade" id="addBlogModal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title"><?php echo e(__('messages.vcard.new_blog')); ?></h2>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['id'=>'addBlogForm', 'files' => 'true']); ?>

                <div class="row">
                    <div class="col-sm-12 mb-5">
                        <?php echo e(Form::hidden('vcard_id', $vcard->id)); ?>

                        <?php echo e(Form::label('title',__('messages.front_cms.title').(':'), ['class' => 'form-label required fs-6 fw-bolder text-gray-700 mb-3'])); ?>

                        <?php echo e(Form::text('title', null, ['class' => 'form-control','required', 'placeholder' => __('messages.form.blog'), 'maxlength'=>'100'])); ?>

                    </div>
                    <div class="col-sm-12 mb-5">
                        <?php echo e(Form::label('blogDescription', __('messages.common.description').':', ['class' => 'form-label required fs-6 fw-bolder text-gray-700 mb-3'])); ?>

                        <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'id' => 'blogDescription', 'required'])); ?>

                    </div>
                    <div class="col-sm-12 mb-5">
                        <div class="mb-3" io-image-input="true">
                            <label for="blogImgId"
                                   class="form-label required"><?php echo e(__('messages.vcard.blog_icon').':'); ?></label>
                            <div class="d-block">
                                <div class="image-picker">
                                    <div class="image previewImage" id="blogPreview"
                                         style="background-image: url('<?php echo e(asset('assets/images/default_service.png')); ?>')"></div>
                                    <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                          data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.image')); ?>">
                                        <label>
                                            <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                            <input type="file" id="blogIcon" name="blog_icon"
                                                   class="image-upload file-validation d-none" accept="image/*"/> </label>
                                    </span>
                                </div>
                                <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex">
                        <?php echo e(Form::button(__('messages.common.save'), ['type'=>'submit','class' => 'btn btn-primary me-3','id'=>'blogSave'])); ?>

                        <button type="button" class="btn btn-secondary me-2"
                                data-bs-dismiss="modal"><?php echo e(__('messages.common.discard')); ?></button>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u628739340/domains/kosari.net/public_html/tarjetadigital/resources/views/vcards/blogs/create.blade.php ENDPATH**/ ?>