<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Interior Designer vCard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Bootstrap CSS -->
    <link href="{{ asset('front/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="icon" href="{{ getFaviconUrl() }}" type="image/png">

    {{-- <link rel="stylesheet" href="../css/slick.css" />
    <link rel="stylesheet" href="../css/slick-theme.css" />
    <link rel="stylesheet" href="../scss/custom.css" />
    <link rel="stylesheet" href="../scss/interior.css" /> --}}
    {{-- css link --}}
    <link rel="stylesheet" href="{{ asset('assets/css/vcard32.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick-theme.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/custom.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/third-party.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom-vcard.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/lightbox.css') }}">
</head>

<body>
    <div class="container p-0">
        <div class="main-content mx-auto w-100 overflow-hidden">
            <div class="banner-section position-relative">
                <div class="banner-bg">
                    <img src="{{ asset('assets/img/vcard32/banner-bg.png') }}" alt="bg-img" />
                </div>
                <div class="banner-img">
                    <img src="{{ asset('assets/img/vcard32/banner-img.png') }}" class="w-100 h-100 object-fit-cover"
                        alt="banner" />
                </div>
            </div>
            <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
                <div class="language pt-3 me-2">
                    <ul class="text-decoration-none">
                        <li class="dropdown1 dropdown lang-list">
                            <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                                role="button" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-language me-2"></i>Language</a>
                            <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/english.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">English</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/spain.png') }}" width="25px" height="20px"
                                        class="me-3" loading="lazy"><a href="#">Spanish</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/france.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Franch</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/arabic.svg') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Arabic</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/german.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">German</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/russian.jpeg') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">russian</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/turkish.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Turkish</a>
                                </li>

                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="d-flex flex-sm-row gap-4 flex-column px-30">
                <div class="profile-section">
                    <div class="card flex-sm-row gap-4 mb-20">
                        <div class="card-img">
                            <img src="{{ asset('assets/img/vcard32/profile-img.jpg') }}"
                                class="w-100 h-100 object-fit-cover" />
                        </div>
                        <div class="card-body pt-sm-3 p-0 text-sm-start text-center">
                            <div class="profile-name">
                                <h2 class="text-secondary mb-0 fs-30 fw-6">Jeff Murray</h2>
                                <p class="fs-18 text-gray mb-0">Interior Designer</p>
                            </div>
                        </div>
                    </div>
                    <p class="text-gray profile-desc fs-14 text-sm-start text-center mb-0">
                        Lorem Ipsum is simply dummy text of the printing and typesetting
                        industry. Lorem Ipsum has been the industry's standard dummy text
                        ever since the 1500s, when an unknown printer took a galley of
                        type and scrambled it to make a type specimen book.
                    </p>
                </div>
                <div class="social-media-section mt-sm-4">
                    <div class="d-flex gap-3 flex-sm-column flex-row flex-wrap justify-content-center">
                        <div class="social-icon">
                            <a href="" class="d-flex justify-content-center align-items-center">
                                <svg width="8" height="15" viewBox="0 0 8 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.09294 8.46668C1.76023 8.46668 1.45476 8.46668 1.14928 8.46668C0.888741 8.46668 0.628201 8.47158 0.368115 8.46472C0.0957734 8.45787 0.00680853 8.36971 0.00453902 8.0783C-0.00136171 7.31475 -0.00181561 6.55071 0.00499292 5.78717C0.00771634 5.49821 0.103036 5.40662 0.371746 5.40466C0.875577 5.40123 1.37941 5.40368 1.88369 5.40368C1.94542 5.40368 2.00716 5.40368 2.09294 5.40368C2.09294 5.32091 2.09204 5.24989 2.09294 5.17937C2.10474 4.48341 2.08023 3.78451 2.13561 3.09247C2.27587 1.3298 3.52274 0.0710998 5.16223 0.0137971C5.82947 -0.00971175 6.49852 0.00351195 7.16621 0.00547102C7.40133 0.00596078 7.49665 0.109791 7.49756 0.36447C7.50073 1.07904 7.50073 1.7941 7.49801 2.50867C7.4971 2.78245 7.40814 2.88187 7.14714 2.88824C6.6887 2.89999 6.23026 2.89999 5.77137 2.90783C5.2571 2.91615 5.04104 3.13312 5.03014 3.68117C5.01925 4.2351 5.02787 4.79 5.02787 5.36548C5.10549 5.36548 5.16586 5.36548 5.22623 5.36548C5.80949 5.36548 6.39276 5.3645 6.97602 5.36597C7.34368 5.36646 7.42993 5.45853 7.43038 5.84839C7.43083 6.5752 7.43174 7.30251 7.42993 8.02932C7.42902 8.35452 7.34959 8.44219 7.04638 8.44366C6.38413 8.4466 5.72189 8.44464 5.02833 8.44464C5.02833 8.52986 5.02833 8.60577 5.02833 8.6812C5.02833 10.5932 5.02833 12.5058 5.02833 14.4178C5.02833 14.9448 4.97658 14.9997 4.48001 14.9997C3.82867 14.9997 3.17777 15.0007 2.52642 14.9992C2.17782 14.9987 2.09294 14.9081 2.09294 14.5359C2.09249 12.593 2.09249 10.6501 2.09249 8.70765C2.09294 8.63565 2.09294 8.56365 2.09294 8.46668Z"
                                        fill="#51553A" />
                                </svg>
                            </a>
                        </div>
                        <div class="social-icon">
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15 6.73538C15 7.02861 15 7.32147 15 7.61469C14.9765 7.80773 14.9574 8.00113 14.9291 8.19343C14.7001 9.74874 14.0406 11.0945 12.9364 12.2153C11.7528 13.4168 10.3181 14.1251 8.6419 14.3192C7.17634 14.4891 5.78099 14.2323 4.46945 13.5493C4.37903 13.5023 4.3022 13.484 4.19671 13.5218C3.42037 13.7999 2.64036 14.0675 1.86218 14.3409C1.24096 14.5589 0.620849 14.7802 0 15C0.0128654 14.9387 0.0187468 14.8752 0.0393315 14.8165C0.498811 13.5005 0.957556 12.1837 1.42439 10.8703C1.47916 10.7165 1.47511 10.5972 1.39866 10.4482C0.693999 9.07715 0.462053 7.6213 0.688117 6.10159C0.915284 4.57418 1.5751 3.24714 2.66829 2.15278C4.28971 0.529947 6.26032 -0.171371 8.54081 0.0352441C9.92697 0.160755 11.1735 0.672339 12.2615 1.54394C13.6785 2.67867 14.5648 4.13636 14.886 5.92727C14.9338 6.19481 14.9625 6.46601 15 6.73538ZM6.17394 5.9203C6.18313 5.90415 6.1846 5.89901 6.18791 5.89571C6.37721 5.70487 6.56762 5.51551 6.75546 5.32357C6.97601 5.09787 6.97601 4.85529 6.75325 4.63033C6.43345 4.30774 6.11219 3.98626 5.78871 3.66698C5.56081 3.44201 5.32078 3.44201 5.09361 3.66551C4.85689 3.89855 4.62898 4.14076 4.38638 4.36756C4.11179 4.62446 4.03019 4.93897 4.06732 5.29788C4.12944 5.89461 4.37572 6.42491 4.68008 6.92805C5.47149 8.236 6.52131 9.29918 7.79572 10.1403C8.31107 10.4805 8.85841 10.7594 9.47227 10.8835C9.94425 10.9789 10.3604 10.911 10.6956 10.5235C10.8867 10.3025 11.1084 10.1077 11.315 9.89957C11.5517 9.66066 11.5513 9.42432 11.3128 9.18394C11.0099 8.87897 10.7048 8.57584 10.4004 8.27234C10.1211 7.99379 9.90051 7.99306 9.62261 8.27013C9.44029 8.45216 9.2587 8.63492 9.07859 8.81548C7.77036 8.17508 6.80913 7.21504 6.17394 5.9203Z"
                                        fill="#51553A" />
                                </svg>
                            </a>
                        </div>
                        <div class="social-icon">
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M14.9897 9.08193C14.9848 8.38578 14.9154 7.69353 14.713 7.02086C14.4597 6.17842 14.0007 5.50085 13.1817 5.11437C12.5491 4.81595 11.8744 4.73229 11.1851 4.75284C9.97846 4.78904 9.00213 5.25478 8.34944 6.30758C8.34211 6.31932 8.32255 6.32372 8.28149 6.3472C8.28149 5.88489 8.28149 5.44313 8.28149 5.00087C7.27777 5.00087 6.2985 5.00087 5.32167 5.00087C5.32167 8.34224 5.32167 11.6704 5.32167 15C6.3557 15 7.37311 15 8.41691 15C8.41691 14.9085 8.41691 14.8361 8.41691 14.7632C8.41691 13.2007 8.41251 11.6376 8.42033 10.075C8.4218 9.72819 8.44429 9.37889 8.49367 9.03595C8.62861 8.09567 9.10675 7.58737 9.97504 7.48464C10.9289 7.37212 11.5948 7.71995 11.7835 8.74388C11.8505 9.10786 11.8798 9.48309 11.8822 9.85343C11.893 11.4894 11.8881 13.1253 11.8886 14.7613C11.8886 14.8317 11.8886 14.9017 11.8886 14.9687C12.9397 14.9687 13.9615 14.9687 14.9926 14.9687C14.9956 14.9276 15 14.8983 15 14.8684C14.9975 12.9399 15.0024 11.0109 14.9897 9.08193Z"
                                        fill="#51553A" />
                                    <path
                                        d="M0.257835 14.9932C1.29382 14.9932 2.32002 14.9932 3.34965 14.9932C3.34965 11.6562 3.34965 8.33293 3.34965 4.99842C2.31758 4.99842 1.29577 4.99842 0.257835 4.99842C0.257835 8.33929 0.257835 11.663 0.257835 14.9932Z"
                                        fill="#51553A" />
                                    <path
                                        d="M1.7884 7.14552e-05C0.805221 0.00887739 -0.000488679 0.82098 2.2238e-07 1.80235C0.000489124 2.80036 0.824289 3.62616 1.81334 3.62029C2.79701 3.61442 3.6037 2.79008 3.59783 1.7955C3.59245 0.797498 2.7799 -0.00873448 1.7884 7.14552e-05Z"
                                        fill="#51553A" />
                                </svg>
                            </a>
                        </div>
                        <div class="social-icon">
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M14.9983 3.45674C14.9983 6.15179 14.9983 8.84638 14.9983 11.5414C14.9391 11.8216 14.9043 12.1101 14.8167 12.3811C14.3059 13.9572 12.8884 14.9913 11.2251 14.9959C8.74058 15.0028 6.25602 14.9995 3.77146 14.9968C2.97354 14.9959 2.23798 14.7753 1.59185 14.303C0.524285 13.5225 0.000591317 12.4609 0.000591317 11.1397C0.000132741 8.72348 -0.00124299 6.30725 0.00288419 3.89101C0.00334277 3.64338 0.0148072 3.39117 0.059289 3.14812C0.311047 1.76231 1.09842 0.795629 2.39894 0.266432C2.73233 0.130694 3.10331 0.0862122 3.45687 0C6.15192 0 8.84651 0 11.5416 0C11.6466 0.0188016 11.752 0.0362275 11.8566 0.0559462C13.2332 0.315959 14.1972 1.09554 14.7273 2.38643C14.8662 2.72348 14.9107 3.09905 14.9983 3.45674ZM13.7395 7.49909C13.7413 7.49909 13.7432 7.49909 13.745 7.49909C13.745 6.27882 13.7427 5.05855 13.7464 3.83782C13.7473 3.44665 13.695 3.06695 13.5203 2.71523C13.0471 1.76185 12.2753 1.25787 11.2082 1.2542C8.73325 1.24549 6.25831 1.25099 3.78338 1.25283C3.63755 1.25283 3.49081 1.26659 3.34682 1.28722C2.21093 1.44726 1.27039 2.47447 1.26305 3.62458C1.24608 6.17747 1.25617 8.73036 1.2548 11.2833C1.2548 11.6299 1.32266 11.9647 1.47537 12.2747C1.95504 13.2464 2.7415 13.7426 3.82695 13.744C6.27253 13.7476 8.71811 13.7458 11.1637 13.7435C11.3288 13.7435 11.4952 13.7307 11.659 13.7082C12.7728 13.5555 13.7203 12.5168 13.7354 11.3938C13.7533 10.096 13.7395 8.79777 13.7395 7.49909Z"
                                        fill="#51553A" />
                                    <path
                                        d="M11.2479 7.51743C11.2282 9.59386 9.52731 11.2745 7.47289 11.2475C5.39875 11.2204 3.73045 9.53241 3.75017 7.47983C3.76989 5.40248 5.46937 3.72364 7.52471 3.74977C9.5993 3.77683 11.2676 5.46485 11.2479 7.51743ZM7.50132 5.0026C6.12193 5.00031 5.0085 6.11006 5.003 7.49313C4.99704 8.87069 6.10588 9.9864 7.48986 9.99558C8.87155 10.0043 9.99689 8.88261 9.99551 7.49771C9.99414 6.11648 8.88255 5.0049 7.50132 5.0026Z"
                                        fill="#51553A" />
                                    <path
                                        d="M11.569 4.36931C11.0471 4.37298 10.6289 3.95797 10.6289 3.43657C10.6294 2.92342 11.0398 2.50841 11.5548 2.50015C12.0633 2.4919 12.4999 2.9248 12.4994 3.43702C12.4994 3.94742 12.0817 4.36564 11.569 4.36931Z"
                                        fill="#51553A" />
                                </svg>
                            </a>
                        </div>
                        <div class="social-icon">
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="15" height="13" viewBox="0 0 15 13" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.21239 10.1728C2.87484 9.99007 1.98743 9.32671 1.48585 8C1.9167 8 2.2961 8 2.66907 8C1.31223 7.43817 0.546998 6.45668 0.450541 4.89982C0.862093 5.02166 1.24149 5.13673 1.62089 5.24503C1.64018 5.21796 1.65948 5.19088 1.67877 5.16381C1.11288 4.68321 0.707761 4.08754 0.56629 3.32942C0.424819 2.5713 0.489124 1.84025 0.881385 1.0889C2.50187 3.03159 4.48247 4.162 6.91963 4.32446C6.91963 4.04016 6.9132 3.79648 6.91963 3.55279C6.95821 2.25993 7.56268 1.31904 8.6623 0.797832C9.73619 0.29016 10.7908 0.425539 11.7168 1.22428C11.974 1.44765 12.2055 1.49503 12.4949 1.37319C12.9386 1.19043 13.3823 1.00767 13.8646 0.818138C13.6588 1.49503 13.2344 1.95532 12.7907 2.45622C13.2537 2.32761 13.7167 2.19224 14.1797 2.06363C14.199 2.08393 14.2247 2.10424 14.244 2.12455C13.8774 2.52391 13.5302 2.95713 13.1315 3.31588C12.9129 3.51218 12.8293 3.70848 12.8228 3.99955C12.7842 6.037 12.2055 7.88492 11.0094 9.49593C9.4018 11.6688 7.26688 12.7653 4.6368 12.8195C3.13206 12.8533 1.72378 12.5217 0.399097 11.7703C0.270487 11.6958 0.141877 11.6146 0.00683594 11.4995C1.53087 11.574 2.91985 11.1949 4.21239 10.1728Z"
                                        fill="#51553A" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-section pt-40 px-30">
                <div class="row">
                    <div class="col-sm-6 mb-40">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="22" height="15" viewBox="0 0 22 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M11.0229 0.00124986C13.824 0.00124986 16.6195 -0.00374959 19.4206 0.00624932C19.7869 0.00624932 20.1589 0.0412455 20.5139 0.111238C21.1508 0.241224 21.5904 0.601185 21.8666 1.12113C22.1089 1.57608 22.03 1.82605 21.5566 2.09102C20.9423 2.43599 20.3223 2.77595 19.708 3.12091C17.0253 4.63575 14.3425 6.14058 11.671 7.66542C11.1863 7.94539 10.8031 7.93539 10.3184 7.66042C7.06643 5.80562 3.79755 3.97582 0.534299 2.13602C0.466667 2.09602 0.393399 2.06103 0.331403 2.02103C0.0101504 1.82605 -0.0518457 1.67107 0.0608744 1.3461C0.337039 0.546191 1.02463 0.0812412 2.03348 0.0312466C2.43927 0.0112488 2.84506 0.0112488 3.24522 0.00624932C5.83778 0.00624932 8.43034 0.00624932 11.0229 0.00124986Z"
                                        fill="#51553A" />
                                    <path
                                        d="M10.9765 14.995C8.13035 14.995 5.2898 15 2.44362 14.99C2.08855 14.99 1.72221 14.955 1.37841 14.87C0.685182 14.695 0.256845 14.2601 0.0483128 13.6551C-0.0587713 13.3402 0.00322478 13.1852 0.324477 13.0052C2.95086 11.5404 5.57723 10.0755 8.20361 8.61069C8.47978 8.4557 8.77285 8.4557 9.04901 8.60069C9.54498 8.86066 10.0297 9.13063 10.5144 9.4056C10.9145 9.63558 11.0836 9.64058 11.4725 9.4156C11.9854 9.12063 12.5039 8.83566 13.0168 8.54069C13.2929 8.38071 13.5409 8.43071 13.7945 8.57569C14.6343 9.05564 15.4741 9.53059 16.3195 10.0055C18.0441 10.9754 19.7743 11.9353 21.499 12.9052C22.0287 13.2002 22.1133 13.4452 21.854 13.9401C21.499 14.61 20.8564 14.895 20.073 14.98C19.8758 15 19.6785 15 19.4813 15C16.6464 14.995 13.8114 14.995 10.9765 14.995Z"
                                        fill="#51553A" />
                                    <path
                                        d="M0.0429635 11.5204C0.0429635 8.83066 0.0429635 6.18595 0.0429635 3.49624C2.42136 4.8411 4.76594 6.16095 7.14997 7.50581C4.77157 8.85066 2.42699 10.1755 0.0429635 11.5204Z"
                                        fill="#51553A" />
                                    <path
                                        d="M14.871 7.50581C17.2438 6.16596 19.5884 4.8411 21.9667 3.49624C21.9667 6.17595 21.9667 8.81567 21.9667 11.5104C19.594 10.1755 17.2494 8.85067 14.871 7.50581Z"
                                        fill="#51553A" />
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="mailto:jackie@gmail.com" class="text-dark fw-5">jackie@gmail.com</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-40">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.03788 8.65636C5.68074 11.8074 8.01407 14.1974 11.0974 15.8383C11.2284 15.9096 11.5379 15.8264 11.6688 15.7075C12.3712 15.0416 13.0617 14.3639 13.7284 13.6623C14.0974 13.2699 14.5022 13.2105 15.0141 13.3056C16.2284 13.5196 17.4545 13.7337 18.6807 13.8763C19.6569 13.9952 20.0022 14.3163 20.0022 15.3151C20.0022 16.3853 20.0022 17.4435 20.0022 18.5137C20.0022 19.6671 19.6331 20.0238 18.4545 20C10.0736 19.8573 2.57359 13.912 0.597401 5.75505C0.252163 4.31629 0.14502 2.80618 0.0140678 1.31986C-0.0692655 0.439952 0.41883 0.0118906 1.29978 0.0118906C2.46645 0 3.63312 0 4.79978 0C5.65693 0 6.01407 0.39239 6.12121 1.24851C6.28788 2.50892 6.51407 3.76932 6.75216 5.01784C6.8474 5.55291 6.75216 5.98098 6.35931 6.36147C5.57359 7.12247 4.81169 7.88347 4.03788 8.65636Z"
                                        fill="#51553A" />
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="tel:+1 4078461474" class="text-dark fw-5">+1 4078461474</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-sm-0 mb-40">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="24" height="20" viewBox="0 0 24 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_1990_491)">
                                        <path
                                            d="M0.31262 20C0.211822 19.8165 0.0505452 19.6427 0.0203058 19.4495C-0.0300932 19.1019 0.0203058 18.7446 0.000146203 18.3969C-0.0099336 18.0782 0.131184 17.9141 0.473897 17.9237C0.574695 17.9237 0.675493 17.9237 0.776291 17.9237C8.26558 17.9237 15.7448 17.9237 23.2341 17.9334C23.4861 17.9334 23.7381 18.0299 23.9901 18.0782C23.9901 18.7156 23.9901 19.3626 23.9901 20C16.1077 20 8.2051 20 0.31262 20Z"
                                            fill="#51553A" />
                                        <path
                                            d="M12.0254 8.18927C14.7167 8.18927 17.408 8.18927 20.1094 8.18927C21.6315 8.18927 22.3774 8.91356 22.3874 10.3814C22.3874 10.4008 22.3874 10.4104 22.3874 10.4297C22.5689 11.2796 22.1556 11.7624 21.3694 12.0908C20.5731 12.4191 19.807 12.4867 19.1115 11.9169C18.7688 11.6369 18.4866 11.2989 18.2043 10.9609C17.8314 10.5263 17.4786 10.5166 17.0956 10.9416C16.8436 11.2216 16.5916 11.5017 16.3093 11.7431C15.513 12.4288 14.6361 12.506 13.739 11.9556C13.3358 11.7045 12.9729 11.3858 12.6201 11.0671C12.1363 10.6325 11.9246 10.6325 11.4509 11.0864C11.1787 11.3472 10.8965 11.5983 10.584 11.8107C9.52563 12.5447 8.56805 12.4964 7.58023 11.6852C7.42903 11.5596 7.28791 11.4244 7.15687 11.2796C6.48153 10.536 6.34041 10.536 5.66506 11.3085C4.7478 12.3515 3.58863 12.5833 2.29841 12.0232C1.79442 11.8011 1.60291 11.4631 1.6533 10.9609C1.68354 10.7194 1.71378 10.478 1.68354 10.2462C1.51219 9.05842 2.51009 8.16996 3.8003 8.17961C6.53193 8.20858 9.27363 8.18927 12.0254 8.18927Z"
                                            fill="#51553A" />
                                        <path
                                            d="M22.1861 16.62C15.4024 16.62 8.64894 16.62 1.86523 16.62C1.86523 15.606 1.86523 14.592 1.86523 13.5394C3.54856 14.0802 5.02021 13.7325 6.22979 12.4867C8.24575 14.3409 10.1004 14.0898 12.0458 12.4288C14.4549 14.4375 16.1886 13.9739 17.8316 12.3998C18.386 12.9696 18.9908 13.4911 19.8174 13.6939C20.6338 13.8967 21.3999 13.7325 22.2063 13.4042C22.1861 14.4858 22.1861 15.5287 22.1861 16.62Z"
                                            fill="#51553A" />
                                        <path
                                            d="M10.5836 7.2815C10.5836 6.32544 10.5735 5.3887 10.5937 4.44229C10.6037 4.13326 10.8356 3.94978 11.1682 3.94978C11.7226 3.94012 12.277 3.94012 12.8213 3.94978C13.2043 3.94978 13.4261 4.16224 13.4261 4.51955C13.4462 5.42732 13.4362 6.34475 13.4362 7.2815C12.4786 7.2815 11.5512 7.2815 10.5836 7.2815Z"
                                            fill="#51553A" />
                                        <path
                                            d="M12.015 0C12.257 0.424915 12.5392 0.907774 12.8113 1.40029C12.9323 1.6224 13.0936 1.84452 13.1641 2.08595C13.3153 2.61709 13.0734 3.19652 12.64 3.4283C12.2066 3.66007 11.5413 3.59247 11.1885 3.28344C10.8155 2.94544 10.6946 2.29841 10.9567 1.82521C11.2994 1.18783 11.6723 0.569773 12.015 0Z"
                                            fill="#51553A" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1990_491">
                                            <rect width="24" height="20" fill="#51553A" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="mb-0 text-dark fw-5">12th June, 1990</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="18" height="24" viewBox="0 0 18 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_1990_518)">
                                        <path
                                            d="M8.99374 19.6847C8.69236 19.3226 8.4028 18.979 8.11915 18.6322C6.58862 16.7439 5.14082 14.7906 3.88803 12.6887C3.32368 11.7446 2.83024 10.7633 2.40772 9.73866C1.63064 7.84726 1.7636 5.98682 2.62046 4.1852C3.72847 1.85732 5.54561 0.470506 8.00392 0.0835592C11.7859 -0.510791 15.3788 2.26904 15.9964 6.19732C16.1973 7.48508 16.0052 8.69236 15.5236 9.87487C14.9859 11.1936 14.2915 12.4194 13.5351 13.605C12.1848 15.7162 10.675 17.6943 9.06761 19.595C9.04988 19.6166 9.0292 19.6414 8.99374 19.6847ZM12.5482 6.80405C12.5512 4.75478 10.9557 3.08627 8.9967 3.08627C7.03478 3.08627 5.4422 4.75169 5.4422 6.80096C5.4422 8.85023 7.03478 10.5187 8.99374 10.5187C10.9527 10.5187 12.5453 8.85642 12.5482 6.80405Z"
                                            fill="#51553A" />
                                        <path
                                            d="M6.23156 17.1619C5.88881 17.2145 5.54902 17.264 5.21219 17.3259C4.19577 17.5086 3.20004 17.7655 2.26045 18.2267C1.89406 18.4094 1.54541 18.6199 1.25881 18.9263C0.797873 19.4216 0.797873 19.9293 1.27062 20.4153C1.67246 20.8301 2.17181 21.0716 2.68888 21.2821C3.69052 21.6845 4.73648 21.9043 5.79722 22.0529C7.25979 22.2603 8.73123 22.3098 10.2056 22.2355C11.8573 22.1519 13.4912 21.9352 15.0661 21.3719C15.5329 21.2047 15.988 21.0066 16.3898 20.697C16.57 20.5577 16.7444 20.3967 16.8832 20.2141C17.1521 19.8612 17.161 19.4681 16.8832 19.1245C16.6941 18.8892 16.4607 18.6756 16.2125 18.5084C15.5182 18.041 14.7381 17.7748 13.9404 17.5829C13.2785 17.425 12.6078 17.3228 11.94 17.1959C11.8809 17.1835 11.8248 17.1743 11.7657 17.165C11.875 16.9235 11.8957 16.9173 12.135 16.9359C13.1219 17.0164 14.1058 17.1278 15.072 17.3538C15.5979 17.4745 16.118 17.62 16.5937 17.8831C16.8921 18.0472 17.1876 18.2391 17.4328 18.4744C18.0622 19.0811 18.1744 19.9231 17.7726 20.7156C17.5569 21.1428 17.2407 21.4802 16.8803 21.7743C16.0943 22.4151 15.1991 22.8392 14.2595 23.1642C12.2828 23.8483 10.247 24.0743 8.17279 23.9814C6.58021 23.9071 5.02309 23.6378 3.51619 23.0744C2.58842 22.7277 1.70496 22.2943 0.948562 21.6133C0.617636 21.3161 0.33694 20.9694 0.159659 20.5453C-0.138766 19.8303 -0.00284963 19.0749 0.520131 18.5208C0.957426 18.0565 1.50995 17.7996 2.08612 17.5983C2.87502 17.3228 3.69052 17.1804 4.51192 17.0752C4.96695 17.0164 5.42197 16.9823 5.87995 16.9328C6.10155 16.9111 6.11928 16.9235 6.23156 17.1619Z"
                                            fill="#51553A" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1990_518">
                                            <rect width="18" height="24" fill="#51553A" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="mb-0 text-dark fw-5">New York, USA</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="our-services-section pt-50 px-30">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">SERVICES</h2>
                    <h4 class="mb-0">Our Services</h4>
                </div>
                <div class="services">
                    <div class="row">
                        <div class="col-12 mb-40">
                            <div class="service-card h-100">
                                <div class="card-img d-flex justify-content-center align-items-center">
                                    <svg width="36" height="28" viewBox="0 0 36 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_1276_369)">
                                            <path
                                                d="M0 25.2152C0 19.6437 0 14.0722 0 8.50075C0.0704501 8.49791 0.139961 8.49225 0.210411 8.49225C12.0301 8.49225 23.8506 8.49225 35.6703 8.49225C35.7717 8.49225 35.8732 8.50452 35.9822 8.51208C35.9897 8.58007 35.9991 8.6254 35.9991 8.67072C35.9991 14.0628 36.0056 19.4558 35.985 24.8478C35.9831 25.2803 35.8647 25.7478 35.6769 26.1387C35.0513 27.4372 33.9767 28.0009 32.5508 27.999C22.8625 27.9896 13.1751 27.9943 3.48681 27.9943C3.35812 27.9943 3.22943 27.9934 3.10074 27.9887C1.75374 27.9386 0.590841 27.067 0.166262 25.7856C0.103327 25.5976 0.0544814 25.405 0 25.2152ZM9.16509 22.2557C8.06419 22.2557 7.01589 22.2557 5.95632 22.2557C5.95632 20.9289 5.95632 19.6277 5.95632 18.2905C6.51992 18.2905 7.05628 18.2981 7.59264 18.2877C8.0191 18.2792 8.32908 18.062 8.50568 17.6767C8.67663 17.3056 8.63624 16.9382 8.39577 16.6058C8.16188 16.2829 7.82654 16.1686 7.44423 16.1677C6.95389 16.1667 6.46356 16.1677 5.95726 16.1677C5.95726 15.1506 5.95726 14.1695 5.95726 13.1619C6.48798 13.1619 6.99053 13.1695 7.49307 13.16C8.15061 13.1468 8.60806 12.6973 8.60337 12.0854C8.59867 11.4735 8.14027 11.0438 7.47429 11.0391C6.70121 11.0334 5.92814 11.0372 5.15507 11.0381C4.18568 11.0381 3.82027 11.4064 3.81933 12.3847C3.81933 15.9363 3.81933 19.4888 3.81933 23.0404C3.81933 24.0329 4.18943 24.405 5.17949 24.4059C8.54231 24.4069 11.9042 24.4069 15.267 24.405C15.4192 24.405 15.5723 24.4031 15.7226 24.3804C16.2186 24.3049 16.5915 23.93 16.6027 23.4257C16.6243 22.4701 16.6243 21.5144 16.6027 20.5588C16.5905 20.0422 16.1979 19.6598 15.6906 19.5946C15.2163 19.5332 14.7325 19.8203 14.5841 20.2802C14.5268 20.4558 14.5146 20.6504 14.5108 20.8373C14.5014 21.3057 14.508 21.775 14.508 22.2585C13.4146 22.2585 12.3673 22.2585 11.2739 22.2585C11.2739 22.1112 11.2739 21.9856 11.2739 21.8591C11.272 21.4341 11.2842 21.0092 11.2645 20.5852C11.242 20.0875 10.9104 19.7108 10.4435 19.6107C9.77753 19.469 9.19515 19.9421 9.16978 20.6683C9.151 21.1848 9.16509 21.7033 9.16509 22.2557ZM25.1939 17.8438C23.4495 17.8438 21.7043 17.8429 19.9599 17.8438C19.1474 17.8448 18.7388 18.2414 18.736 19.0488C18.7303 20.4284 18.7313 21.8081 18.736 23.1887C18.7388 23.9744 19.1493 24.4012 19.9233 24.4021C23.4355 24.4069 26.9486 24.4078 30.4607 24.4021C31.2432 24.4012 31.6434 23.9791 31.6443 23.1906C31.6462 21.8109 31.6462 20.4313 31.6443 19.0507C31.6434 18.2461 31.2376 17.8448 30.4269 17.8438C28.6835 17.8429 26.9382 17.8438 25.1939 17.8438ZM25.1911 13.1619C26.9241 13.1619 28.6582 13.1638 30.3912 13.1591C30.565 13.1591 30.7454 13.1449 30.9107 13.0967C31.3653 12.9645 31.6603 12.5292 31.6434 12.0514C31.6274 11.5802 31.2902 11.159 30.8318 11.0646C30.673 11.0315 30.5058 11.0381 30.3424 11.0381C26.911 11.0372 23.4796 11.0372 20.0482 11.0372C19.9308 11.0372 19.8134 11.0344 19.6969 11.0438C19.1981 11.0853 18.8064 11.4735 18.7491 11.9777C18.6937 12.4612 18.9793 12.9381 19.4395 13.0854C19.6142 13.1411 19.8077 13.1572 19.9919 13.1581C21.7249 13.1638 23.458 13.1619 25.1911 13.1619ZM22.4802 16.4415C23.3462 16.4415 24.2113 16.4434 25.0774 16.4406C25.7735 16.4387 26.2328 16.0213 26.2394 15.3962C26.245 14.7691 25.7829 14.3206 25.1018 14.3187C23.3584 14.313 21.615 14.313 19.8716 14.3187C19.2141 14.3215 18.7472 14.7672 18.7397 15.3716C18.7322 15.9901 19.2056 16.4368 19.8829 16.4396C20.748 16.4444 21.6141 16.4415 22.4802 16.4415Z"
                                                fill="#51553A" />
                                            <path
                                                d="M-3.72278e-05 2.76407C0.0572622 2.57521 0.109865 2.38445 0.1728 2.19748C0.622742 0.869768 1.82509 0.00760486 3.25945 0.00382758C5.96568 -0.00278265 8.6719 0.00193895 11.3781 0.00193895C18.4307 0.00193895 25.4832 0.00193895 32.5357 0.00193895C34.6614 0.00193895 35.999 1.35137 36 3.49309C36 4.43552 36 5.37794 36 6.36759C35.8271 6.36759 35.6797 6.36759 35.5312 6.36759C23.8393 6.36759 12.1474 6.36759 0.45554 6.36759C0.303368 6.36759 0.151196 6.37326 -0.000976562 6.37609C-3.72278e-05 5.17208 -3.72278e-05 3.96808 -3.72278e-05 2.76407ZM4.02783 2.24847C4.02783 2.24942 4.02783 2.25036 4.02783 2.25036C3.7357 2.25036 3.44262 2.23431 3.15143 2.25414C2.62259 2.29002 2.21397 2.71969 2.18392 3.24378C2.1548 3.76222 2.5155 4.27876 3.04153 4.32314C3.69061 4.37791 4.35096 4.3798 4.9991 4.32503C5.54861 4.27876 5.89523 3.76883 5.85578 3.2164C5.81726 2.68664 5.41147 2.28058 4.87041 2.25036C4.58955 2.23525 4.30775 2.24847 4.02783 2.24847ZM8.74799 2.24942C8.45585 2.24942 8.16278 2.23525 7.87159 2.25225C7.33993 2.28436 6.92568 2.70552 6.89186 3.22773C6.85711 3.75372 7.2056 4.27404 7.73069 4.31936C8.3901 4.37697 9.06266 4.37697 9.72208 4.32031C10.2528 4.27498 10.5891 3.7726 10.56 3.23245C10.5318 2.70458 10.126 2.2853 9.58869 2.25225C9.31065 2.23525 9.02885 2.24942 8.74799 2.24942ZM13.4108 4.36469C13.4108 4.36375 13.4108 4.36375 13.4108 4.3628C13.6917 4.3628 13.9735 4.38074 14.2525 4.35903C14.8687 4.31086 15.2801 3.85854 15.267 3.27023C15.2538 2.68569 14.8133 2.25886 14.1924 2.24658C13.6898 2.2362 13.1863 2.23714 12.6838 2.24658C12.0638 2.25792 11.6158 2.68192 11.597 3.25984C11.5773 3.85759 12.0056 4.31842 12.6387 4.36091C12.8961 4.37886 13.1544 4.36469 13.4108 4.36469Z"
                                                fill="#51553A" />
                                            <path
                                                d="M20.8638 22.251C20.8638 21.4794 20.8638 20.741 20.8638 19.9855C23.7494 19.9855 26.6144 19.9855 29.5075 19.9855C29.5075 20.7297 29.5075 21.4766 29.5075 22.251C26.6416 22.251 23.7691 22.251 20.8638 22.251Z"
                                                fill="#51553A" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1276_369">
                                                <rect width="36" height="28" fill="#51553A" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-dark">Space Planning</h3>
                                    <p class="mb-0 fs-14 text-gray">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="service-card h-100">
                                <div class="card-img d-flex justify-content-center align-items-center">
                                    <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_1276_379)">
                                            <path
                                                d="M27.9973 19.9999C26.2958 19.9999 24.6409 19.9915 22.986 20.0024C21.5943 20.0116 20.4225 20.9347 20.0951 22.2735C20.0268 22.5531 20.0044 22.8494 20.0027 23.1382C19.9935 24.7207 19.9977 26.304 19.9969 27.8865C19.9969 27.9065 19.991 27.9274 19.9802 27.9967C19.8894 27.9967 19.7911 27.9967 19.692 27.9967C18.1721 27.9967 16.6513 27.9984 15.1313 27.9958C13.2948 27.9933 12.0022 26.7063 12.0014 24.8734C11.9989 20.292 11.9989 15.7098 12.0014 11.1284C12.0022 9.293 13.2932 8.00263 15.1263 8.00096C18.3753 7.99846 21.6243 7.99846 24.8733 8.00096C26.7089 8.00263 27.9957 9.28966 27.9973 11.1276C28.0007 13.9804 27.9982 16.8341 27.9982 19.6869C27.9973 19.7804 27.9973 19.8722 27.9973 19.9999ZM20.0285 12.0014C19.0599 12.0014 18.0921 12.0006 17.1235 12.0014C16.4564 12.0023 16.005 12.4029 16.0016 12.9938C15.9983 13.5839 16.453 13.9996 17.1118 14.0004C19.0382 14.0021 20.9638 14.0021 22.8902 14.0004C23.5473 13.9996 24.0029 13.5814 23.9979 12.9913C23.9929 12.4146 23.5407 12.0031 22.9027 12.0014C21.9441 11.9998 20.9863 12.0014 20.0285 12.0014ZM18.9941 18.0001C19.6504 18.0001 20.3059 18.0051 20.9621 17.9984C21.551 17.9926 21.9916 17.5677 21.9982 17.0127C22.0049 16.4451 21.5593 16.0044 20.9563 16.0019C19.6546 15.9969 18.3536 15.9977 17.0519 16.0019C16.4422 16.0036 16 16.4318 16.0008 17.0027C16.0016 17.5702 16.448 17.9951 17.0577 17.9992C17.7032 18.0034 18.3486 18.0001 18.9941 18.0001Z"
                                                fill="#51553A" />
                                            <path
                                                d="M0.00355189 21.9763C0.00355189 20.686 0.0010533 19.3948 0.00438475 18.1044C0.00688334 16.8524 0.851406 16.0028 2.09737 16.0011C4.03294 15.9986 5.96935 15.9986 7.90492 16.0011C9.15171 16.0028 9.99873 16.8516 10.0004 18.1027C10.0029 20.7052 10.0037 23.3068 10.0004 25.9092C9.99873 27.1412 9.14838 27.995 7.92241 27.9975C5.97601 28.0017 4.02961 28.0017 2.08321 27.9975C0.856403 27.995 0.00688334 27.1412 0.00355189 25.9117C0.0010533 24.5997 0.00355189 23.2884 0.00355189 21.9763ZM4.00296 21.9839C4.00296 22.3277 3.99463 22.6708 4.00462 23.0147C4.02128 23.573 4.46686 24.0029 5.00989 23.9979C5.54125 23.9937 5.98517 23.573 5.99683 23.0288C6.01099 22.3419 6.01182 21.655 5.99683 20.9681C5.98517 20.4247 5.53959 20.0041 5.00822 20.0007C4.46186 19.9974 4.02128 20.4231 4.00462 20.9848C3.99546 21.3178 4.00296 21.6508 4.00296 21.9839Z"
                                                fill="#51553A" />
                                            <path
                                                d="M21.1096 0.0033489C22.6921 0.0033489 24.2737 0.00251425 25.8561 0.0033489C27.1662 0.00418355 27.9958 0.837164 27.9983 2.15341C27.9991 2.76771 28.0041 3.38201 27.9966 3.99548C27.9824 5.12726 27.1237 5.99697 25.9936 5.99947C22.7354 6.00698 19.4781 6.00782 16.2199 5.99279C15.9184 5.99112 15.6011 5.90098 15.3187 5.78413C14.6175 5.49534 13.9312 5.1715 13.2424 4.8535C12.4504 4.48792 12.0065 3.86861 12.0098 2.99223C12.0131 2.13004 12.4512 1.51657 13.2316 1.15683C13.9204 0.838833 14.605 0.509981 15.3088 0.22787C15.6286 0.0993336 15.9892 0.0175379 16.3332 0.01253C17.9248 -0.00917084 19.5172 0.0033489 21.1096 0.0033489Z"
                                                fill="#51553A" />
                                            <path
                                                d="M8.8626 13.8509C8.54694 13.9069 8.28792 13.992 8.02724 13.9937C6.00671 14.0045 3.98619 14.0095 1.9665 13.9962C0.887939 13.9887 0.0117671 13.1206 0.00843562 12.0439C-0.00239159 8.68028 -0.00322445 5.31665 0.00843562 1.95301C0.0125999 0.892169 0.882941 0.0174567 1.94234 0.00911017C3.98369 -0.00674817 6.02503 -7.09744e-05 8.06555 0.0116141C8.31457 0.0132834 8.56277 0.101756 8.86926 0.161851C8.43617 0.640105 8.05972 1.0566 7.6816 1.47142C6.64552 2.61238 5.60611 3.75084 4.57169 4.89264C3.40985 6.17466 3.41318 7.84063 4.57585 9.1168C5.92176 10.5958 7.266 12.0756 8.61107 13.5555C8.67854 13.6306 8.74267 13.7099 8.8626 13.8509Z"
                                                fill="#51553A" />
                                            <path
                                                d="M9.97258 12.079C8.73661 10.7211 7.55895 9.38645 6.33547 8.09525C5.49678 7.20969 5.52843 6.76398 6.33547 5.91014C7.55728 4.61726 8.73578 3.28433 9.97258 1.92468C9.97258 5.32421 9.97258 8.67116 9.97258 12.079Z"
                                                fill="#51553A" />
                                            <path
                                                d="M27.3079 21.9997C25.5306 23.7725 23.7724 25.5244 22.0184 27.2738C22.0151 27.243 22.0001 27.1678 22.0001 27.0927C21.9984 25.7606 21.9976 24.4277 22.0001 23.0956C22.0018 22.4095 22.4032 22.0022 23.082 22.0005C24.4862 21.9972 25.8912 21.9997 27.3079 21.9997Z"
                                                fill="#51553A" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1276_379">
                                                <rect width="28" height="28" fill="#51553A" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-dark">
                                        Interior Design Consultation
                                    </h3>
                                    <p class="mb-0 fs-14 text-gray">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gallery-section pt-50 pb-50">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">PHOTOS</h2>
                    <h4 class="mb-0">Gallery</h4>
                </div>
                <div class="gallery-slider">
                    <div>
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard32/gallery-img1.png') }}"
                                class="w-100 h-100 object-fit-cover" />
                        </div>
                    </div>
                    <div>
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard32/gallery-img2.png') }}"
                                class="w-100 h-100 object-fit-cover" />
                        </div>
                    </div>
                    <div>
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard32/gallery-img3.png') }}"
                                class="w-100 h-100 object-fit-cover" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="appointment-section pt-40 pb-40 px-30">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">BOOK NOW</h2>
                    <h4 class="mb-0 text-white">Make an Appointment</h4>
                </div>
                <div class="appointment px-2">
                    <div class="mb-20">
                        <label for="date" class="appoint-date text-white fs-6 fw-5 mb-1">Date:</label>
                        <div class="row">
                            <div class="col-12 px-2">
                                <div class="position-relative">
                                    <input type="text" class="form-control appointment-input" />
                                    <span class="calendar-icon"><svg width="20" height="20"
                                            viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M6.25 9.375V10.625C6.25 10.9705 5.97047 11.25 5.625 11.25H4.375C4.02953 11.25 3.75 10.9705 3.75 10.625V9.375C3.75 9.02953 4.02953 8.75 4.375 8.75H5.625C5.97047 8.75 6.25 9.02953 6.25 9.375ZM5.625 13.75H4.375C4.02953 13.75 3.75 14.0295 3.75 14.375V15.625C3.75 15.9705 4.02953 16.25 4.375 16.25H5.625C5.97047 16.25 6.25 15.9705 6.25 15.625V14.375C6.25 14.0295 5.97047 13.75 5.625 13.75ZM10.625 8.75H9.375C9.02953 8.75 8.75 9.02953 8.75 9.375V10.625C8.75 10.9705 9.02953 11.25 9.375 11.25H10.625C10.9705 11.25 11.25 10.9705 11.25 10.625V9.375C11.25 9.02953 10.9705 8.75 10.625 8.75ZM10.625 13.75H9.375C9.02953 13.75 8.75 14.0295 8.75 14.375V15.625C8.75 15.9705 9.02953 16.25 9.375 16.25H10.625C10.9705 16.25 11.25 15.9705 11.25 15.625V14.375C11.25 14.0295 10.9705 13.75 10.625 13.75ZM15.625 8.75H14.375C14.0295 8.75 13.75 9.02953 13.75 9.375V10.625C13.75 10.9705 14.0295 11.25 14.375 11.25H15.625C15.9705 11.25 16.25 10.9705 16.25 10.625V9.375C16.25 9.02953 15.9705 8.75 15.625 8.75ZM15.625 13.75H14.375C14.0295 13.75 13.75 14.0295 13.75 14.375V15.625C13.75 15.9705 14.0295 16.25 14.375 16.25H15.625C15.9705 16.25 16.25 15.9705 16.25 15.625V14.375C16.25 14.0295 15.9705 13.75 15.625 13.75ZM4.375 3.75H5.625C5.97047 3.75 6.25 3.47047 6.25 3.125V0.625C6.25 0.279531 5.97047 0 5.625 0H4.375C4.02953 0 3.75 0.279531 3.75 0.625V3.125C3.75 3.47047 4.02953 3.75 4.375 3.75ZM20 5V17.5C20 18.8806 18.8806 20 17.5 20H2.5C1.11937 20 0 18.8806 0 17.5V5C0 3.61937 1.11937 2.5 2.5 2.5H3.125V3.125C3.125 3.81348 3.6859 4.375 4.375 4.375H5.625C6.3141 4.375 6.875 3.81348 6.875 3.125V2.5H13.125V3.125C13.125 3.81348 13.6865 4.375 14.375 4.375H15.625C16.3135 4.375 16.875 3.81348 16.875 3.125V2.5H17.5C18.8806 2.5 20 3.61937 20 5ZM18.75 7.5C18.75 6.81152 18.1897 6.25 17.5 6.25H2.5C1.8109 6.25 1.25 6.81152 1.25 7.5V17.5C1.25 18.1897 1.8109 18.75 2.5 18.75H17.5C18.1897 18.75 18.75 18.1897 18.75 17.5V7.5ZM14.375 3.75H15.625C15.9705 3.75 16.25 3.47047 16.25 3.125V0.625C16.25 0.279531 15.9705 0 15.625 0H14.375C14.0295 0 13.75 0.279531 13.75 0.625V3.125C13.75 3.47047 14.0295 3.75 14.375 3.75Z"
                                                fill="#FBD77A" />
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <label class="text-white fs-6 fw-5 mb-1">Hour:</label>
                        <div class="mb-40">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-dark fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-dark fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-dark fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-dark fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center px-sm-4 mx-sm-3">
                            <button type="submit" class="btn btn-primary">
                                Make An Appointment
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-section pt-50 px-30">
                <div class="product-bg text-end">
                    <img src="{{ asset('assets/img/vcard32/product-bg.png') }}" alt="bg" />
                </div>
                <div class="section-heading">
                    <h2 class="mb-0 main-text">INTERIOR</h2>
                    <h4 class="mb-0">Products</h4>
                </div>
                <div class="product-slider">
                    <div>
                        <div class="product-card card">
                            <div class="product-img card-img">
                                <img src="{{ asset('assets/img/vcard32/product-img1.png') }}" class="h-100" />
                            </div>
                            <div class="product-desc mt-auto">
                                <h3 class="text-dark fs-6 mb-1">Stylish Brown Chair</h3>
                                <p class="fs-14 text-gray mb-0">Lorem Ipsum dummy</p>
                                <p class="amount fs-6 mb-0 fw-6 text-secondary">$25.00</p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="product-card card">
                            <div class="product-img card-img">
                                <img src="{{ asset('assets/img/vcard32/product-img2.png') }}" class="h-100" />
                            </div>
                            <div class="product-desc mt-auto">
                                <h3 class="text-dark fs-6 mb-1">Modern Grey Sofa</h3>
                                <p class="fs-14 text-gray mb-0">Lorem Ipsum dummy</p>
                                <p class="amount fs-6 mb-0 fw-6 text-secondary">$25.00</p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="product-card card">
                            <div class="product-img card-img">
                                <img src="{{ asset('assets/img/vcard32/product-img1.png') }}" class="h-100" />
                            </div>
                            <div class="product-desc mt-auto">
                                <h3 class="text-dark fs-6 mb-1">Stylish Brown Chair</h3>
                                <p class="fs-14 text-gray mb-0">Lorem Ipsum dummy</p>
                                <p class="amount fs-6 mb-0 fw-6 text-secondary">$25.00</p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="product-card card">
                            <div class="product-img card-img">
                                <img src="{{ asset('assets/img/vcard32/product-img2.png') }}" class="h-100" />
                            </div>
                            <div class="product-desc mt-auto">
                                <h3 class="text-dark fs-6 mb-1">Modern Grey Sofa</h3>
                                <p class="fs-14 text-gray mb-0">Lorem Ipsum dummy</p>
                                <p class="amount fs-6 mb-0 fw-6 text-secondary">$25.00</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial-section pt-50 px-30">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">FEEDBACK</h2>
                    <h4 class="mb-0">Testimonial</h4>
                </div>
                <div class="testimonial-bg">
                    <img src="{{ asset('assets/img/vcard32/testimonial-bg.png') }}" alt="bg-img" />
                </div>
                <div class="quote-img text-end">
                    <img src="{{ asset('assets/img/vcard32/quote-img.png') }}" alt="bg-img" />
                </div>
                <div class="testimonial-slider">
                    <div>
                        <div class="testimonial-card card">
                            <div class="card-body p-0 mb-20">
                                <p class="desc text-gray fs-14 mb-0">
                                    When potential customers are researching you online, they're
                                    getting to know you through the content on your website. So
                                    understandably, many of them might be skeptical or hesitant
                                    to trust you right away.
                                </p>
                            </div>
                            <div class="d-flex gap-3 align-items-center">
                                <div class="card-img testimonial-profile-img">
                                    <img src="{{ asset('assets/img/vcard32/testimonial-profile.png') }}"
                                        class="w-100 h-100 object-fit-cover" />
                                </div>
                                <h6 class="text-dark mb-0">James Brown</h6>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="testimonial-card card">
                            <div class="card-body p-0 mb-20">
                                <p class="desc text-gray fs-14 mb-0">
                                    When potential customers are researching you online, they're
                                    getting to know you through the content on your website. So
                                    understandably, many of them might be skeptical or hesitant
                                    to trust you right away.
                                </p>
                            </div>
                            <div class="d-flex gap-3 align-items-center">
                                <div class="card-img testimonial-profile-img">
                                    <img src="{{ asset('assets/img/vcard32/testimonial-profile.png') }}"
                                        class="w-100 h-100 object-fit-cover" />
                                </div>
                                <h6 class="text-dark mb-0">James Brown</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-section pt-50">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">ARTICLE</h2>
                    <h4 class="mb-0">Blog</h4>
                </div>
                <div class="blog-slider pt-30">
                    <div class="px-30">
                        <div class="blog-card card flex-sm-row gap-4">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard32/blog-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 ps-sm-3">
                                <h2 class="fs-18 fw-5 text-dark">Color Psychology</h2>
                                <p class="text-gray blog-desc w-5 fs-14 mb-0">
                                    It is a long established fact that a reader will be
                                    distracted by the readable content of a page when looking.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="px-30">
                        <div class="blog-card card flex-sm-row gap-4">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard32/blog-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 ps-sm-3">
                                <h2 class="fs-18 fw-5 text-dark">Color Psychology</h2>
                                <p class="text-gray blog-desc w-5 fs-14 mb-0">
                                    It is a long established fact that a reader will be
                                    distracted by the readable content of a page when looking.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="px-30">
                        <div class="blog-card card flex-sm-row gap-4">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard32/blog-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 ps-sm-3">
                                <h2 class="fs-18 fw-5 text-dark">Color Psychology</h2>
                                <p class="text-gray blog-desc w-5 fs-14 mb-0">
                                    It is a long established fact that a reader will be
                                    distracted by the readable content of a page when looking.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="px-30">
                        <div class="blog-card card flex-sm-row gap-4">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard32/blog-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 ps-sm-3">
                                <h2 class="fs-18 fw-5 text-dark">Color Psychology</h2>
                                <p class="text-gray blog-desc w-5 fs-14 mb-0">
                                    It is a long established fact that a reader will be
                                    distracted by the readable content of a page when looking.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="business-hour-section pt-50 pb-50 px-30">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">SCHEDULE</h2>
                    <h4 class="mb-0">Business Hours</h4>
                </div>
                <div class="business-hour-img text-end">
                    <img src="{{ asset('assets/img/vcard32/business-hour-bg.png') }}" alt="bg-img" />
                </div>
                <div class="business-hour-card row justify-content-center position-relative">
                    <div class="col-sm-6 mb-3 pe-sm-2">
                        <div class="business-hour">
                            <span class="me-2">Sunday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3 ps-sm-2">
                        <div class="business-hour">
                            <span class="me-2">Monday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3 pe-sm-2">
                        <div class="business-hour">
                            <span class="me-2">Tueday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3 ps-sm-2">
                        <div class="business-hour">
                            <span class="me-2">Wednesday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3 pe-sm-2">
                        <div class="business-hour">
                            <span class="me-2">Thursday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3 ps-sm-2">
                        <div class="business-hour">
                            <span class="me-2">Friday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="business-hour">
                            <span class="me-2">Saturday:</span>
                            <span>Closed</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="qr-code-section pt-40 pb-40 px-40">
                <div class="section-heading">
                    <h2 class="mb-0 main-text">SCAN</h2>
                    <h4 class="mb-0">QR Code</h4>
                </div>
                <div class="qr-code-bg mb-40">
                    <div class="qr-code">
                        <div class="qr-profile-img">
                            <img src="{{ asset('assets/img/vcard32/qr-profile-img.jpg') }}"
                                class="w-100 h-100 object-fit-cover" />
                        </div>
                        <div class="qr-code-img">
                            <img src="{{ asset('assets/img/vcard32/qr-code-img.png') }}"
                                class="w-100 h-100 object-fit-cover" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-us-section pt-50 pb-40 px-40">
                <div class="contact-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard32/contact-bg.png') }}" alt="bg-img" />
                </div>
                <div class="section-heading">
                    <h2 class="mb-0 main-text">MESSAGE</h2>
                    <h4 class="mb-0">Contact Us</h4>
                </div>
                <div class="contact-form">
                    <form action="">
                        <div class="row">
                            <div class="col-sm-6">
                                <input type="text" class="form-control" placeholder="Full Name" />
                            </div>
                            <div class="col-sm-6">
                                <input type="tel" class="form-control" placeholder="Phone Number" />
                            </div>
                            <div class="col-12">
                                <input type="email" class="form-control" placeholder="Email Address" />
                            </div>
                            <div class="col-12 mb-30">
                                <textarea class="form-control h-100" placeholder="Your Message" rows="3"></textarea>
                            </div>
                            <div class="col-12 text-center p-4">
                                <button class="btn btn-primary" type="submit">
                                    Send Message
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="create-vcard-section pt-40 pb-60 px-40">
                <div class="content">
                    <div class="section-heading">
                        <h2 class="mb-0 main-text">CREATE</h2>
                        <h4 class="mb-0">Your VCard</h4>
                    </div>
                    <div>
                        <div class="mb-4 pb-3">
                            <div class="vcard-link-card card mx-sm-3 mb-5">
                                <div class="d-flex align-items-center justify-content-center">
                                    <a href="https://vcards.infyom.com/marlonbrasil"
                                        class="text-dark link-text fw-5">https://vcards.infyom.com/marlonbrasil</a>
                                    <i class="icon fa-solid fa-arrow-up-right-from-square ms-3 text-secondary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="add-to-contact-section">
                        <div class="text-center">
                            <button class="btn btn-primary">Add to Contact</button>
                        </div>
                    </div>
                </div>
            </div>
            {{-- <div class="btn-section cursor-pointer">
                <div class="fixed-btn-section">
                    <div class="bars-btn interior-bars-btn">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M15.4135 0.540405H22.4891C23.5721 0.540405 24.4602 1.42855 24.4602 2.51152V9.58713C24.4602 10.6773 23.5732 11.5582 22.4891 11.5582H15.4135C14.3223 11.5582 13.4424 10.6783 13.4424 9.58713V2.51152C13.4424 1.42746 14.3234 0.540405 15.4135 0.540405Z"
                                stroke="#ffffff" />
                            <path
                                d="M2.97143 0.5H8.74589C10.1129 0.5 11.2173 1.6122 11.2173 2.97143V8.74589C11.2173 10.1139 10.1139 11.2173 8.74589 11.2173H2.97143C1.6122 11.2173 0.5 10.1129 0.5 8.74589V2.97143C0.5 1.61328 1.61328 0.5 2.97143 0.5Z"
                                stroke="#ffffff" />
                            <path
                                d="M2.97143 13.7828H8.74589C10.1139 13.7828 11.2173 14.8862 11.2173 16.2543V22.0287C11.2173 23.388 10.1129 24.5002 8.74589 24.5002H2.97143C1.61328 24.5002 0.5 23.3869 0.5 22.0287V16.2543C0.5 14.8873 1.6122 13.7828 2.97143 13.7828Z"
                                stroke="#ffffff" />
                            <path
                                d="M16.2537 13.7828H22.0281C23.3873 13.7828 24.4995 14.8873 24.4995 16.2543V22.0287C24.4995 23.3869 23.3863 24.5002 22.0281 24.5002H16.2537C14.8867 24.5002 13.7822 23.388 13.7822 22.0287V16.2543C13.7822 14.8862 14.8856 13.7828 16.2537 13.7828Z"
                                stroke="#ffffff" />
                        </svg>
                    </div>
                    <div class="sub-btn">
                        <div class="social-btn interior-sub-btn wp-btn">
                            <i class="fa-brands fa-whatsapp text-secondary"></i>
                        </div>
                        <div class="social-btn interior-sub-btn wp-btn mt-3">
                            <i class="fa-solid fa-share-nodes text-secondary"></i>
                        </div>
                    </div>
                </div>
            </div> --}}
        </div>
    </div>
</body>
{{-- <script src="../js/jquery.min.js"></script> --}}
{{-- <script src="../js/bootstrap.bundle.min.js"></script>
<script src="../js/slick.min.js"></script> --}}
{{-- <script src="../js/custom.js"></script> --}}
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript" src="{{ asset('assets/js/front-third-party.js') }}"></script>
<script type="text/javascript" src="{{ asset('front/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/js/slider/js/slick.min.js') }}" type="text/javascript"></script>

<script>
    $(document).ready(function() {
        $(".gallery-slider").slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            centerMode: true,
            arrows: false,
            dots: false,
            speed: 300,
            centerPadding: "160px",
            infinite: true,
            autoplaySpeed: 5000,
            autoplay: true,
            responsive: [{
                    breakpoint: 768,
                    settings: {
                        centerPadding: "145px",
                    },
                },
                {
                    breakpoint: 576,
                    settings: {
                        centerPadding: "160px",
                    },
                },
                {
                    breakpoint: 540,
                    settings: {
                        centerPadding: "140px",
                    },
                },
                {
                    breakpoint: 498,
                    settings: {
                        centerPadding: "125px",
                    },
                },
                {
                    breakpoint: 475,
                    settings: {
                        centerPadding: "100px",
                    },
                },
                {
                    breakpoint: 424,
                    settings: {
                        centerPadding: "80px",
                    },
                },
                {
                    breakpoint: 380,
                    settings: {
                        centerPadding: "75px",
                    },
                },
                {
                    breakpoint: 361,
                    settings: {
                        centerPadding: "60px",
                    },
                },
                {
                    breakpoint: 340,
                    settings: {
                        centerPadding: "0",
                    },
                },
            ],
        });
        $(".product-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 490,
                settings: {
                    slidesToShow: 1,
                    dots: true,
                },
            }, ],
        });
        $(".testimonial-slider").slick({
            arrows: true,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            autoplay: true,
            prevArrow: '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-arrow-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow"><i class="fa-solid fa-arrow-right"></i></button>',
            responsive: [{
                breakpoint: 575,
                settings: {
                    arrows: false,
                    dots: true,
                },
            }, ],
        });
        $(".blog-slider").slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: false,
            dots: true,
            speed: 300,
            infinite: true,
            autoplay: true,
        });
    });
</script>

</html>
