<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'Le :attribute doit être accepté.',
    'active_url' => "Le :attribute n'est pas une URL valide.",
    'after' => 'Le :attribute doit être une date après :date.',
    'after_or_equal' => 'Le :attribute doit être une date postérieure ou égale à :date.',
    'alpha' => 'Le :attribute ne doit contenir que des lettres.',
    'alpha_dash' => 'Le :attribute must only contain letters, numbers, dashes and underscores.',
    'alpha_num' => 'Le :attribute ne doit contenir que des lettres et des chiffres.',
    'array' => 'Le :attribute doit être un tableau.',
    'before' => 'Le :attribute doit être une date avant :date.',
    'before_or_equal' => 'Le :attribute doit être une date antérieure ou égale à :date.',
    'between' => [
        'numeric' => 'Le :attribute doit être compris entre :min et :max.',
        'file' => 'Le :attribute doit être compris entre :min et :max kilo-octets.',
        'string' => 'Le :attribute doit être compris entre :min et :max caractères.',
        'array' => 'Le :attribute doit avoir entre :min et :max éléments.',
    ],
    'boolean' => 'Le :attribute champ doit être vrai ou faux.',
    'confirmed' => 'Le :attribute la confirmation ne correspond pas.',
    'current_password' => 'Le mot de passe est incorrect.',
    'date' => 'Le :attribute is not a valid date.',
    'date_equals' => 'Le :attribute doit être une date égale à :date.',
    'date_format' => 'Le :attribute ne correspond pas au format :format.',
    'different' => 'Le :attribute et :other must be different.',
    'digits' => 'Le :attribute doit être :chiffres chiffres.',
    'digits_between' => 'Le :attribute doit être compris entre :min et :max chiffres.',
    'dimensions' => "Le :attribute a des dimensions d'image non valides",
    'distinct' => 'Le :attribute le champ a une valeur en double.',
    'email' => 'Le :attribute doit être une adresse e-mail valides.',
    'ends_with' => 'The :attribute must end with one of the following: :values.',
    'exists' => 'Le choisi :attribute est invalide.',
    'file' => 'Le :attribute doit être un fichier.',
    'filled' => 'Le :attribute le champ doit avoir une valeur.',
    'gt' => [
        'numeric' => 'Le :attribute doit être supérieur à :value.',
        'file' => 'Le :attribute doit être supérieur à :value kilo-octets.',
        'string' => 'Le :attribute doit être supérieur à :value personnages.',
        'array' => 'Le :attribute doit avoir plus de :value éléments.',
    ],
    'gte' => [
        'numeric' => 'Le :attribute doit être supérieur ou égal :value.',
        'file' => 'Le :attribute doit être supérieur ou égal :value kilo-octets.',
        'string' => 'Le :attribute doit être supérieur ou égal :value personnages.',
        'array' => 'Le :attribute must have :value articles ou plus.',
    ],
    'image' => 'Le :attribute doit être une image.',
    'in' => 'Le choisi :attribute est invalide.',
    'in_array' => "Le :attribute le champ n'existe pas dans :other.",
    'integer' => 'Le :attribute Doit être un entier.',
    'ip' => 'Le :attribute doit être une adresse IP valide.',
    'ipv4' => 'Le :attribute doit être une adresse IPv4 valide.',
    'ipv6' => 'Le :attribute doit être une adresse IPv6 valide.',
    'json' => 'Le :attribute doit être une chaîne JSON valide.',
    'lt' => [
        'numeric' => 'Le :attribute doit être inférieur à :value.',
        'file' => 'Le :attribute doit être inférieur à :value kilobytes.',
        'string' => 'Le :attribute doit être inférieur à :value personnages.',
        'array' => 'Le :attribute doit avoir moins de :value éléments.',
    ],
    'lte' => [
        'numeric' => 'Le :attribute must be less than or equal :value.',
        'file' => 'Le :attribute must be less than or equal :value kilo-octets.',
        'string' => 'Le :attribute doit être inférieur ou equal :value personnages.',
        'array' => 'Le :attribute ne doit pas avoir plus de :value éléments.',
    ],
    'max' => [
        'numeric' => 'Le :attribute ne doit pas être supérieur à :max.',
        'file' => 'Le :attribute ne doit pas être supérieur à :max kilobytes.',
        'string' => 'Le :attribute ne doit pas être supérieur à :max personnages.',
        'array' => 'Le :attribute ne doit pas avoir plus de :max éléments.',
    ],
    'mimes' => 'Le :attribute doit être un fichier de taper: :values.',
    'mimetypes' => 'Le :attribute doit être un fichier de type: :values.',
    'min' => [
        'numeric' => 'Le :attribute doit être au moins :min.',
        'file' => 'Le :attribute doit être au moins :min kilo-octets.',
        'string' => 'Le :attribute doit contenir au moins :min caractères.',
        'array' => 'Le :attribute doit avoir au moins :min éléments.',
    ],
    'multiple_of' => 'Le :attribute doit être un multiple de :value.',
    'not_in' => 'Le choisi :attribute is invalid.',
    'not_regex' => "Le :attribute le format n'est pas valide.",
    'numeric' => 'Le :attribute doit être un nombre.',
    'password' => 'Le password is incorrect.',
    'present' => 'Le :attribute field must be present.',
    'regex' => 'Le :attribute format is invalid.',
    'required' => 'Le :attribute Champ requis.',
    'required_if' => 'Le :attribute champ est obligatoire lorsque :other vaut :value.',
    'required_unless' => 'Le :attribute champ est obligatoire sauf si :other est dans :values.',
    'required_with' => 'Le :attribute field is required when :values is present.',
    'required_with_all' => 'Le :attribute le champ est obligatoire lorsque :des valeurs sont présentes.',
    'required_without' => 'Le :attribute field is required when :values is not present.',
    'required_without_all' => "Le :attributele champ est obligatoire lorsqu'aucune des :valeurs n'est présente.",
    'prohibited' => 'Le :attribute le terrain est interdit.',
    'prohibited_if' => 'Le :attribute le champ est interdit lorsque :other vaut :value.',
    'prohibited_unless' => 'Le :attribute le champ est interdit sauf si :other est dans :values.',
    'same' => 'Le :attribute et : autre doit correspondre.',
    'size' => [
        'numeric' => 'Le :attribute doit être :size.',
        'file' => 'Le :attribute doit être :size kilo-octets.',
        'string' => 'Le :attribute doit être :size personnages.',
        'array' => 'Le :attribute doit contenir :size éléments.',
    ],
    'starts_with' => "Le :attribute doit commencer par l'un des éléments suivants: :values.",
    'string' => 'Le :attribute doit être une chaîne.',
    'timezone' => 'Le :attribute doit être un fuseau horaire valide.',
    'unique' => 'Le :attribute a déjà été pris.',
    'uploaded' => 'Le :attribute échec du téléchargement.',
    'url' => 'Le :attribute doit être une URL valide.',
    'uuid' => 'Le :attribute doit être un UUID valide.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'message personnalisé',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'location_url' => 'URL de localisation',
        'service_url' => 'Service URL',
        'name' => 'Nom',
        'email' => 'Email',
        'phone' => 'Téléphone',
        'message' => 'Message',
        'link' => 'Lien',
        'amount' => 'Montant',
        'Password' => 'Mot de passe',
        'expire_at' => 'Date d\'expiration',
        'current_password' => 'Mot de passe actuel',
        'new_password' => 'Nouveau mot de passe',
        'confirm_password' => 'Confirmer le mot de passe',
        'video_file' => 'Fichier vidéo',
        'audio_file' => 'Fichier audio',
        'gallery_upload_file' => 'Fichier de téléchargement de galerie',
        'image' => 'Image',
        'short_code' => 'Petit code',
        'occupation' => 'Occupation',
        'ecard-logo' => 'Logo de la carte électronique',
    ],

    'coupon_code' => [
        'not_found' => 'Code promo introuvable',
        'expired' => 'Ce code promo est expiré',
    ],

];
